/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.XMLResourceParseException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TeXSymbolParser {
    private static Map a = new HashMap();
    private Element a;

    public TeXSymbolParser() {
        this(TeXSymbolParser.class.getResourceAsStream("TeXSymbols.xml"), "TeXSymbols.xml");
    }

    public TeXSymbolParser(InputStream inputStream, String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.setIgnoringComments(true);
            this.a = documentBuilderFactory.newDocumentBuilder().parse(inputStream).getDocumentElement();
            this.setTypeMappings();
        }
        catch (Exception exception) {
            throw new XMLResourceParseException(string, exception);
        }
    }

    public Map readSymbols() {
        HashMap<String, SymbolAtom> hashMap = new HashMap<String, SymbolAtom>();
        NodeList nodeList = this.a.getElementsByTagName("Symbol");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = TeXSymbolParser.getAttrValueAndCheckIfNotNull("name", element);
            String string2 = TeXSymbolParser.getAttrValueAndCheckIfNotNull("type", element);
            String string3 = element.getAttribute("del");
            boolean bl = string3 != null && string3.equals("true");
            Object v = a.get(string2);
            if (v == null) {
                throw new XMLResourceParseException("TeXSymbols.xml", "Symbol", "type", "has an unknown value '" + string2 + "'!");
            }
            hashMap.put(string, new SymbolAtom(string, (Integer)v, bl));
        }
        return hashMap;
    }

    private void setTypeMappings() {
        a.put("ord", 0);
        a.put("op", 1);
        a.put("bin", 2);
        a.put("rel", 3);
        a.put("open", 4);
        a.put("close", 5);
        a.put("punct", 6);
        a.put("acc", 10);
    }

    private static String getAttrValueAndCheckIfNotNull(String string, Element element) {
        String string2 = element.getAttribute(string);
        if (string2.equals("")) {
            throw new XMLResourceParseException("TeXSymbols.xml", element.getTagName(), string, null);
        }
        return string2;
    }
}

