/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import org.nfunk.jep.JEP;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.Floor;
import org.nfunk.jep.function.If;
import org.nfunk.jep.function.Round;

public class Expression {
    private String chaineOriginale = "";
    private String chaineMinuscules;
    private JEP objetExpression;
    private boolean erreurParsing;
    private boolean erreurEval;
    private int posErreur = -1;

    public Expression(String chaine) {
        this.chaineOriginale = chaine;
        this.chaineMinuscules = chaine.toLowerCase();
        this.objetExpression = new JEP();
        this.objetExpression.addStandardConstants();
        this.objetExpression.addStandardFunctions();
        this.objetExpression.setAllowUndeclared(true);
        this.objetExpression.setImplicitMul(true);
        this.objetExpression.addFunction("si", new If());
        this.objetExpression.addFunction("ent", new Floor());
        this.objetExpression.addFunction("arrondir", new Round());
        this.objetExpression.parseExpression(this.chaineMinuscules);
    }

    public void valeur(String nom, double val) {
        this.objetExpression.setVarValue(nom, val);
    }

    public double valeurVar(String nom) {
        return (Double)this.objetExpression.getVarValue(nom);
    }

    public double eval() {
        return this.objetExpression.getValue();
    }

    public double eval(double x) {
        this.objetExpression.setVarValue("x", x);
        return this.objetExpression.getValue();
    }

    public int posErreur() {
        String temp = this.objetExpression.getErrorInfo();
        if (temp == null) {
            return 0;
        }
        int debut = temp.indexOf("column ");
        int fin = temp.indexOf(".");
        return Integer.parseInt(temp.substring(debut + 7, fin));
    }

    public String erreurParsing() {
        return this.objetExpression.getErrorInfo();
    }

    public boolean erreurEval() {
        return false;
    }

    public int nbDeVariables() {
        if (this.objetExpression.hasError()) {
            return 0;
        }
        SymbolTable table = this.objetExpression.getSymbolTable();
        return table.size() - 2;
    }

    public String[] nomsDesVariables() {
        if (this.objetExpression.hasError()) {
            return null;
        }
        SymbolTable table = this.objetExpression.getSymbolTable();
        String[] nomsVar = new String[table.size() - 2];
        int i = 0;
        Enumeration e = table.elements();
        while (e.hasMoreElements()) {
            Variable var = (Variable)e.nextElement();
            String leNom = var.getName();
            if (leNom.equals("e") || leNom.equals("pi")) continue;
            nomsVar[i] = leNom;
            ++i;
        }
        return nomsVar;
    }

    public String chaineOriginale() {
        return this.chaineOriginale;
    }

    public boolean isVar(String nom) {
        SymbolTable table = this.objetExpression.getSymbolTable();
        return table.getVar(nom) != null;
    }

    public void addVar(String nom, double val) {
        this.objetExpression.addVariable(nom, val);
    }
}

