/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Glissiere
extends JPanel
implements ChangeListener {
    JTextField textField;
    JSlider laRegle;
    int nbDec;
    int facteur;
    int maximum;
    int minimum;

    public Glissiere(String legende, double min, double max, double valInit, int nbDec) {
        if (nbDec < 0) {
            nbDec = 0;
        }
        this.nbDec = nbDec;
        this.facteur = (int)Math.pow(10.0, nbDec);
        this.setLayout(new BoxLayout(this, 1));
        JLabel sliderLabel = new JLabel(legende + ": ", 0);
        sliderLabel.setAlignmentX(0.5f);
        this.textField = new Champ(this);
        this.textField.setColumns(10);
        this.textField.setEnabled(true);
        this.textField.setDisabledTextColor(Color.black);
        this.minimum = (int)(min * (double)this.facteur);
        this.maximum = (int)(max * (double)this.facteur);
        int posDebut = (int)(valInit * (double)this.facteur);
        min = (double)this.minimum / (double)this.facteur;
        max = (double)this.maximum / (double)this.facteur;
        valInit = (double)posDebut / (double)this.facteur;
        if (nbDec > 0) {
            this.textField.setText("" + valInit);
        } else {
            this.textField.setText("" + posDebut);
        }
        this.laRegle = new JSlider(0, this.minimum, this.maximum, posDebut);
        this.laRegle.addChangeListener(this);
        this.laRegle.setMajorTickSpacing(this.maximum - this.minimum);
        this.laRegle.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        if (nbDec == 0) {
            labelTable.put(new Integer(this.minimum), new JLabel("" + (int)min));
            labelTable.put(new Integer(this.maximum), new JLabel("" + (int)max));
        } else {
            labelTable.put(new Integer(this.minimum), new JLabel("" + min));
            labelTable.put(new Integer(this.maximum), new JLabel("" + max));
        }
        this.laRegle.setLabelTable(labelTable);
        this.laRegle.setPaintLabels(true);
        this.laRegle.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JPanel labelAndTextField = new JPanel();
        labelAndTextField.add(sliderLabel);
        labelAndTextField.add(this.textField);
        this.add(labelAndTextField);
        this.add(this.laRegle);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    public double getValue() {
        return (double)this.laRegle.getValue() / (double)this.facteur;
    }

    public void setValue(double d) {
        int val = (int)Math.round(d * (double)this.facteur);
        System.out.println(val);
        this.laRegle.setValue(val);
        if (this.nbDec > 0) {
            this.textField.setText("" + (double)val / (double)this.facteur);
        } else {
            System.out.println(val);
            this.textField.setText("" + val);
        }
    }

    public JSlider getSlider() {
        return this.laRegle;
    }

    public int getDecimales() {
        return this.nbDec;
    }

    public int getFacteur() {
        return this.facteur;
    }

    public int getMax() {
        return this.maximum;
    }

    public int getMin() {
        return this.minimum;
    }

    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        int val = source.getValue();
        if (this.nbDec > 0) {
            this.textField.setText("" + (double)val / (double)this.facteur);
        } else {
            this.textField.setText("" + val);
        }
    }
}

