/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class Tortue {
    private double xDebut = 300.0;
    private double yDebut = 200.0;
    private double x;
    private double y;
    private double angle;
    private boolean crayonBaisse;
    private Color couleur;
    private double epaisseur;
    private boolean modeInverse;
    private FeuilleADessin figure;
    private Color couleurRemplissage;
    private ArrayList sommetsRemplissage = new ArrayList();
    private boolean remplir = false;

    public Tortue(FeuilleADessin z) {
        this.figure = z;
        this.init();
    }

    public void init() {
        this.couleur = Color.black;
        this.couleurRemplissage = Color.black;
        this.epaisseur = 1.0;
        this.x = this.xDebut;
        this.y = this.yDebut;
        this.angle = 0.0;
        this.crayonBaisse = true;
        this.modeInverse = false;
    }

    private void trace(double xN, double yN) {
        if (this.remplir) {
            if (this.sommetsRemplissage.size() == 0) {
                this.sommetsRemplissage.add(new Point2D.Double(this.x, this.y));
            }
            this.sommetsRemplissage.add(new Point2D.Double(xN, yN));
        }
        if (this.crayonBaisse) {
            Graphics2D g2D = this.figure.gTampon;
            g2D.setPaint(this.couleur);
            g2D.setStroke(new BasicStroke((float)this.epaisseur));
            if (this.modeInverse) {
                g2D.setXORMode(Color.white);
            } else {
                g2D.setPaintMode();
            }
            g2D.draw(new Line2D.Double(this.x, this.y, xN, yN));
            this.figure.repaint();
        }
    }

    private double sin(double angle) {
        return Math.sin(angle * Math.PI / 180.0);
    }

    private double cos(double angle) {
        return Math.cos(angle * Math.PI / 180.0);
    }

    public void avance(double d) {
        double xN = this.x + d * this.sin(this.angle);
        double yN = this.y - d * this.cos(this.angle);
        this.trace(xN, yN);
        this.x = xN;
        this.y = yN;
    }

    public void av(double d) {
        this.avance(d);
    }

    public void droite(double angle) {
        this.angle += angle;
    }

    public void dr(double angle) {
        this.droite(angle);
    }

    public void gauche(double angle) {
        this.angle -= angle;
    }

    public void ga(double angle) {
        this.angle -= angle;
    }

    public void maison() {
        this.trace(this.xDebut, this.yDebut);
        this.x = this.xDebut;
        this.y = this.yDebut;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double d) {
        this.angle = d;
    }

    public double getX() {
        return this.x - this.xDebut;
    }

    public void setX(double x) {
        this.x = x + this.xDebut;
    }

    public double getY() {
        return this.yDebut - this.y;
    }

    public void setY(double y) {
        this.y = this.yDebut - y;
    }

    public void baisseCrayon() {
        this.crayonBaisse = true;
    }

    public void bC() {
        this.baisseCrayon();
    }

    public void leveCrayon() {
        this.crayonBaisse = false;
    }

    public void lC() {
        this.leveCrayon();
    }

    public void setPos(double x, double y) {
        this.trace(x + this.xDebut, this.yDebut - y);
        this.x = x + this.xDebut;
        this.y = this.yDebut - y;
    }

    public void setColor(Color c) {
        this.couleur = c;
    }

    public Color getColor() {
        return this.couleur;
    }

    public void setModeInverse() {
        this.modeInverse = true;
    }

    public void setModeNormal() {
        this.modeInverse = false;
    }

    public boolean getModeInverse() {
        return this.modeInverse;
    }

    public void setEpaisseur(double ep) {
        this.epaisseur = ep;
    }

    public double getEpaisseur() {
        return this.epaisseur;
    }

    public double vers(double x, double y) {
        return 90.0 - Math.atan2(y - this.getY(), x - this.getX()) * 180.0 / Math.PI;
    }

    public void setxDebut(double x) {
        this.xDebut = x;
    }

    public void setyDebut(double y) {
        this.yDebut = y;
    }

    public double getxDebut() {
        return this.xDebut;
    }

    public double getyDebut() {
        return this.yDebut;
    }

    public double xEcranVersTortue(double u) {
        return u - this.xDebut;
    }

    public double yEcranVersTortue(double v) {
        return this.yDebut - v;
    }

    public double xTortueVersEcran(double u) {
        return u + this.xDebut;
    }

    public double yTortueVersEcran(double v) {
        return this.yDebut - v;
    }

    public void ecrire(double u, double v, String texte) {
        Graphics2D g2D = this.figure.gTampon;
        g2D.setPaint(this.couleur);
        g2D.drawString(texte, (int)(u + this.xDebut), (int)(this.yDebut - v));
        this.figure.repaint();
    }

    public void tailleTexte(int n) {
        if (n <= 0) {
            return;
        }
        Graphics2D g2D = this.figure.gTampon;
        Font ancienne = g2D.getFont();
        Font nouvelle = ancienne.deriveFont((float)n);
        g2D.setFont(nouvelle);
    }

    public int hauteurTexte() {
        Graphics2D g2D = this.figure.gTampon;
        FontMetrics metric = this.figure.gTampon.getFontMetrics(g2D.getFont());
        return metric.getHeight();
    }

    public int longueurTexte(String ch) {
        if (ch == null) {
            return 0;
        }
        Graphics2D g2D = this.figure.gTampon;
        FontMetrics metric = this.figure.gTampon.getFontMetrics(g2D.getFont());
        return metric.stringWidth(ch);
    }

    public Color getColorFill() {
        return this.couleurRemplissage;
    }

    public void setColorFill(Color c) {
        this.couleurRemplissage = c;
    }

    public void setColorFill(int r, int g, int b) {
        this.couleurRemplissage = new Color(r, g, b);
    }

    public void debutRemplir() {
        this.remplir = true;
        this.sommetsRemplissage.clear();
    }

    public void finRemplir() {
        this.remplir = false;
        GeneralPath polygone = new GeneralPath(0, this.sommetsRemplissage.size());
        Point2D.Double pt = (Point2D.Double)this.sommetsRemplissage.get(0);
        polygone.moveTo((float)pt.x, (float)pt.y);
        for (int i = 1; i < this.sommetsRemplissage.size(); ++i) {
            pt = (Point2D.Double)this.sommetsRemplissage.get(i);
            polygone.lineTo((float)pt.x, (float)pt.y);
        }
        polygone.closePath();
        Graphics2D g2D = this.figure.gTampon;
        g2D.setPaint(this.couleurRemplissage);
        g2D.fill(polygone);
        this.figure.repaint();
        this.sommetsRemplissage.clear();
    }

    public void segment(double x1, double y1, double x2, double y2) {
        x1 += this.xDebut;
        x2 += this.xDebut;
        y1 = this.yDebut - y1;
        y2 = this.yDebut - y2;
        if (this.remplir) {
            if (this.sommetsRemplissage.size() == 0) {
                this.sommetsRemplissage.add(new Point2D.Double(x1, y1));
            }
            this.sommetsRemplissage.add(new Point2D.Double(x2, y2));
        }
        Graphics2D g2D = this.figure.gTampon;
        g2D.setPaint(this.couleur);
        g2D.setStroke(new BasicStroke((float)this.epaisseur));
        g2D.draw(new Line2D.Double(x1, y1, x2, y2));
        this.figure.repaint();
    }

    public void rectangle(double x, double y, double base, double hauteur) {
        y = this.yDebut - y;
        Graphics2D g2D = this.figure.gTampon;
        g2D.setPaint(this.couleur);
        g2D.setStroke(new BasicStroke((float)this.epaisseur));
        g2D.draw(new Rectangle2D.Double(x += this.xDebut, y, base, hauteur));
        this.figure.repaint();
    }

    public void ellipse(double x, double y, double base, double hauteur) {
        y = this.yDebut - y;
        Graphics2D g2D = this.figure.gTampon;
        g2D.setPaint(this.couleur);
        g2D.setStroke(new BasicStroke((float)this.epaisseur));
        g2D.draw(new Ellipse2D.Double(x += this.xDebut, y, base, hauteur));
        this.figure.repaint();
    }

    public void cercle(double cx, double cy, double rayon) {
        this.ellipse(cx - rayon, cy + rayon, 2.0 * rayon, 2.0 * rayon);
    }

    public void arc(double cx, double cy, double rayon, double angleDeb, double angleFin) {
        cx += this.xDebut;
        cy = this.yDebut - cy;
        angleDeb = 90.0 - angleDeb;
        angleFin = 90.0 - angleFin;
        Graphics2D g2D = this.figure.gTampon;
        g2D.setPaint(this.couleur);
        g2D.setStroke(new BasicStroke((float)this.epaisseur));
        g2D.draw(new Arc2D.Double(cx - rayon, cy - rayon, 2.0 * rayon, 2.0 * rayon, angleDeb, angleFin, 0));
        this.figure.repaint();
    }

    public void rectanglePlein(double x, double y, double base, double hauteur) {
        y = this.yDebut - y;
        Graphics2D g2D = this.figure.gTampon;
        g2D.setPaint(this.couleurRemplissage);
        g2D.fill(new Rectangle2D.Double(x += this.xDebut, y, base, hauteur));
        this.figure.repaint();
    }

    public void ellipsePleine(double x, double y, double base, double hauteur) {
        y = this.yDebut - y;
        Graphics2D g2D = this.figure.gTampon;
        g2D.setPaint(this.couleurRemplissage);
        g2D.fill(new Ellipse2D.Double(x += this.xDebut, y, base, hauteur));
        this.figure.repaint();
    }

    public void disque(double cx, double cy, double rayon) {
        this.ellipsePleine(cx - rayon, cy + rayon, 2.0 * rayon, 2.0 * rayon);
    }
}

