/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Glissiere
extends JPanel
implements ChangeListener {
    JTextField textField;
    JSlider laRegle;
    int nbDec;
    int facteur;

    public Glissiere(String legende, double min, double max, double valInit, int nbDec) {
        if (nbDec < 0) {
            nbDec = 0;
        }
        this.nbDec = nbDec;
        this.facteur = (int)Math.pow(10.0, nbDec);
        this.setLayout(new BoxLayout(this, 1));
        JLabel sliderLabel = new JLabel(legende + ": ", 0);
        sliderLabel.setAlignmentX(0.5f);
        this.textField = new JTextField();
        this.textField.setColumns(10);
        this.textField.setEnabled(false);
        this.textField.setDisabledTextColor(Color.black);
        int minimum = (int)(min * (double)this.facteur);
        int maximum = (int)(max * (double)this.facteur);
        int posDebut = (int)(valInit * (double)this.facteur);
        min = (double)minimum / (double)this.facteur;
        max = (double)maximum / (double)this.facteur;
        valInit = (double)posDebut / (double)this.facteur;
        if (nbDec > 0) {
            this.textField.setText("" + valInit);
        } else {
            this.textField.setText("" + posDebut);
        }
        this.laRegle = new JSlider(0, minimum, maximum, posDebut);
        this.laRegle.addChangeListener(this);
        this.laRegle.setMajorTickSpacing(maximum - minimum);
        this.laRegle.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        if (nbDec == 0) {
            labelTable.put(new Integer(minimum), new JLabel("" + (int)min));
            labelTable.put(new Integer(maximum), new JLabel("" + (int)max));
        } else {
            labelTable.put(new Integer(minimum), new JLabel("" + min));
            labelTable.put(new Integer(maximum), new JLabel("" + max));
        }
        this.laRegle.setLabelTable(labelTable);
        this.laRegle.setPaintLabels(true);
        this.laRegle.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JPanel labelAndTextField = new JPanel();
        labelAndTextField.add(sliderLabel);
        labelAndTextField.add(this.textField);
        this.add(labelAndTextField);
        this.add(this.laRegle);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    public double getValue() {
        return (double)this.laRegle.getValue() / (double)this.facteur;
    }

    public void setValue(double d) {
        int val = (int)Math.round(d * (double)this.facteur);
        this.laRegle.setValue(val);
        this.textField.setText("" + val / this.facteur);
    }

    public JSlider getSlider() {
        return this.laRegle;
    }

    public int getDecimales() {
        return this.nbDec;
    }

    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        int val = source.getValue();
        if (this.nbDec > 0) {
            this.textField.setText("" + (double)val / (double)this.facteur);
        } else {
            this.textField.setText("" + val);
        }
    }
}

