var grille, interro, petit, grand, egal, gagne, tresor, nbTresors;
var grandS, petitS, egalS, succesS, erreurS;

var decalX, decalY;
var modeJeu, repX, repY, rep, ligne, col, cases, 
    recommencerB, infoB, infoDiv, posInfo, question, reponse, sonB, sonP;
// modeJeu = 0 si on peut cliquer sur cases
// modeJeu = 1 si on doit donner une réponse
// modeJeu = 2 si la partie est terminée

var iBookP, posRep, titre; // si vrai, alors on montre pas bouton "Mode d'emploi"

function preloadAB() {
  titre = select("#titre");
  
  infoDiv = select("#explications");
  infoDiv.style("width","350px");
  infoDiv.hide();
  
  grille = select("#grille");
  interro = select("#interro");
  petit = select("#petit");
  grand = select("#grand");
  egal = select("#egal");
  gagne = select("#gagne");
  tresor = []; nbTresors=13;
  for(var i=0;i<13;i++) {
    tresor[i] = select("#tresor"+i);
  }
  
  grandS = select("#grandS");
  petitS = select("#petitS");
  egalS = select("#egalS");
  succesS = select("#succesS");
  erreurS = select("#erreurS");
}

function setup() {
  noLoop(); pixelDensity(1); preloadAB(); iBookP = 	false;
  if (iBookP) {posRep=20;} else {posRep=460;};
  cases = new Array(10);
  for(var i=0; i<10; i++) {cases[i] = new Array(10);}
  
  can = createCanvas(371,350);
  can.position(10,70);

  recommencerB = createButton("Nouvelle partie");
  recommencerB.position(10, 430);
  recommencerB.mousePressed(initialiser);

  sonP = true; 
  sonB = createButton("Rendre muet");
  sonB.position(140, 430);
  sonB.mousePressed(sonoriser);
  if (sonP) {sonB.html("Rendre muet");} else {sonB.html("Activer la voix");};

  infoB = createButton("Mode d'emploi");
  infoB.position(265, 430);
  infoB.mousePressed(positionInfo);
  if (iBookP) {infoB.hide();};
  
  question = createDiv("Calculez: 10x10 = ");
  question.position(10, posRep);
  question.style("font-size", "18pt");
  
  reponse = createInput();
  reponse.position(190, posRep);
  reponse.style("font-size", "18pt");
  reponse.style("width", "50px");
  reponse.changed(donnerReponse);
  
  initialiser();
}

function initialiser() {
  modeJeu=0; decalX=8; decalY=6;
  posInfo=2; positionInfo();
  question.hide();
  reponse.hide();
  background(255);
  image(grille,0,0);
  for(var i=1; i <= 10; i++){
    for(var j=1; j <= 10; j++) {
      image(interro, i*32-decalX, j*32-decalY);
    }
  }
  repX = floor(random(1,11));
  repY = floor(random(1,11));
  for(var i=0;i<10;i++){
    for(var j=0;j<10;j++) {cases[i][j]=0;};
  }
}

function sonoriser() {
	sonP = !sonP;
	if (sonP) {sonB.html("Rendre muet");} else {sonB.html("Activer la voix");};
}

function positionInfo() {
  posInfo = (posInfo+1)%3;
  if (posInfo == 0) {infoDiv.hide();}
  if (posInfo == 1) {infoDiv.show(); infoDiv.position(10, 480);}
  if (posInfo == 2) {infoDiv.show(); infoDiv.position(400, 50);}
}

function mouseClicked() {
	unClic(mouseX, mouseY);
}

function touchStarted() {   // prevent default behavior
	if (touchIsDown && (touchX>0) && (touchX<371) && (touchY>0) && (touchY<400)) { // couvre canvas ET boutons
		unClic(mouseX, mouseY);
		return false;
	};
}

function unClic(x, y) {
  if(modeJeu>0) {return;}
  col = floor((x+decalX)/32);
  ligne = floor((y+decalY)/32);
  if((col<1)||(col>10)||(ligne<1)||(ligne>10)) {return;}
  if(cases[ligne-1][col-1]==1) {return;}
  modeJeu = 1;
  question.html("Calculez "+ligne+" x "+col);
  if (iBookP) {titre.hide();};
  recommencerB.hide(); sonB.hide(); infoB.hide(); question.show(); reponse.show();
  reponse.elt.focus();
} 

function donnerReponse(){
  rep = reponse.value();
  print (rep);
  modeJeu = 0;
  verifierReponse();
  recommencerB.show(); sonB.show(); question.hide(); reponse.hide(); reponse.value(""); titre.show();
  if (iBookP) {infoB.hide();} else {infoB.show();};
}

function verifierReponse() {
  if (rep == ligne*col) {
    cases[ligne-1][col-1]=1;
    if (rep < repX*repY) {
      if (sonP) {petitS.play();};
      image(petit, col*32-decalX, ligne*32-decalY);
      return;
    };
    if (rep > repX*repY) {
      if (sonP) {grandS.play();};
      image(grand, col*32-decalX, ligne*32-decalY);
      return;
    };
    if ((col==repX) && (ligne==repY)) {
      if (sonP) {succesS.play();};
      image(gagne, col*32-decalX, ligne*32-decalY);
      background(255);
      image(random(tresor),0,0);
      modeJeu=2;
      return;
    };
    if (sonP) {egalS.play();};
    image(egal, col*32-decalX, ligne*32-decalY);
    return;
  } else {
    if (rep != null && sonP) {erreurS.play();}
    
  }
}

function draw() {
  
}