/*! p5.sound.min.js v0.3.5 2017-07-28 */

!function(t,e){"function"==typeof define&&define.amd?define("p5.sound",["p5"],function(t){e(t)}):e("object"==typeof exports?require("../p5"):t.p5)}(this,function(p5){var sndcore;sndcore=function(){!function(){function t(t){t&&(t.setTargetAtTime||(t.setTargetAtTime=t.setTargetValueAtTime))}window.hasOwnProperty("webkitAudioContext")&&!window.hasOwnProperty("AudioContext")&&(window.AudioContext=window.webkitAudioContext,"function"!=typeof AudioContext.prototype.createGain&&(AudioContext.prototype.createGain=AudioContext.prototype.createGainNode),"function"!=typeof AudioContext.prototype.createDelay&&(AudioContext.prototype.createDelay=AudioContext.prototype.createDelayNode),"function"!=typeof AudioContext.prototype.createScriptProcessor&&(AudioContext.prototype.createScriptProcessor=AudioContext.prototype.createJavaScriptNode),"function"!=typeof AudioContext.prototype.createPeriodicWave&&(AudioContext.prototype.createPeriodicWave=AudioContext.prototype.createWaveTable),AudioContext.prototype.internal_createGain=AudioContext.prototype.createGain,AudioContext.prototype.createGain=function(){var e=this.internal_createGain();return t(e.gain),e},AudioContext.prototype.internal_createDelay=AudioContext.prototype.createDelay,AudioContext.prototype.createDelay=function(e){var i=e?this.internal_createDelay(e):this.internal_createDelay();return t(i.delayTime),i},AudioContext.prototype.internal_createBufferSource=AudioContext.prototype.createBufferSource,AudioContext.prototype.createBufferSource=function(){var e=this.internal_createBufferSource();return e.start?(e.internal_start=e.start,e.start=function(t,i,n){"undefined"!=typeof n?e.internal_start(t||0,i,n):e.internal_start(t||0,i||0)}):e.start=function(t,e,i){e||i?this.noteGrainOn(t||0,e,i):this.noteOn(t||0)},e.stop?(e.internal_stop=e.stop,e.stop=function(t){e.internal_stop(t||0)}):e.stop=function(t){this.noteOff(t||0)},t(e.playbackRate),e},AudioContext.prototype.internal_createDynamicsCompressor=AudioContext.prototype.createDynamicsCompressor,AudioContext.prototype.createDynamicsCompressor=function(){var e=this.internal_createDynamicsCompressor();return t(e.threshold),t(e.knee),t(e.ratio),t(e.reduction),t(e.attack),t(e.release),e},AudioContext.prototype.internal_createBiquadFilter=AudioContext.prototype.createBiquadFilter,AudioContext.prototype.createBiquadFilter=function(){var e=this.internal_createBiquadFilter();return t(e.frequency),t(e.detune),t(e.Q),t(e.gain),e},"function"!=typeof AudioContext.prototype.createOscillator&&(AudioContext.prototype.internal_createOscillator=AudioContext.prototype.createOscillator,AudioContext.prototype.createOscillator=function(){var e=this.internal_createOscillator();return e.start?(e.internal_start=e.start,e.start=function(t){e.internal_start(t||0)}):e.start=function(t){this.noteOn(t||0)},e.stop?(e.internal_stop=e.stop,e.stop=function(t){e.internal_stop(t||0)}):e.stop=function(t){this.noteOff(t||0)},e.setPeriodicWave||(e.setPeriodicWave=e.setWaveTable),t(e.frequency),t(e.detune),e})),window.hasOwnProperty("webkitOfflineAudioContext")&&!window.hasOwnProperty("OfflineAudioContext")&&(window.OfflineAudioContext=window.webkitOfflineAudioContext)}(window);var t=new window.AudioContext;p5.prototype.getAudioContext=function(){return t},navigator.getUserMedia=navigator.getUserMedia||navigator.webkitGetUserMedia||navigator.mozGetUserMedia||navigator.msGetUserMedia;var e=document.createElement("audio");p5.prototype.isSupported=function(){return!!e.canPlayType};var i=function(){return!!e.canPlayType&&e.canPlayType('audio/ogg; codecs="vorbis"')},n=function(){return!!e.canPlayType&&e.canPlayType("audio/mpeg;")},o=function(){return!!e.canPlayType&&e.canPlayType('audio/wav; codecs="1"')},r=function(){return!!e.canPlayType&&(e.canPlayType("audio/x-m4a;")||e.canPlayType("audio/aac;"))},s=function(){return!!e.canPlayType&&e.canPlayType("audio/x-aiff;")};p5.prototype.isFileSupported=function(t){switch(t.toLowerCase()){case"mp3":return n();case"wav":return o();case"ogg":return i();case"aac":case"m4a":case"mp4":return r();case"aif":case"aiff":return s();default:return!1}};var a=navigator.userAgent.match(/(iPad|iPhone|iPod)/g)?!0:!1;if(a){var u=!1,p=function(){if(!u){var e=t.createBuffer(1,1,22050),i=t.createBufferSource();i.buffer=e,i.connect(t.destination),i.start(0),console.log("start ios!"),"running"===t.state&&(u=!0)}};document.addEventListener("touchend",p,!1),document.addEventListener("touchstart",p,!1)}}();var master;master=function(){var t=function(){var t=p5.prototype.getAudioContext();this.input=t.createGain(),this.output=t.createGain(),this.limiter=t.createDynamicsCompressor(),this.limiter.threshold.value=0,this.limiter.ratio.value=20,this.audiocontext=t,this.output.disconnect(),this.inputSources=[],this.input.connect(this.limiter),this.limiter.connect(this.output),this.meter=t.createGain(),this.fftMeter=t.createGain(),this.output.connect(this.meter),this.output.connect(this.fftMeter),this.output.connect(this.audiocontext.destination),this.soundArray=[],this.parts=[],this.extensions=[]},e=new t;return p5.prototype.getMasterVolume=function(){return e.output.gain.value},p5.prototype.masterVolume=function(t,i,n){if("number"==typeof t){var i=i||0,n=n||0,o=e.audiocontext.currentTime,r=e.output.gain.value;e.output.gain.cancelScheduledValues(o+n),e.output.gain.linearRampToValueAtTime(r,o+n),e.output.gain.linearRampToValueAtTime(t,o+n+i)}else{if(!t)return e.output.gain;t.connect(e.output.gain)}},p5.prototype.soundOut=p5.soundOut=e,p5.soundOut._silentNode=e.audiocontext.createGain(),p5.soundOut._silentNode.gain.value=0,p5.soundOut._silentNode.connect(e.audiocontext.destination),e}();var helpers;helpers=function(){var t=master;return p5.prototype.sampleRate=function(){return t.audiocontext.sampleRate},p5.prototype.freqToMidi=function(t){var e=Math.log(t/440)/Math.log(2),i=Math.round(12*e)+69;return i},p5.prototype.midiToFreq=function(t){return 440*Math.pow(2,(t-69)/12)},p5.prototype.soundFormats=function(){t.extensions=[];for(var e=0;e<arguments.length;e++){if(arguments[e]=arguments[e].toLowerCase(),!(["mp3","wav","ogg","m4a","aac"].indexOf(arguments[e])>-1))throw arguments[e]+" is not a valid sound format!";t.extensions.push(arguments[e])}},p5.prototype.disposeSound=function(){for(var e=0;e<t.soundArray.length;e++)t.soundArray[e].dispose()},p5.prototype.registerMethod("remove",p5.prototype.disposeSound),p5.prototype._checkFileFormats=function(e){var i;if("string"==typeof e){i=e;var n=i.split(".").pop();if(["mp3","wav","ogg","m4a","aac"].indexOf(n)>-1)if(p5.prototype.isFileSupported(n))i=i;else for(var o=i.split("."),r=o[o.length-1],s=0;s<t.extensions.length;s++){var a=t.extensions[s],u=p5.prototype.isFileSupported(a);if(u){r="",2===o.length&&(r+=o[0]);for(var s=1;s<=o.length-2;s++){var p=o[s];r+="."+p}i=r+=".",i=i+=a;break}}else for(var s=0;s<t.extensions.length;s++){var a=t.extensions[s],u=p5.prototype.isFileSupported(a);if(u){i=i+"."+a;break}}}else if("object"==typeof e)for(var s=0;s<e.length;s++){var a=e[s].split(".").pop(),u=p5.prototype.isFileSupported(a);if(u){i=e[s];break}}return i},p5.prototype._mathChain=function(t,e,i,n,o){for(var r in t.mathOps)t.mathOps[r]instanceof o&&(t.mathOps[r].dispose(),i=r,i<t.mathOps.length-1&&(n=t.mathOps[r+1]));return t.mathOps[i-1].disconnect(),t.mathOps[i-1].connect(e),e.connect(n),t.mathOps[i]=e,t},{midiToFreq:p5.prototype.midiToFreq}}(master);var errorHandler;errorHandler=function(){var t=function(t,e,i){var n,o,r=new Error;r.name=t,r.originalStack=r.stack+e,n=r.stack+e,r.failedPath=i;var o=n.split("\n");return o=o.filter(function(t){return!t.match(/(p5.|native code|globalInit)/g)}),r.stack=o.join("\n"),r};return t}();var panner;panner=function(){var t=master,e=t.audiocontext;"undefined"!=typeof e.createStereoPanner?(p5.Panner=function(t,i){this.stereoPanner=this.input=e.createStereoPanner(),t.connect(this.stereoPanner),this.stereoPanner.connect(i)},p5.Panner.prototype.pan=function(t,i){var n=i||0,o=e.currentTime+n;this.stereoPanner.pan.linearRampToValueAtTime(t,o)},p5.Panner.prototype.inputChannels=function(){},p5.Panner.prototype.connect=function(t){this.stereoPanner.connect(t)},p5.Panner.prototype.disconnect=function(){this.stereoPanner.disconnect()}):(p5.Panner=function(t,i,n){this.input=e.createGain(),t.connect(this.input),this.left=e.createGain(),this.right=e.createGain(),this.left.channelInterpretation="discrete",this.right.channelInterpretation="discrete",n>1?(this.splitter=e.createChannelSplitter(2),this.input.connect(this.splitter),this.splitter.connect(this.left,1),this.splitter.connect(this.right,0)):(this.input.connect(this.left),this.input.connect(this.right)),this.output=e.createChannelMerger(2),this.left.connect(this.output,0,1),this.right.connect(this.output,0,0),this.output.connect(i)},p5.Panner.prototype.pan=function(t,i){var n=i||0,o=e.currentTime+n,r=(t+1)/2,s=Math.cos(r*Math.PI/2),a=Math.sin(r*Math.PI/2);this.left.gain.linearRampToValueAtTime(a,o),this.right.gain.linearRampToValueAtTime(s,o)},p5.Panner.prototype.inputChannels=function(t){1===t?(this.input.disconnect(),this.input.connect(this.left),this.input.connect(this.right)):2===t&&(this.splitter=e.createChannelSplitter(2),this.input.disconnect(),this.input.connect(this.splitter),this.splitter.connect(this.left,1),this.splitter.connect(this.right,0))},p5.Panner.prototype.connect=function(t){this.output.connect(t)},p5.Panner.prototype.disconnect=function(){this.output.disconnect()}),p5.Panner3D=function(t,i){var n=e.createPanner();return n.panningModel="HRTF",n.distanceModel="linear",n.setPosition(0,0,0),t.connect(n),n.connect(i),n.pan=function(t,e,i){n.setPosition(t,e,i)},n}}(master);var soundfile;soundfile=function(){function t(t,e){for(var i={},n=t.length,o=0;n>o;o++){if(t[o]>e){var r=t[o],s=new c(r,o);i[o]=s,o+=6e3}o++}return i}function e(t){for(var e=[],i=Object.keys(t).sort(),n=0;n<i.length;n++)for(var o=0;10>o;o++){var r=t[i[n]],s=t[i[n+o]];if(r&&s){var a=r.sampleIndex,u=s.sampleIndex,p=u-a;p>0&&r.intervals.push(p);var c=e.some(function(t){return t.interval===p?(t.count++,t):void 0});c||e.push({interval:p,count:1})}}return e}function i(t,e){var i=[];return t.forEach(function(t){try{var n=Math.abs(60/(t.interval/e));n=o(n);var r=i.some(function(e){return e.tempo===n?e.count+=t.count:void 0});if(!r){if(isNaN(n))return;i.push({tempo:Math.round(n),count:t.count})}}catch(s){throw s}}),i}function n(t,e,i,n){for(var r=[],s=Object.keys(t).sort(),a=0;a<s.length;a++)for(var u=s[a],p=t[u],c=0;c<p.intervals.length;c++){var h=Math.round(Math.abs(60/(p.intervals[c]/i)));h=o(h),Math.abs(h-e)<n&&r.push(p.sampleIndex/44100)}return r=r.filter(function(t,e,i){var n=i[e+1]-t;return n>.01?!0:void 0})}function o(t){if(isFinite(t)&&0!==t){for(;90>t;)t*=2;for(;t>180&&t>90;)t/=2;return t}}var r=errorHandler,s=master,a=s.audiocontext,u=helpers.midiToFreq;p5.SoundFile=function(t,e,i,n){if("undefined"!=typeof t){if("string"==typeof t||"string"==typeof t[0]){var o=p5.prototype._checkFileFormats(t);this.url=o}else if("object"==typeof t&&!(window.File&&window.FileReader&&window.FileList&&window.Blob))throw"Unable to load file because the File API is not supported";t.file&&(t=t.file),this.file=t}this._onended=function(){},this._looping=!1,this._playing=!1,this._paused=!1,this._pauseTime=0,this._cues=[],this._lastPos=0,this._counterNode=null,this._scopeNode=null,this.bufferSourceNodes=[],this.bufferSourceNode=null,this.buffer=null,this.playbackRate=1,this.input=s.audiocontext.createGain(),this.output=s.audiocontext.createGain(),this.reversed=!1,this.startTime=0,this.endTime=null,this.pauseTime=0,this.mode="sustain",this.startMillis=null,this.panPosition=0,this.panner=new p5.Panner(this.output,s.input,2),(this.url||this.file)&&this.load(e,i),s.soundArray.push(this),"function"==typeof n?this._whileLoading=n:this._whileLoading=function(){}},p5.prototype.registerPreloadMethod("loadSound",p5.prototype),p5.prototype.loadSound=function(t,e,i,n){window.location.origin.indexOf("file://")>-1&&"undefined"===window.cordova&&window.alert("This sketch may require a server to load external files. Please see http://bit.ly/1qcInwS");var o=this,r=new p5.SoundFile(t,function(){"function"==typeof e&&e.apply(o,arguments),o._decrementPreload()},i,n);return r},p5.SoundFile.prototype.load=function(t,e){var i=this,n=(new Error).stack;if(void 0!==this.url&&""!==this.url){var o=new XMLHttpRequest;o.addEventListener("progress",function(t){i._updateProgress(t)},!1),o.open("GET",this.url,!0),o.responseType="arraybuffer",o.onload=function(){if(200===o.status)a.decodeAudioData(o.response,function(e){i.buffer=e,i.panner.inputChannels(e.numberOfChannels),t&&t(i)},function(){var t=new r("decodeAudioData",n,i.url),o="AudioContext error at decodeAudioData for "+i.url;e?(t.msg=o,e(t)):console.error(o+"\n The error stack trace includes: \n"+t.stack)});else{var s=new r("loadSound",n,i.url),u="Unable to load "+i.url+". The request status was: "+o.status+" ("+o.statusText+")";e?(s.message=u,e(s)):console.error(u+"\n The error stack trace includes: \n"+s.stack)}},o.onerror=function(){var t=new r("loadSound",n,i.url),o="There was no response from the server at "+i.url+". Check the url and internet connectivity.";e?(t.message=o,e(t)):console.error(o+"\n The error stack trace includes: \n"+t.stack)},o.send()}else if(void 0!==this.file){var s=new FileReader;s.onload=function(){a.decodeAudioData(s.result,function(e){i.buffer=e,i.panner.inputChannels(e.numberOfChannels),t&&t(i)})},s.onerror=function(t){onerror&&onerror(t)},s.readAsArrayBuffer(this.file)}},p5.SoundFile.prototype._updateProgress=function(t){if(t.lengthComputable){var e=t.loaded/t.total*.99;this._whileLoading(e,t)}else this._whileLoading("size unknown")},p5.SoundFile.prototype.isLoaded=function(){return this.buffer?!0:!1},p5.SoundFile.prototype.play=function(t,e,i,n,o){var r,a,u=this,p=s.audiocontext.currentTime,c=t||0;if(0>c&&(c=0),c+=p,this.rate(e),this.setVolume(i),!this.buffer)throw"not ready to play file, buffer has yet to load. Try preload()";if(this._pauseTime=0,"restart"===this.mode&&this.buffer&&this.bufferSourceNode&&(this.bufferSourceNode.stop(c),this._counterNode.stop(c)),this.bufferSourceNode=this._initSourceNode(),this._counterNode&&(this._counterNode=void 0),this._counterNode=this._initCounterNode(),n){if(!(n>=0&&n<this.buffer.duration))throw"start time out of range";r=n}else r=0;o=o?o<=this.buffer.duration-r?o:this.buffer.duration:this.buffer.duration-r,this.bufferSourceNode.connect(this.output),this._paused?(this.bufferSourceNode.start(c,this.pauseTime,o),this._counterNode.start(c,this.pauseTime,o)):(this.bufferSourceNode.start(c,r,o),this._counterNode.start(c,r,o)),this._playing=!0,this._paused=!1,this.bufferSourceNodes.push(this.bufferSourceNode),this.bufferSourceNode._arrayIndex=this.bufferSourceNodes.length-1;var h=function(){this._playing=!1,this.removeEventListener("ended",h,!1),u._onended(u),u.bufferSourceNodes.forEach(function(t,e){t._playing===!1&&u.bufferSourceNodes.splice(e)}),0===u.bufferSourceNodes.length&&(u._playing=!1)};this.bufferSourceNode.onended=h,this.bufferSourceNode.loop=this._looping,this._counterNode.loop=this._looping,this._looping===!0&&(a=r+o,this.bufferSourceNode.loopStart=r,this.bufferSourceNode.loopEnd=a,this._counterNode.loopStart=r,this._counterNode.loopEnd=a)},p5.SoundFile.prototype.playMode=function(t){var e=t.toLowerCase();if("restart"===e&&this.buffer&&this.bufferSourceNode)for(var i=0;i<this.bufferSourceNodes.length-1;i++){var n=s.audiocontext.currentTime;this.bufferSourceNodes[i].stop(n)}if("restart"!==e&&"sustain"!==e)throw'Invalid play mode. Must be either "restart" or "sustain"';this.mode=e},p5.SoundFile.prototype.pause=function(t){var e=s.audiocontext.currentTime,i=t||0,n=i+e;this.isPlaying()&&this.buffer&&this.bufferSourceNode?(this.pauseTime=this.currentTime(),this.bufferSourceNode.stop(n),this._counterNode.stop(n),this._paused=!0,this._playing=!1,this._pauseTime=this.currentTime()):this._pauseTime=0},p5.SoundFile.prototype.loop=function(t,e,i,n,o){this._looping=!0,this.play(t,e,i,n,o)},p5.SoundFile.prototype.setLoop=function(t){if(t===!0)this._looping=!0;else{if(t!==!1)throw"Error: setLoop accepts either true or false";this._looping=!1}this.bufferSourceNode&&(this.bufferSourceNode.loop=this._looping,this._counterNode.loop=this._looping)},p5.SoundFile.prototype.isLooping=function(){return this.bufferSourceNode&&this._looping===!0&&this.isPlaying()===!0?!0:!1},p5.SoundFile.prototype.isPlaying=function(){return this._playing},p5.SoundFile.prototype.isPaused=function(){return this._paused},p5.SoundFile.prototype.stop=function(t){var e=t||0;if("sustain"===this.mode)this.stopAll(e),this._playing=!1,this.pauseTime=0,this._paused=!1;else if(this.buffer&&this.bufferSourceNode){var i=s.audiocontext.currentTime,n=e||0;this.pauseTime=0,this.bufferSourceNode.stop(i+n),this._counterNode.stop(i+n),this._playing=!1,this._paused=!1}},p5.SoundFile.prototype.stopAll=function(t){var e=s.audiocontext.currentTime,i=t||0;if(this.buffer&&this.bufferSourceNode){for(var n=0;n<this.bufferSourceNodes.length;n++)if(void 0!==typeof this.bufferSourceNodes[n])try{this.bufferSourceNodes[n].onended=function(){},this.bufferSourceNodes[n].stop(e+i)}catch(o){}this._counterNode.stop(e+i),this._onended(this)}},p5.SoundFile.prototype.setVolume=function(t,e,i){if("number"==typeof t){var n=e||0,o=i||0,r=s.audiocontext.currentTime,a=this.output.gain.value;this.output.gain.cancelScheduledValues(r+o),this.output.gain.linearRampToValueAtTime(a,r+o),this.output.gain.linearRampToValueAtTime(t,r+o+n)}else{if(!t)return this.output.gain;t.connect(this.output.gain)}},p5.SoundFile.prototype.amp=p5.SoundFile.prototype.setVolume,p5.SoundFile.prototype.fade=p5.SoundFile.prototype.setVolume,p5.SoundFile.prototype.getVolume=function(){return this.output.gain.value},p5.SoundFile.prototype.pan=function(t,e){this.panPosition=t,this.panner.pan(t,e)},p5.SoundFile.prototype.getPan=function(){return this.panPosition},p5.SoundFile.prototype.rate=function(t){if("undefined"==typeof t)return this.playbackRate;if(0===t)t=1e-13;else if(0>t&&!this.reversed){var e=this.currentTime(),i=(e-this.duration())/t;this.pauseTime=i,this.reverseBuffer(),t=Math.abs(t)}else t>0&&this.reversed&&this.reverseBuffer();if(this.bufferSourceNode){var n=s.audiocontext.currentTime;this.bufferSourceNode.playbackRate.cancelScheduledValues(n),this.bufferSourceNode.playbackRate.linearRampToValueAtTime(Math.abs(t),n),this._counterNode.playbackRate.cancelScheduledValues(n),this._counterNode.playbackRate.linearRampToValueAtTime(Math.abs(t),n)}return this.playbackRate=t,this.playbackRate},p5.SoundFile.prototype.setPitch=function(t){var e=u(t)/u(60);this.rate(e)},p5.SoundFile.prototype.getPlaybackRate=function(){return this.playbackRate},p5.SoundFile.prototype.duration=function(){return this.buffer?this.buffer.duration:0},p5.SoundFile.prototype.currentTime=function(){return this._pauseTime>0?this._pauseTime:this._lastPos/a.sampleRate},p5.SoundFile.prototype.jump=function(t,e){if(0>t||t>this.buffer.duration)throw"jump time out of range";if(e>this.buffer.duration-t)throw"end time out of range";var i=t||0,n=e||this.buffer.duration-t;this.isPlaying()&&this.stop(),this.play(0,this.playbackRate,this.output.gain.value,i,n)},p5.SoundFile.prototype.channels=function(){return this.buffer.numberOfChannels},p5.SoundFile.prototype.sampleRate=function(){return this.buffer.sampleRate},p5.SoundFile.prototype.frames=function(){return this.buffer.length},p5.SoundFile.prototype.getPeaks=function(t){if(!this.buffer)throw"Cannot load peaks yet, buffer is not loaded";if(t||(t=5*window.width),this.buffer){for(var e=this.buffer,i=e.length/t,n=~~(i/10)||1,o=e.numberOfChannels,r=new Float32Array(Math.round(t)),s=0;o>s;s++)for(var a=e.getChannelData(s),u=0;t>u;u++){for(var p=~~(u*i),c=~~(p+i),h=0,l=p;c>l;l+=n){var f=a[l];f>h?h=f:-f>h&&(h=f)}(0===s||Math.abs(h)>r[u])&&(r[u]=h)}return r}},p5.SoundFile.prototype.reverseBuffer=function(){var t=this.getVolume();if(this.setVolume(0,.01,0),!this.buffer)throw"SoundFile is not done loading";for(var e=0;e<this.buffer.numberOfChannels;e++)Array.prototype.reverse.call(this.buffer.getChannelData(e));this.reversed=!this.reversed,this.setVolume(t,.01,.0101)},p5.SoundFile.prototype.onended=function(t){return this._onended=t,this},p5.SoundFile.prototype.add=function(){},p5.SoundFile.prototype.dispose=function(){var t=s.audiocontext.currentTime,e=s.soundArray.indexOf(this);if(s.soundArray.splice(e,1),this.stop(t),this.buffer&&this.bufferSourceNode){for(var i=0;i<this.bufferSourceNodes.length-1;i++)if(null!==this.bufferSourceNodes[i]){this.bufferSourceNodes[i].disconnect();try{this.bufferSourceNodes[i].stop(t)}catch(n){console.warning("no buffer source node to dispose")}this.bufferSourceNodes[i]=null}if(this.isPlaying()){try{this._counterNode.stop(t)}catch(n){console.log(n)}this._counterNode=null}}this.output&&(this.output.disconnect(),this.output=null),this.panner&&(this.panner.disconnect(),this.panner=null)},p5.SoundFile.prototype.connect=function(t){t?t.hasOwnProperty("input")?this.panner.connect(t.input):this.panner.connect(t):this.panner.connect(s.input)},p5.SoundFile.prototype.disconnect=function(){this.panner.disconnect()},p5.SoundFile.prototype.getLevel=function(){console.warn("p5.SoundFile.getLevel has been removed from the library. Use p5.Amplitude instead")},p5.SoundFile.prototype.setPath=function(t,e){var i=p5.prototype._checkFileFormats(t);this.url=i,this.load(e)},p5.SoundFile.prototype.setBuffer=function(t){var e=t.length,i=t[0].length,n=a.createBuffer(e,i,a.sampleRate);t[0]instanceof Float32Array||(t[0]=new Float32Array(t[0]));for(var o=0;e>o;o++){var r=n.getChannelData(o);r.set(t[o])}this.buffer=n,this.panner.inputChannels(e)};var p=function(t){for(var e=new Float32Array(t.length),i=a.createBuffer(1,t.length,44100),n=0;n<t.length;n++)e[n]=n;return i.getChannelData(0).set(e),i};p5.SoundFile.prototype._initCounterNode=function(){var t=this,e=a.currentTime,i=a.createBufferSource();return t._scopeNode&&(t._scopeNode.disconnect(),t._scopeNode.onaudioprocess=void 0,t._scopeNode=null),t._scopeNode=a.createScriptProcessor(256,1,1),i.buffer=p(t.buffer),i.playbackRate.setValueAtTime(t.playbackRate,e),i.connect(t._scopeNode),t._scopeNode.connect(p5.soundOut._silentNode),t._scopeNode.onaudioprocess=function(e){var i=e.inputBuffer.getChannelData(0);t._lastPos=i[i.length-1]||0,t._onTimeUpdate(t._lastPos)},i},p5.SoundFile.prototype._initSourceNode=function(){var t=a.createBufferSource();return t.buffer=this.buffer,t.playbackRate.value=this.playbackRate,t},p5.SoundFile.prototype.processPeaks=function(o,r,s,a){var u=this.buffer.length,p=this.buffer.sampleRate,c=this.buffer,h=[],l=r||.9,f=l,d=s||.22,m=a||200,y=new window.OfflineAudioContext(1,u,p),_=y.createBufferSource();_.buffer=c;var g=y.createBiquadFilter();g.type="lowpass",_.connect(g),g.connect(y.destination),_.start(0),y.startRendering(),y.oncomplete=function(r){var s=r.renderedBuffer,a=s.getChannelData(0);do h=t(a,f),f-=.005;while(Object.keys(h).length<m&&f>=d);var u=e(h),p=i(u,s.sampleRate),c=p.sort(function(t,e){return e.count-t.count}).splice(0,5);this.tempo=c[0].tempo;var l=5,y=n(h,c[0].tempo,s.sampleRate,l);o(y)}};var c=function(t,e){this.sampleIndex=e,this.amplitude=t,this.tempos=[],this.intervals=[]},h=function(t,e,i,n){this.callback=t,this.time=e,this.id=i,this.val=n};p5.SoundFile.prototype.addCue=function(t,e,i){var n=this._cueIDCounter++,o=new h(e,t,n,i);return this._cues.push(o),n},p5.SoundFile.prototype.removeCue=function(t){for(var e=this._cues.length,i=0;e>i;i++){var n=this._cues[i];n.id===t&&this.cues.splice(i,1)}0===this._cues.length},p5.SoundFile.prototype.clearCues=function(){this._cues=[]},p5.SoundFile.prototype._onTimeUpdate=function(t){for(var e=t/this.buffer.sampleRate,i=this._cues.length,n=0;i>n;n++){var o=this._cues[n],r=o.time,s=o.val;this._prevTime<r&&e>=r&&o.callback(s)}this._prevTime=e}}(sndcore,errorHandler,master,helpers);var amplitude;amplitude=function(){var t=master;p5.Amplitude=function(e){this.bufferSize=2048,this.audiocontext=t.audiocontext,this.processor=this.audiocontext.createScriptProcessor(this.bufferSize,2,1),this.input=this.processor,this.output=this.audiocontext.createGain(),this.smoothing=e||0,this.volume=0,this.average=0,this.stereoVol=[0,0],this.stereoAvg=[0,0],this.stereoVolNorm=[0,0],this.volMax=.001,this.normalize=!1,this.processor.onaudioprocess=this._audioProcess.bind(this),this.processor.connect(this.output),this.output.gain.value=0,this.output.connect(this.audiocontext.destination),t.meter.connect(this.processor),t.soundArray.push(this)},p5.Amplitude.prototype.setInput=function(e,i){t.meter.disconnect(),i&&(this.smoothing=i),null==e?(console.log("Amplitude input source is not ready! Connecting to master output instead"),t.meter.connect(this.processor)):e instanceof p5.Signal?e.output.connect(this.processor):e?(e.connect(this.processor),this.processor.disconnect(),this.processor.connect(this.output)):t.meter.connect(this.processor)},p5.Amplitude.prototype.connect=function(e){e?e.hasOwnProperty("input")?this.output.connect(e.input):this.output.connect(e):this.output.connect(this.panner.connect(t.input))},p5.Amplitude.prototype.disconnect=function(){this.output.disconnect()},p5.Amplitude.prototype._audioProcess=function(t){for(var e=0;e<t.inputBuffer.numberOfChannels;e++){for(var i,n=t.inputBuffer.getChannelData(e),o=n.length,r=0,s=0,a=0;o>a;a++)i=n[a],this.normalize?(r+=Math.max(Math.min(i/this.volMax,1),-1),s+=Math.max(Math.min(i/this.volMax,1),-1)*Math.max(Math.min(i/this.volMax,1),-1)):(r+=i,s+=i*i);var u=r/o,p=Math.sqrt(s/o);this.stereoVol[e]=Math.max(p,this.stereoVol[e]*this.smoothing),this.stereoAvg[e]=Math.max(u,this.stereoVol[e]*this.smoothing),this.volMax=Math.max(this.stereoVol[e],this.volMax)}var c=this,h=this.stereoVol.reduce(function(t,e,i){return c.stereoVolNorm[i-1]=Math.max(Math.min(c.stereoVol[i-1]/c.volMax,1),0),c.stereoVolNorm[i]=Math.max(Math.min(c.stereoVol[i]/c.volMax,1),0),t+e});this.volume=h/this.stereoVol.length,this.volNorm=Math.max(Math.min(this.volume/this.volMax,1),0)},p5.Amplitude.prototype.getLevel=function(t){return"undefined"!=typeof t?this.normalize?this.stereoVolNorm[t]:this.stereoVol[t]:this.normalize?this.volNorm:this.volume},p5.Amplitude.prototype.toggleNormalize=function(t){"boolean"==typeof t?this.normalize=t:this.normalize=!this.normalize},p5.Amplitude.prototype.smooth=function(t){t>=0&&1>t?this.smoothing=t:console.log("Error: smoothing must be between 0 and 1")},p5.Amplitude.prototype.dispose=function(){var e=t.soundArray.indexOf(this);t.soundArray.splice(e,1),this.input.disconnect(),this.output.disconnect(),this.input=this.processor=void 0,this.output=void 0}}(master);var fft;fft=function(){var t=master;p5.FFT=function(e,i){this.input=this.analyser=t.audiocontext.createAnalyser(),Object.defineProperties(this,{bins:{get:function(){return this.analyser.fftSize/2},set:function(t){this.analyser.fftSize=2*t},configurable:!0,enumerable:!0},smoothing:{get:function(){return this.analyser.smoothingTimeConstant},set:function(t){this.analyser.smoothingTimeConstant=t},configurable:!0,enumerable:!0}}),this.smooth(e),this.bins=i||1024,t.fftMeter.connect(this.analyser),this.freqDomain=new Uint8Array(this.analyser.frequencyBinCount),this.timeDomain=new Uint8Array(this.analyser.frequencyBinCount),this.bass=[20,140],this.lowMid=[140,400],this.mid=[400,2600],this.highMid=[2600,5200],this.treble=[5200,14e3],t.soundArray.push(this)},p5.FFT.prototype.setInput=function(e){e?(e.output?e.output.connect(this.analyser):e.connect&&e.connect(this.analyser),t.fftMeter.disconnect()):t.fftMeter.connect(this.analyser)},p5.FFT.prototype.waveform=function(){for(var t,e,i,r=0;r<arguments.length;r++)"number"==typeof arguments[r]&&(t=arguments[r],this.analyser.fftSize=2*t),"string"==typeof arguments[r]&&(e=arguments[r]);if(e&&!p5.prototype._isSafari())return n(this,this.timeDomain),this.analyser.getFloatTimeDomainData(this.timeDomain),this.timeDomain;o(this,this.timeDomain),this.analyser.getByteTimeDomainData(this.timeDomain);for(var i=new Array,s=0;s<this.timeDomain.length;s++){var a=p5.prototype.map(this.timeDomain[s],0,255,-1,1);i.push(a)}return i},p5.FFT.prototype.analyze=function(){for(var t,n=0;n<arguments.length;n++)"number"==typeof arguments[n]&&(this.bins=arguments[n],this.analyser.fftSize=2*this.bins),"string"==typeof arguments[n]&&(t=arguments[n]);if(t&&"db"===t.toLowerCase())return e(this),this.analyser.getFloatFrequencyData(this.freqDomain),this.freqDomain;i(this,this.freqDomain),this.analyser.getByteFrequencyData(this.freqDomain);var o=Array.apply([],this.freqDomain);return o.length===this.analyser.fftSize,o.constructor===Array,o},p5.FFT.prototype.getEnergy=function(e,i){var n=t.audiocontext.sampleRate/2;if("bass"===e?(e=this.bass[0],i=this.bass[1]):"lowMid"===e?(e=this.lowMid[0],i=this.lowMid[1]):"mid"===e?(e=this.mid[0],i=this.mid[1]):"highMid"===e?(e=this.highMid[0],i=this.highMid[1]):"treble"===e&&(e=this.treble[0],i=this.treble[1]),"number"!=typeof e)throw"invalid input for getEnergy()";if(i){if(e&&i){if(e>i){var o=i;i=e,e=o}for(var r=Math.round(e/n*this.freqDomain.length),s=Math.round(i/n*this.freqDomain.length),a=0,u=0,p=r;s>=p;p++)a+=this.freqDomain[p],u+=1;var c=a/u;return c}throw"invalid input for getEnergy()"}var h=Math.round(e/n*this.freqDomain.length);return this.freqDomain[h]},p5.FFT.prototype.getFreq=function(t,e){console.log("getFreq() is deprecated. Please use getEnergy() instead.");var i=this.getEnergy(t,e);return i},p5.FFT.prototype.getCentroid=function(){for(var e=t.audiocontext.sampleRate/2,i=0,n=0,o=0;o<this.freqDomain.length;o++)i+=o*this.freqDomain[o],n+=this.freqDomain[o];var r=0;0!==n&&(r=i/n);var s=r*(e/this.freqDomain.length);return s},p5.FFT.prototype.smooth=function(t){return"undefined"!=typeof t&&(this.smoothing=t),this.smoothing},p5.FFT.prototype.dispose=function(){var e=t.soundArray.indexOf(this);t.soundArray.splice(e,1),this.analyser.disconnect(),this.analyser=void 0},p5.FFT.prototype.linAverages=function(t){for(var t=t||16,e=this.freqDomain,i=e.length,n=Math.floor(i/t),o=new Array(t),r=0,s=0;i>s;s++)o[r]=void 0!==o[r]?(o[r]+e[s])/2:e[s],s%n===n-1&&r++;return o},p5.FFT.prototype.logAverages=function(e){for(var i=t.audiocontext.sampleRate/2,n=this.freqDomain,o=n.length,r=new Array(e.length),s=0,a=0;o>a;a++){var u=Math.round(a*i/this.freqDomain.length);u>e[s].hi&&s++,r[s]=void 0!==r[s]?(r[s]+n[a])/2:n[a]}return r},p5.FFT.prototype.getOctaveBands=function(e,i){var e=e||3,i=i||15.625,n=[],o={lo:i/Math.pow(2,1/(2*e)),ctr:i,hi:i*Math.pow(2,1/(2*e))};n.push(o);for(var r=t.audiocontext.sampleRate/2;o.hi<r;){var s={};s.lo=o.hi,s.ctr=o.ctr*Math.pow(2,1/e),s.hi=s.ctr*Math.pow(2,1/(2*e)),n.push(s),o=s}return n};var e=function(t){t.freqDomain instanceof Float32Array==!1&&(t.freqDomain=new Float32Array(t.analyser.frequencyBinCount))},i=function(t){t.freqDomain instanceof Uint8Array==!1&&(t.freqDomain=new Uint8Array(t.analyser.frequencyBinCount))},n=function(t){t.timeDomain instanceof Float32Array==!1&&(t.timeDomain=new Float32Array(t.analyser.frequencyBinCount))},o=function(t){t.timeDomain instanceof Uint8Array==!1&&(t.timeDomain=new Uint8Array(t.analyser.frequencyBinCount))}}(master);var Tone_core_Tone;Tone_core_Tone=function(){"use strict";function t(t){return void 0===t}function e(t){return"function"==typeof t}var i;if(t(window.AudioContext)&&(window.AudioContext=window.webkitAudioContext),t(window.OfflineAudioContext)&&(window.OfflineAudioContext=window.webkitOfflineAudioContext),t(AudioContext))throw new Error("Web Audio is not supported in this browser");i=new AudioContext,e(AudioContext.prototype.createGain)||(AudioContext.prototype.createGain=AudioContext.prototype.createGainNode),e(AudioContext.prototype.createDelay)||(AudioContext.prototype.createDelay=AudioContext.prototype.createDelayNode),e(AudioContext.prototype.createPeriodicWave)||(AudioContext.prototype.createPeriodicWave=AudioContext.prototype.createWaveTable),e(AudioBufferSourceNode.prototype.start)||(AudioBufferSourceNode.prototype.start=AudioBufferSourceNode.prototype.noteGrainOn),
e(AudioBufferSourceNode.prototype.stop)||(AudioBufferSourceNode.prototype.stop=AudioBufferSourceNode.prototype.noteOff),e(OscillatorNode.prototype.start)||(OscillatorNode.prototype.start=OscillatorNode.prototype.noteOn),e(OscillatorNode.prototype.stop)||(OscillatorNode.prototype.stop=OscillatorNode.prototype.noteOff),e(OscillatorNode.prototype.setPeriodicWave)||(OscillatorNode.prototype.setPeriodicWave=OscillatorNode.prototype.setWaveTable),AudioNode.prototype._nativeConnect=AudioNode.prototype.connect,AudioNode.prototype.connect=function(e,i,n){if(e.input)Array.isArray(e.input)?(t(n)&&(n=0),this.connect(e.input[n])):this.connect(e.input,i,n);else try{e instanceof AudioNode?this._nativeConnect(e,i,n):this._nativeConnect(e,i)}catch(o){throw new Error("error connecting to node: "+e)}};var n=function(e,i){t(e)||1===e?this.input=this.context.createGain():e>1&&(this.input=new Array(e)),t(i)||1===i?this.output=this.context.createGain():i>1&&(this.output=new Array(e))};n.prototype.set=function(e,i,o){if(this.isObject(e))o=i;else if(this.isString(e)){var r={};r[e]=i,e=r}for(var s in e){i=e[s];var a=this;if(-1!==s.indexOf(".")){for(var u=s.split("."),p=0;p<u.length-1;p++)a=a[u[p]];s=u[u.length-1]}var c=a[s];t(c)||(n.Signal&&c instanceof n.Signal||n.Param&&c instanceof n.Param?c.value!==i&&(t(o)?c.value=i:c.rampTo(i,o)):c instanceof AudioParam?c.value!==i&&(c.value=i):c instanceof n?c.set(i):c!==i&&(a[s]=i))}return this},n.prototype.get=function(i){t(i)?i=this._collectDefaults(this.constructor):this.isString(i)&&(i=[i]);for(var o={},r=0;r<i.length;r++){var s=i[r],a=this,u=o;if(-1!==s.indexOf(".")){for(var p=s.split("."),c=0;c<p.length-1;c++){var h=p[c];u[h]=u[h]||{},u=u[h],a=a[h]}s=p[p.length-1]}var l=a[s];this.isObject(i[s])?u[s]=l.get():n.Signal&&l instanceof n.Signal?u[s]=l.value:n.Param&&l instanceof n.Param?u[s]=l.value:l instanceof AudioParam?u[s]=l.value:l instanceof n?u[s]=l.get():e(l)||t(l)||(u[s]=l)}return o},n.prototype._collectDefaults=function(e){var i=[];if(t(e.defaults)||(i=Object.keys(e.defaults)),!t(e._super))for(var n=this._collectDefaults(e._super),o=0;o<n.length;o++)-1===i.indexOf(n[o])&&i.push(n[o]);return i},n.prototype.toString=function(){for(var t in n){var i=t[0].match(/^[A-Z]$/),o=n[t]===this.constructor;if(e(n[t])&&i&&o)return t}return"Tone"},n.context=i,n.prototype.context=n.context,n.prototype.bufferSize=2048,n.prototype.blockTime=128/n.context.sampleRate,n.prototype.dispose=function(){return this.isUndef(this.input)||(this.input instanceof AudioNode&&this.input.disconnect(),this.input=null),this.isUndef(this.output)||(this.output instanceof AudioNode&&this.output.disconnect(),this.output=null),this};var o=null;n.prototype.noGC=function(){return this.output.connect(o),this},AudioNode.prototype.noGC=function(){return this.connect(o),this},n.prototype.connect=function(t,e,i){return Array.isArray(this.output)?(e=this.defaultArg(e,0),this.output[e].connect(t,0,i)):this.output.connect(t,e,i),this},n.prototype.disconnect=function(t){return Array.isArray(this.output)?(t=this.defaultArg(t,0),this.output[t].disconnect()):this.output.disconnect(),this},n.prototype.connectSeries=function(){if(arguments.length>1)for(var t=arguments[0],e=1;e<arguments.length;e++){var i=arguments[e];t.connect(i),t=i}return this},n.prototype.connectParallel=function(){var t=arguments[0];if(arguments.length>1)for(var e=1;e<arguments.length;e++){var i=arguments[e];t.connect(i)}return this},n.prototype.chain=function(){if(arguments.length>0)for(var t=this,e=0;e<arguments.length;e++){var i=arguments[e];t.connect(i),t=i}return this},n.prototype.fan=function(){if(arguments.length>0)for(var t=0;t<arguments.length;t++)this.connect(arguments[t]);return this},AudioNode.prototype.chain=n.prototype.chain,AudioNode.prototype.fan=n.prototype.fan,n.prototype.defaultArg=function(e,i){if(this.isObject(e)&&this.isObject(i)){var n={};for(var o in e)n[o]=this.defaultArg(i[o],e[o]);for(var r in i)n[r]=this.defaultArg(e[r],i[r]);return n}return t(e)?i:e},n.prototype.optionsObject=function(t,e,i){var n={};if(1===t.length&&this.isObject(t[0]))n=t[0];else for(var o=0;o<e.length;o++)n[e[o]]=t[o];return this.isUndef(i)?n:this.defaultArg(n,i)},n.prototype.isUndef=t,n.prototype.isFunction=e,n.prototype.isNumber=function(t){return"number"==typeof t},n.prototype.isObject=function(t){return"[object Object]"===Object.prototype.toString.call(t)&&t.constructor===Object},n.prototype.isBoolean=function(t){return"boolean"==typeof t},n.prototype.isArray=function(t){return Array.isArray(t)},n.prototype.isString=function(t){return"string"==typeof t},n.noOp=function(){},n.prototype._readOnly=function(t){if(Array.isArray(t))for(var e=0;e<t.length;e++)this._readOnly(t[e]);else Object.defineProperty(this,t,{writable:!1,enumerable:!0})},n.prototype._writable=function(t){if(Array.isArray(t))for(var e=0;e<t.length;e++)this._writable(t[e]);else Object.defineProperty(this,t,{writable:!0})},n.State={Started:"started",Stopped:"stopped",Paused:"paused"},n.prototype.equalPowerScale=function(t){var e=.5*Math.PI;return Math.sin(t*e)},n.prototype.dbToGain=function(t){return Math.pow(2,t/6)},n.prototype.gainToDb=function(t){return 20*(Math.log(t)/Math.LN10)},n.prototype.now=function(){return this.context.currentTime},n.extend=function(e,i){function o(){}t(i)&&(i=n),o.prototype=i.prototype,e.prototype=new o,e.prototype.constructor=e,e._super=i};var r=[];return n._initAudioContext=function(t){t(n.context),r.push(t)},n.setContext=function(t){n.prototype.context=t,n.context=t;for(var e=0;e<r.length;e++)r[e](t)},n.startMobile=function(){var t=n.context.createOscillator(),e=n.context.createGain();e.gain.value=0,t.connect(e),e.connect(n.context.destination);var i=n.context.currentTime;t.start(i),t.stop(i+1)},n._initAudioContext(function(t){n.prototype.blockTime=128/t.sampleRate,o=t.createGain(),o.gain.value=0,o.connect(t.destination)}),n.version="r7-dev",n}();var Tone_signal_SignalBase;Tone_signal_SignalBase=function(t){"use strict";return t.SignalBase=function(){},t.extend(t.SignalBase),t.SignalBase.prototype.connect=function(e,i,n){return t.Signal&&t.Signal===e.constructor||t.Param&&t.Param===e.constructor||t.TimelineSignal&&t.TimelineSignal===e.constructor?(e._param.cancelScheduledValues(0),e._param.value=0,e.overridden=!0):e instanceof AudioParam&&(e.cancelScheduledValues(0),e.value=0),t.prototype.connect.call(this,e,i,n),this},t.SignalBase}(Tone_core_Tone);var Tone_signal_WaveShaper;Tone_signal_WaveShaper=function(t){"use strict";return t.WaveShaper=function(t,e){this._shaper=this.input=this.output=this.context.createWaveShaper(),this._curve=null,Array.isArray(t)?this.curve=t:isFinite(t)||this.isUndef(t)?this._curve=new Float32Array(this.defaultArg(t,1024)):this.isFunction(t)&&(this._curve=new Float32Array(this.defaultArg(e,1024)),this.setMap(t))},t.extend(t.WaveShaper,t.SignalBase),t.WaveShaper.prototype.setMap=function(t){for(var e=0,i=this._curve.length;i>e;e++){var n=e/i*2-1;this._curve[e]=t(n,e)}return this._shaper.curve=this._curve,this},Object.defineProperty(t.WaveShaper.prototype,"curve",{get:function(){return this._shaper.curve},set:function(t){this._curve=new Float32Array(t),this._shaper.curve=this._curve}}),Object.defineProperty(t.WaveShaper.prototype,"oversample",{get:function(){return this._shaper.oversample},set:function(t){if(-1===["none","2x","4x"].indexOf(t))throw new Error("invalid oversampling: "+t);this._shaper.oversample=t}}),t.WaveShaper.prototype.dispose=function(){return t.prototype.dispose.call(this),this._shaper.disconnect(),this._shaper=null,this._curve=null,this},t.WaveShaper}(Tone_core_Tone);var Tone_core_Type;Tone_core_Type=function(Tone){"use strict";function getTransportBpm(){return Tone.Transport&&Tone.Transport.bpm?Tone.Transport.bpm.value:120}function getTransportTimeSignature(){return Tone.Transport&&Tone.Transport.timeSignature?Tone.Transport.timeSignature:4}function toNotationHelper(t,e,i,n){for(var o=this.toSeconds(t),r=this.notationToSeconds(n[n.length-1],e,i),s="",a=0;a<n.length;a++){var u=this.notationToSeconds(n[a],e,i),p=o/u,c=1e-6;if(c>1-p%1&&(p+=c),p=Math.floor(p),p>0){if(s+=1===p?n[a]:p.toString()+"*"+n[a],o-=p*u,r>o)break;s+=" + "}}return""===s&&(s="0"),s}Tone.Type={Default:"number",Time:"time",Frequency:"frequency",NormalRange:"normalRange",AudioRange:"audioRange",Decibels:"db",Interval:"interval",BPM:"bpm",Positive:"positive",Cents:"cents",Degrees:"degrees",MIDI:"midi",TransportTime:"transportTime",Ticks:"tick",Note:"note",Milliseconds:"milliseconds",Notation:"notation"},Tone.prototype.isNowRelative=function(){var t=new RegExp(/^\s*\+(.)+/i);return function(e){return t.test(e)}}(),Tone.prototype.isTicks=function(){var t=new RegExp(/^\d+i$/i);return function(e){return t.test(e)}}(),Tone.prototype.isNotation=function(){var t=new RegExp(/^[0-9]+[mnt]$/i);return function(e){return t.test(e)}}(),Tone.prototype.isTransportTime=function(){var t=new RegExp(/^(\d+(\.\d+)?\:){1,2}(\d+(\.\d+)?)?$/i);return function(e){return t.test(e)}}(),Tone.prototype.isNote=function(){var t=new RegExp(/^[a-g]{1}(b|#|x|bb)?-?[0-9]+$/i);return function(e){return t.test(e)}}(),Tone.prototype.isFrequency=function(){var t=new RegExp(/^\d*\.?\d+hz$/i);return function(e){return t.test(e)}}(),Tone.prototype.notationToSeconds=function(t,e,i){e=this.defaultArg(e,getTransportBpm()),i=this.defaultArg(i,getTransportTimeSignature());var n=60/e;"1n"===t&&(t="1m");var o=parseInt(t,10),r=0;0===o&&(r=0);var s=t.slice(-1);return r="t"===s?4/o*2/3:"n"===s?4/o:"m"===s?o*i:0,n*r},Tone.prototype.transportTimeToSeconds=function(t,e,i){e=this.defaultArg(e,getTransportBpm()),i=this.defaultArg(i,getTransportTimeSignature());var n=0,o=0,r=0,s=t.split(":");2===s.length?(n=parseFloat(s[0]),o=parseFloat(s[1])):1===s.length?o=parseFloat(s[0]):3===s.length&&(n=parseFloat(s[0]),o=parseFloat(s[1]),r=parseFloat(s[2]));var a=n*i+o+r/4;return a*(60/e)},Tone.prototype.ticksToSeconds=function(t,e){if(this.isUndef(Tone.Transport))return 0;t=parseFloat(t),e=this.defaultArg(e,getTransportBpm());var i=60/e/Tone.Transport.PPQ;return i*t},Tone.prototype.frequencyToSeconds=function(t){return 1/parseFloat(t)},Tone.prototype.samplesToSeconds=function(t){return t/this.context.sampleRate},Tone.prototype.secondsToSamples=function(t){return t*this.context.sampleRate},Tone.prototype.secondsToTransportTime=function(t,e,i){e=this.defaultArg(e,getTransportBpm()),i=this.defaultArg(i,getTransportTimeSignature());var n=60/e,o=t/n,r=Math.floor(o/i),s=o%1*4;o=Math.floor(o)%i;var a=[r,o,s];return a.join(":")},Tone.prototype.secondsToFrequency=function(t){return 1/t},Tone.prototype.toTransportTime=function(t,e,i){var n=this.toSeconds(t);return this.secondsToTransportTime(n,e,i)},Tone.prototype.toFrequency=function(t,e){return this.isFrequency(t)?parseFloat(t):this.isNotation(t)||this.isTransportTime(t)?this.secondsToFrequency(this.toSeconds(t,e)):this.isNote(t)?this.noteToFrequency(t):t},Tone.prototype.toTicks=function(t){if(this.isUndef(Tone.Transport))return 0;var e=Tone.Transport.bpm.value,i=0;if(this.isNowRelative(t))t=t.replace("+",""),i=Tone.Transport.ticks;else if(this.isUndef(t))return Tone.Transport.ticks;var n=this.toSeconds(t),o=60/e,r=n/o,s=r*Tone.Transport.PPQ;return Math.round(s+i)},Tone.prototype.toSamples=function(t){var e=this.toSeconds(t);return Math.round(e*this.context.sampleRate)},Tone.prototype.toSeconds=function(time,now){if(now=this.defaultArg(now,this.now()),this.isNumber(time))return time;if(this.isString(time)){var plusTime=0;this.isNowRelative(time)&&(time=time.replace("+",""),plusTime=now);var betweenParens=time.match(/\(([^)(]+)\)/g);if(betweenParens)for(var j=0;j<betweenParens.length;j++){var symbol=betweenParens[j].replace(/[\(\)]/g,""),symbolVal=this.toSeconds(symbol);time=time.replace(betweenParens[j],symbolVal)}if(-1!==time.indexOf("@")){var quantizationSplit=time.split("@");if(this.isUndef(Tone.Transport))throw new Error("quantization requires Tone.Transport");var toQuantize=quantizationSplit[0].trim();""===toQuantize&&(toQuantize=void 0),plusTime>0&&(toQuantize="+"+toQuantize,plusTime=0);var subdivision=quantizationSplit[1].trim();time=Tone.Transport.quantize(toQuantize,subdivision)}else{var components=time.split(/[\(\)\-\+\/\*]/);if(components.length>1){for(var originalTime=time,i=0;i<components.length;i++){var symb=components[i].trim();if(""!==symb){var val=this.toSeconds(symb);time=time.replace(symb,val)}}try{time=eval(time)}catch(e){throw new EvalError("cannot evaluate Time: "+originalTime)}}else time=this.isNotation(time)?this.notationToSeconds(time):this.isTransportTime(time)?this.transportTimeToSeconds(time):this.isFrequency(time)?this.frequencyToSeconds(time):this.isTicks(time)?this.ticksToSeconds(time):parseFloat(time)}return time+plusTime}return now},Tone.prototype.toNotation=function(t,e,i){var n=["1m","2n","4n","8n","16n","32n","64n","128n"],o=toNotationHelper.call(this,t,e,i,n),r=["1m","2n","2t","4n","4t","8n","8t","16n","16t","32n","32t","64n","64t","128n"],s=toNotationHelper.call(this,t,e,i,r);return s.split("+").length<o.split("+").length?s:o},Tone.prototype.fromUnits=function(t,e){if(!this.convert&&!this.isUndef(this.convert))return t;switch(e){case Tone.Type.Time:return this.toSeconds(t);case Tone.Type.Frequency:return this.toFrequency(t);case Tone.Type.Decibels:return this.dbToGain(t);case Tone.Type.NormalRange:return Math.min(Math.max(t,0),1);case Tone.Type.AudioRange:return Math.min(Math.max(t,-1),1);case Tone.Type.Positive:return Math.max(t,0);default:return t}},Tone.prototype.toUnits=function(t,e){if(!this.convert&&!this.isUndef(this.convert))return t;switch(e){case Tone.Type.Decibels:return this.gainToDb(t);default:return t}};var noteToScaleIndex={cbb:-2,cb:-1,c:0,"c#":1,cx:2,dbb:0,db:1,d:2,"d#":3,dx:4,ebb:2,eb:3,e:4,"e#":5,ex:6,fbb:3,fb:4,f:5,"f#":6,fx:7,gbb:5,gb:6,g:7,"g#":8,gx:9,abb:7,ab:8,a:9,"a#":10,ax:11,bbb:9,bb:10,b:11,"b#":12,bx:13},scaleIndexToNote=["C","C#","D","D#","E","F","F#","G","G#","A","A#","B"];return Tone.A4=440,Tone.prototype.noteToFrequency=function(t){var e=t.split(/(-?\d+)/);if(3===e.length){var i=noteToScaleIndex[e[0].toLowerCase()],n=e[1],o=i+12*(parseInt(n,10)+1);return this.midiToFrequency(o)}return 0},Tone.prototype.frequencyToNote=function(t){var e=Math.log(t/Tone.A4)/Math.LN2,i=Math.round(12*e)+57,n=Math.floor(i/12);0>n&&(i+=-12*n);var o=scaleIndexToNote[i%12];return o+n.toString()},Tone.prototype.intervalToFrequencyRatio=function(t){return Math.pow(2,t/12)},Tone.prototype.midiToNote=function(t){var e=Math.floor(t/12)-1,i=t%12;return scaleIndexToNote[i]+e},Tone.prototype.noteToMidi=function(t){var e=t.split(/(\d+)/);if(3===e.length){var i=noteToScaleIndex[e[0].toLowerCase()],n=e[1];return i+12*(parseInt(n,10)+1)}return 0},Tone.prototype.midiToFrequency=function(t){return Tone.A4*Math.pow(2,(t-69)/12)},Tone}(Tone_core_Tone);var Tone_core_Param;Tone_core_Param=function(t){"use strict";return t.Param=function(){var e=this.optionsObject(arguments,["param","units","convert"],t.Param.defaults);this._param=this.input=e.param,this.units=e.units,this.convert=e.convert,this.overridden=!1,this.isUndef(e.value)||(this.value=e.value)},t.extend(t.Param),t.Param.defaults={units:t.Type.Default,convert:!0,param:void 0},Object.defineProperty(t.Param.prototype,"value",{get:function(){return this._toUnits(this._param.value)},set:function(t){var e=this._fromUnits(t);this._param.value=e}}),t.Param.prototype._fromUnits=function(e){if(!this.convert&&!this.isUndef(this.convert))return e;switch(this.units){case t.Type.Time:return this.toSeconds(e);case t.Type.Frequency:return this.toFrequency(e);case t.Type.Decibels:return this.dbToGain(e);case t.Type.NormalRange:return Math.min(Math.max(e,0),1);case t.Type.AudioRange:return Math.min(Math.max(e,-1),1);case t.Type.Positive:return Math.max(e,0);default:return e}},t.Param.prototype._toUnits=function(e){if(!this.convert&&!this.isUndef(this.convert))return e;switch(this.units){case t.Type.Decibels:return this.gainToDb(e);default:return e}},t.Param.prototype._minOutput=1e-5,t.Param.prototype.setValueAtTime=function(t,e){return t=this._fromUnits(t),this._param.setValueAtTime(t,this.toSeconds(e)),this},t.Param.prototype.setRampPoint=function(t){t=this.defaultArg(t,this.now());var e=this._param.value;return this._param.setValueAtTime(e,t),this},t.Param.prototype.linearRampToValueAtTime=function(t,e){return t=this._fromUnits(t),this._param.linearRampToValueAtTime(t,this.toSeconds(e)),this},t.Param.prototype.exponentialRampToValueAtTime=function(t,e){return t=this._fromUnits(t),t=Math.max(this._minOutput,t),this._param.exponentialRampToValueAtTime(t,this.toSeconds(e)),this},t.Param.prototype.exponentialRampToValue=function(t,e){var i=this.now(),n=this.value;return this.setValueAtTime(Math.max(n,this._minOutput),i),this.exponentialRampToValueAtTime(t,i+this.toSeconds(e)),this},t.Param.prototype.linearRampToValue=function(t,e){var i=this.now();return this.setRampPoint(i),this.linearRampToValueAtTime(t,i+this.toSeconds(e)),this},t.Param.prototype.setTargetAtTime=function(t,e,i){return t=this._fromUnits(t),t=Math.max(this._minOutput,t),i=Math.max(this._minOutput,i),this._param.setTargetAtTime(t,this.toSeconds(e),i),this},t.Param.prototype.setValueCurveAtTime=function(t,e,i){for(var n=0;n<t.length;n++)t[n]=this._fromUnits(t[n]);return this._param.setValueCurveAtTime(t,this.toSeconds(e),this.toSeconds(i)),this},t.Param.prototype.cancelScheduledValues=function(t){return this._param.cancelScheduledValues(this.toSeconds(t)),this},t.Param.prototype.rampTo=function(e,i){return i=this.defaultArg(i,0),this.units===t.Type.Frequency||this.units===t.Type.BPM?this.exponentialRampToValue(e,i):this.linearRampToValue(e,i),this},t.Param.prototype.dispose=function(){return t.prototype.dispose.call(this),this._param=null,this},t.Param}(Tone_core_Tone);var Tone_core_Gain;Tone_core_Gain=function(t){"use strict";return t.Gain=function(){var e=this.optionsObject(arguments,["gain","units"],t.Gain.defaults);this.input=this.output=this._gainNode=this.context.createGain(),this.gain=new t.Param({param:this._gainNode.gain,units:e.units,value:e.gain,convert:e.convert}),this._readOnly("gain")},t.extend(t.Gain),t.Gain.defaults={gain:1,convert:!0},t.Gain.prototype.dispose=function(){t.Param.prototype.dispose.call(this),this._gainNode.disconnect(),this._gainNode=null,this._writable("gain"),this.gain.dispose(),this.gain=null},t.Gain}(Tone_core_Tone,Tone_core_Param);var Tone_signal_Signal;Tone_signal_Signal=function(t){"use strict";return t.Signal=function(){var e=this.optionsObject(arguments,["value","units"],t.Signal.defaults);this.output=this._gain=this.context.createGain(),e.param=this._gain.gain,t.Param.call(this,e),this.input=this._param=this._gain.gain,t.Signal._constant.chain(this._gain)},t.extend(t.Signal,t.Param),t.Signal.defaults={value:0,units:t.Type.Default,convert:!0},t.Signal.prototype.connect=t.SignalBase.prototype.connect,t.Signal.prototype.dispose=function(){return t.Param.prototype.dispose.call(this),this._param=null,this._gain.disconnect(),this._gain=null,this},t.Signal._constant=null,t._initAudioContext(function(e){for(var i=e.createBuffer(1,128,e.sampleRate),n=i.getChannelData(0),o=0;o<n.length;o++)n[o]=1;t.Signal._constant=e.createBufferSource(),t.Signal._constant.channelCount=1,t.Signal._constant.channelCountMode="explicit",t.Signal._constant.buffer=i,t.Signal._constant.loop=!0,t.Signal._constant.start(0),t.Signal._constant.noGC()}),t.Signal}(Tone_core_Tone,Tone_signal_WaveShaper,Tone_core_Type,Tone_core_Param);var Tone_signal_Add;Tone_signal_Add=function(t){"use strict";return t.Add=function(e){t.call(this,2,0),this._sum=this.input[0]=this.input[1]=this.output=this.context.createGain(),this._param=this.input[1]=new t.Signal(e),this._param.connect(this._sum)},t.extend(t.Add,t.Signal),t.Add.prototype.dispose=function(){return t.prototype.dispose.call(this),this._sum.disconnect(),this._sum=null,this._param.dispose(),this._param=null,this},t.Add}(Tone_core_Tone);var Tone_signal_Multiply;Tone_signal_Multiply=function(t){"use strict";return t.Multiply=function(e){t.call(this,2,0),this._mult=this.input[0]=this.output=this.context.createGain(),this._param=this.input[1]=this.output.gain,this._param.value=this.defaultArg(e,0)},t.extend(t.Multiply,t.Signal),t.Multiply.prototype.dispose=function(){return t.prototype.dispose.call(this),this._mult.disconnect(),this._mult=null,this._param=null,this},t.Multiply}(Tone_core_Tone);var Tone_signal_Scale;Tone_signal_Scale=function(t){"use strict";return t.Scale=function(e,i){this._outputMin=this.defaultArg(e,0),this._outputMax=this.defaultArg(i,1),this._scale=this.input=new t.Multiply(1),this._add=this.output=new t.Add(0),this._scale.connect(this._add),this._setRange()},t.extend(t.Scale,t.SignalBase),Object.defineProperty(t.Scale.prototype,"min",{get:function(){return this._outputMin},set:function(t){this._outputMin=t,this._setRange()}}),Object.defineProperty(t.Scale.prototype,"max",{get:function(){return this._outputMax},set:function(t){this._outputMax=t,this._setRange()}}),t.Scale.prototype._setRange=function(){this._add.value=this._outputMin,this._scale.value=this._outputMax-this._outputMin},t.Scale.prototype.dispose=function(){return t.prototype.dispose.call(this),this._add.dispose(),this._add=null,this._scale.dispose(),this._scale=null,this},t.Scale}(Tone_core_Tone,Tone_signal_Add,Tone_signal_Multiply);var signal;signal=function(){var t=Tone_signal_Signal,e=Tone_signal_Add,i=Tone_signal_Multiply,n=Tone_signal_Scale,o=Tone_core_Tone,r=master;o.setContext(r.audiocontext),p5.Signal=function(e){var i=new t(e);return i},t.prototype.fade=t.prototype.linearRampToValueAtTime,i.prototype.fade=t.prototype.fade,e.prototype.fade=t.prototype.fade,n.prototype.fade=t.prototype.fade,t.prototype.setInput=function(t){t.connect(this)},i.prototype.setInput=t.prototype.setInput,e.prototype.setInput=t.prototype.setInput,n.prototype.setInput=t.prototype.setInput,t.prototype.add=function(t){var i=new e(t);return this.connect(i),i},i.prototype.add=t.prototype.add,e.prototype.add=t.prototype.add,n.prototype.add=t.prototype.add,t.prototype.mult=function(t){var e=new i(t);return this.connect(e),e},i.prototype.mult=t.prototype.mult,e.prototype.mult=t.prototype.mult,n.prototype.mult=t.prototype.mult,t.prototype.scale=function(t,e,i,o){var r,s;4===arguments.length?(r=p5.prototype.map(i,t,e,0,1)-.5,s=p5.prototype.map(o,t,e,0,1)-.5):(r=arguments[0],s=arguments[1]);var a=new n(r,s);return this.connect(a),a},i.prototype.scale=t.prototype.scale,e.prototype.scale=t.prototype.scale,n.prototype.scale=t.prototype.scale}(Tone_signal_Signal,Tone_signal_Add,Tone_signal_Multiply,Tone_signal_Scale,Tone_core_Tone,master);var oscillator;oscillator=function(){var t=master,e=Tone_signal_Add,i=Tone_signal_Multiply,n=Tone_signal_Scale;p5.Oscillator=function(e,i){if("string"==typeof e){var n=i;i=e,e=n}if("number"==typeof i){var n=i;i=e,e=n}this.started=!1,this.phaseAmount=void 0,this.oscillator=t.audiocontext.createOscillator(),this.f=e||440,this.oscillator.type=i||"sine",this.oscillator.frequency.setValueAtTime(this.f,t.audiocontext.currentTime),this.output=t.audiocontext.createGain(),this._freqMods=[],this.output.gain.value=.5,this.output.gain.setValueAtTime(.5,t.audiocontext.currentTime),this.oscillator.connect(this.output),this.panPosition=0,this.connection=t.input,this.panner=new p5.Panner(this.output,this.connection,1),this.mathOps=[this.output],t.soundArray.push(this)},p5.Oscillator.prototype.start=function(e,i){if(this.started){var n=t.audiocontext.currentTime;this.stop(n)}if(!this.started){var o=i||this.f,r=this.oscillator.type;this.oscillator&&(this.oscillator.disconnect(),this.oscillator=void 0),this.oscillator=t.audiocontext.createOscillator(),this.oscillator.frequency.value=Math.abs(o),this.oscillator.type=r,this.oscillator.connect(this.output),e=e||0,this.oscillator.start(e+t.audiocontext.currentTime),this.freqNode=this.oscillator.frequency;for(var s in this._freqMods)"undefined"!=typeof this._freqMods[s].connect&&this._freqMods[s].connect(this.oscillator.frequency);this.started=!0}},p5.Oscillator.prototype.stop=function(e){if(this.started){var i=e||0,n=t.audiocontext.currentTime;this.oscillator.stop(i+n),this.started=!1}},p5.Oscillator.prototype.amp=function(e,i,n){var o=this;if("number"==typeof e){var i=i||0,n=n||0,r=t.audiocontext.currentTime;this.output.gain.linearRampToValueAtTime(e,r+n+i)}else{if(!e)return this.output.gain;e.connect(o.output.gain)}},p5.Oscillator.prototype.fade=p5.Oscillator.prototype.amp,p5.Oscillator.prototype.getAmp=function(){return this.output.gain.value},p5.Oscillator.prototype.freq=function(e,i,n){if("number"!=typeof e||isNaN(e)){if(!e)return this.oscillator.frequency;e.output&&(e=e.output),e.connect(this.oscillator.frequency),this._freqMods.push(e)}else{this.f=e;var o=t.audiocontext.currentTime,i=i||0,n=n||0;0===i?(this.oscillator.frequency.cancelScheduledValues(o),this.oscillator.frequency.setValueAtTime(e,n+o)):e>0?this.oscillator.frequency.exponentialRampToValueAtTime(e,n+i+o):this.oscillator.frequency.linearRampToValueAtTime(e,n+i+o),this.phaseAmount&&this.phase(this.phaseAmount)}},p5.Oscillator.prototype.getFreq=function(){return this.oscillator.frequency.value},p5.Oscillator.prototype.setType=function(t){this.oscillator.type=t},p5.Oscillator.prototype.getType=function(){return this.oscillator.type},p5.Oscillator.prototype.connect=function(e){e?e.hasOwnProperty("input")?(this.panner.connect(e.input),this.connection=e.input):(this.panner.connect(e),this.connection=e):this.panner.connect(t.input)},p5.Oscillator.prototype.disconnect=function(){this.output.disconnect(),this.panner.disconnect(),this.output.connect(this.panner),this.oscMods=[]},p5.Oscillator.prototype.pan=function(t,e){this.panPosition=t,this.panner.pan(t,e)},p5.Oscillator.prototype.getPan=function(){return this.panPosition},p5.Oscillator.prototype.dispose=function(){var e=t.soundArray.indexOf(this);if(t.soundArray.splice(e,1),this.oscillator){var i=t.audiocontext.currentTime;this.stop(i),this.disconnect(),this.panner=null,this.oscillator=null}this.osc2&&this.osc2.dispose()},p5.Oscillator.prototype.phase=function(e){var i=p5.prototype.map(e,0,1,0,1/this.f),n=t.audiocontext.currentTime;this.phaseAmount=e,this.dNode||(this.dNode=t.audiocontext.createDelay(),this.oscillator.disconnect(),this.oscillator.connect(this.dNode),this.dNode.connect(this.output)),this.dNode.delayTime.setValueAtTime(i,n)};var o=function(t,e,i,n,o){var r=t.oscillator;for(var s in t.mathOps)t.mathOps[s]instanceof o&&(r.disconnect(),t.mathOps[s].dispose(),i=s,i<t.mathOps.length-2&&(n=t.mathOps[s+1]));return i===t.mathOps.length-1&&t.mathOps.push(n),s>0&&(r=t.mathOps[s-1]),r.disconnect(),r.connect(e),e.connect(n),t.mathOps[i]=e,t};p5.Oscillator.prototype.add=function(t){var i=new e(t),n=this.mathOps.length-1,r=this.output;return o(this,i,n,r,e)},p5.Oscillator.prototype.mult=function(t){var e=new i(t),n=this.mathOps.length-1,r=this.output;return o(this,e,n,r,i)},p5.Oscillator.prototype.scale=function(t,e,i,r){var s,a;4===arguments.length?(s=p5.prototype.map(i,t,e,0,1)-.5,a=p5.prototype.map(r,t,e,0,1)-.5):(s=arguments[0],a=arguments[1]);var u=new n(s,a),p=this.mathOps.length-1,c=this.output;return o(this,u,p,c,n)},p5.SinOsc=function(t){p5.Oscillator.call(this,t,"sine")},p5.SinOsc.prototype=Object.create(p5.Oscillator.prototype),p5.TriOsc=function(t){p5.Oscillator.call(this,t,"triangle")},p5.TriOsc.prototype=Object.create(p5.Oscillator.prototype),p5.SawOsc=function(t){p5.Oscillator.call(this,t,"sawtooth")},p5.SawOsc.prototype=Object.create(p5.Oscillator.prototype),p5.SqrOsc=function(t){p5.Oscillator.call(this,t,"square")},p5.SqrOsc.prototype=Object.create(p5.Oscillator.prototype)}(master,Tone_signal_Add,Tone_signal_Multiply,Tone_signal_Scale);var Tone_core_Timeline;Tone_core_Timeline=function(t){"use strict";return t.Timeline=function(){var e=this.optionsObject(arguments,["memory"],t.Timeline.defaults);this._timeline=[],this._toRemove=[],this._iterating=!1,this.memory=e.memory},t.extend(t.Timeline),t.Timeline.defaults={memory:1/0},Object.defineProperty(t.Timeline.prototype,"length",{get:function(){return this._timeline.length}}),t.Timeline.prototype.addEvent=function(t){if(this.isUndef(t.time))throw new Error("events must have a time attribute");if(t.time=this.toSeconds(t.time),this._timeline.length){var e=this._search(t.time);this._timeline.splice(e+1,0,t)}else this._timeline.push(t);if(this.length>this.memory){var i=this.length-this.memory;this._timeline.splice(0,i)}return this},t.Timeline.prototype.removeEvent=function(t){if(this._iterating)this._toRemove.push(t);else{var e=this._timeline.indexOf(t);-1!==e&&this._timeline.splice(e,1)}return this},t.Timeline.prototype.getEvent=function(t){t=this.toSeconds(t);var e=this._search(t);return-1!==e?this._timeline[e]:null},t.Timeline.prototype.getEventAfter=function(t){t=this.toSeconds(t);var e=this._search(t);return e+1<this._timeline.length?this._timeline[e+1]:null},t.Timeline.prototype.getEventBefore=function(t){t=this.toSeconds(t);var e=this._search(t);return e-1>=0?this._timeline[e-1]:null},t.Timeline.prototype.cancel=function(t){if(this._timeline.length>1){t=this.toSeconds(t);var e=this._search(t);e>=0?this._timeline=this._timeline.slice(0,e):this._timeline=[]}else 1===this._timeline.length&&this._timeline[0].time>=t&&(this._timeline=[]);return this},t.Timeline.prototype.cancelBefore=function(t){if(this._timeline.length){t=this.toSeconds(t);var e=this._search(t);e>=0&&(this._timeline=this._timeline.slice(e+1))}return this},t.Timeline.prototype._search=function(t){for(var e=0,i=this._timeline.length,n=i;n>=e&&i>e;){var o=Math.floor(e+(n-e)/2),r=this._timeline[o];if(r.time===t){for(var s=o;s<this._timeline.length;s++){var a=this._timeline[s];a.time===t&&(o=s)}return o}r.time>t?n=o-1:r.time<t&&(e=o+1)}return e-1},t.Timeline.prototype._iterate=function(t,e,i){this._iterating=!0,e=this.defaultArg(e,0),i=this.defaultArg(i,this._timeline.length-1);for(var n=e;i>=n;n++)t(this._timeline[n]);if(this._iterating=!1,this._toRemove.length>0){for(var o=0;o<this._toRemove.length;o++){var r=this._timeline.indexOf(this._toRemove[o]);-1!==r&&this._timeline.splice(r,1)}this._toRemove=[]}},t.Timeline.prototype.forEach=function(t){return this._iterate(t),this},t.Timeline.prototype.forEachBefore=function(t,e){t=this.toSeconds(t);var i=this._search(t);return-1!==i&&this._iterate(e,0,i),this},t.Timeline.prototype.forEachAfter=function(t,e){t=this.toSeconds(t);var i=this._search(t);return this._iterate(e,i+1),this},t.Timeline.prototype.forEachFrom=function(t,e){t=this.toSeconds(t);for(var i=this._search(t);i>=0&&this._timeline[i].time>=t;)i--;return this._iterate(e,i+1),this},t.Timeline.prototype.forEachAtTime=function(t,e){t=this.toSeconds(t);var i=this._search(t);return-1!==i&&this._iterate(function(i){i.time===t&&e(i)},0,i),this},t.Timeline.prototype.dispose=function(){t.prototype.dispose.call(this),this._timeline=null,this._toRemove=null},t.Timeline}(Tone_core_Tone);var Tone_signal_TimelineSignal;Tone_signal_TimelineSignal=function(t){"use strict";return t.TimelineSignal=function(){var e=this.optionsObject(arguments,["value","units"],t.Signal.defaults);t.Signal.apply(this,e),e.param=this._param,t.Param.call(this,e),this._events=new t.Timeline(10),this._initial=this._fromUnits(this._param.value)},t.extend(t.TimelineSignal,t.Param),t.TimelineSignal.Type={Linear:"linear",Exponential:"exponential",Target:"target",Set:"set"},Object.defineProperty(t.TimelineSignal.prototype,"value",{get:function(){return this._toUnits(this._param.value)},set:function(t){var e=this._fromUnits(t);this._initial=e,this._param.value=e}}),t.TimelineSignal.prototype.setValueAtTime=function(e,i){return e=this._fromUnits(e),i=this.toSeconds(i),this._events.addEvent({type:t.TimelineSignal.Type.Set,value:e,time:i}),this._param.setValueAtTime(e,i),this},t.TimelineSignal.prototype.linearRampToValueAtTime=function(e,i){return e=this._fromUnits(e),i=this.toSeconds(i),this._events.addEvent({type:t.TimelineSignal.Type.Linear,value:e,time:i}),this._param.linearRampToValueAtTime(e,i),
this},t.TimelineSignal.prototype.exponentialRampToValueAtTime=function(e,i){return e=this._fromUnits(e),e=Math.max(this._minOutput,e),i=this.toSeconds(i),this._events.addEvent({type:t.TimelineSignal.Type.Exponential,value:e,time:i}),this._param.exponentialRampToValueAtTime(e,i),this},t.TimelineSignal.prototype.setTargetAtTime=function(e,i,n){return e=this._fromUnits(e),e=Math.max(this._minOutput,e),n=Math.max(this._minOutput,n),i=this.toSeconds(i),this._events.addEvent({type:t.TimelineSignal.Type.Target,value:e,time:i,constant:n}),this._param.setTargetAtTime(e,i,n),this},t.TimelineSignal.prototype.cancelScheduledValues=function(t){return this._events.cancel(t),this._param.cancelScheduledValues(this.toSeconds(t)),this},t.TimelineSignal.prototype.setRampPoint=function(e){e=this.toSeconds(e);var i=this.getValueAtTime(e),n=this._searchAfter(e);return n&&(this.cancelScheduledValues(e),n.type===t.TimelineSignal.Type.Linear?this.linearRampToValueAtTime(i,e):n.type===t.TimelineSignal.Type.Exponential&&this.exponentialRampToValueAtTime(i,e)),this.setValueAtTime(i,e),this},t.TimelineSignal.prototype.linearRampToValueBetween=function(t,e,i){return this.setRampPoint(e),this.linearRampToValueAtTime(t,i),this},t.TimelineSignal.prototype.exponentialRampToValueBetween=function(t,e,i){return this.setRampPoint(e),this.exponentialRampToValueAtTime(t,i),this},t.TimelineSignal.prototype._searchBefore=function(t){return this._events.getEvent(t)},t.TimelineSignal.prototype._searchAfter=function(t){return this._events.getEventAfter(t)},t.TimelineSignal.prototype.getValueAtTime=function(e){var i=this._searchAfter(e),n=this._searchBefore(e),o=this._initial;if(null===n)o=this._initial;else if(n.type===t.TimelineSignal.Type.Target){var r,s=this._events.getEventBefore(n.time);r=null===s?this._initial:s.value,o=this._exponentialApproach(n.time,r,n.value,n.constant,e)}else o=null===i?n.value:i.type===t.TimelineSignal.Type.Linear?this._linearInterpolate(n.time,n.value,i.time,i.value,e):i.type===t.TimelineSignal.Type.Exponential?this._exponentialInterpolate(n.time,n.value,i.time,i.value,e):n.value;return o},t.TimelineSignal.prototype.connect=t.SignalBase.prototype.connect,t.TimelineSignal.prototype._exponentialApproach=function(t,e,i,n,o){return i+(e-i)*Math.exp(-(o-t)/n)},t.TimelineSignal.prototype._linearInterpolate=function(t,e,i,n,o){return e+(n-e)*((o-t)/(i-t))},t.TimelineSignal.prototype._exponentialInterpolate=function(t,e,i,n,o){return e=Math.max(this._minOutput,e),e*Math.pow(n/e,(o-t)/(i-t))},t.TimelineSignal.prototype.dispose=function(){t.Signal.prototype.dispose.call(this),t.Param.prototype.dispose.call(this),this._events.dispose(),this._events=null},t.TimelineSignal}(Tone_core_Tone,Tone_signal_Signal);var env;env=function(){var t=master,e=Tone_signal_Add,i=Tone_signal_Multiply,n=Tone_signal_Scale,o=Tone_signal_TimelineSignal,r=Tone_core_Tone;r.setContext(t.audiocontext),p5.Env=function(e,i,n,r,s,a){this.aTime=e||.1,this.aLevel=i||1,this.dTime=n||.5,this.dLevel=r||0,this.rTime=s||0,this.rLevel=a||0,this._rampHighPercentage=.98,this._rampLowPercentage=.02,this.output=t.audiocontext.createGain(),this.control=new o,this._init(),this.control.connect(this.output),this.connection=null,this.mathOps=[this.control],this.isExponential=!1,this.sourceToClear=null,this.wasTriggered=!1,t.soundArray.push(this)},p5.Env.prototype._init=function(){var e=t.audiocontext.currentTime,i=e;this.control.setTargetAtTime(1e-5,i,.001),this._setRampAD(this.aTime,this.dTime)},p5.Env.prototype.set=function(t,e,i,n,o,r){this.aTime=t,this.aLevel=e,this.dTime=i||0,this.dLevel=n||0,this.rTime=o||0,this.rLevel=r||0,this._setRampAD(t,i)},p5.Env.prototype.setADSR=function(t,e,i,n){this.aTime=t,this.dTime=e||0,this.sPercent=i||0,this.dLevel="undefined"!=typeof i?i*(this.aLevel-this.rLevel)+this.rLevel:0,this.rTime=n||0,this._setRampAD(t,e)},p5.Env.prototype.setRange=function(t,e){this.aLevel=t||1,this.rLevel=e||0},p5.Env.prototype._setRampAD=function(t,e){this._rampAttackTime=this.checkExpInput(t),this._rampDecayTime=this.checkExpInput(e);var i=1;i=Math.log(1/this.checkExpInput(1-this._rampHighPercentage)),this._rampAttackTC=t/this.checkExpInput(i),i=Math.log(1/this._rampLowPercentage),this._rampDecayTC=e/this.checkExpInput(i)},p5.Env.prototype.setRampPercentages=function(t,e){this._rampHighPercentage=this.checkExpInput(t),this._rampLowPercentage=this.checkExpInput(e);var i=1;i=Math.log(1/this.checkExpInput(1-this._rampHighPercentage)),this._rampAttackTC=this._rampAttackTime/this.checkExpInput(i),i=Math.log(1/this._rampLowPercentage),this._rampDecayTC=this._rampDecayTime/this.checkExpInput(i)},p5.Env.prototype.setInput=function(){for(var t=0;t<arguments.length;t++)this.connect(arguments[t])},p5.Env.prototype.setExp=function(t){this.isExponential=t},p5.Env.prototype.checkExpInput=function(t){return 0>=t&&(t=1e-8),t},p5.Env.prototype.play=function(t,e,i){var n=e||0,i=i||0;t&&this.connection!==t&&this.connect(t),this.triggerAttack(t,n),this.triggerRelease(t,n+this.aTime+this.dTime+i)},p5.Env.prototype.triggerAttack=function(e,i){var n=t.audiocontext.currentTime,o=i||0,r=n+o;this.lastAttack=r,this.wasTriggered=!0,e&&this.connection!==e&&this.connect(e);var s=this.control.getValueAtTime(r);this.control.cancelScheduledValues(r),this.isExponential===!0?this.control.exponentialRampToValueAtTime(this.checkExpInput(s),r):this.control.linearRampToValueAtTime(s,r),r+=this.aTime,this.isExponential===!0?(this.control.exponentialRampToValueAtTime(this.checkExpInput(this.aLevel),r),s=this.checkExpInput(this.control.getValueAtTime(r)),this.control.cancelScheduledValues(r),this.control.exponentialRampToValueAtTime(s,r)):(this.control.linearRampToValueAtTime(this.aLevel,r),s=this.control.getValueAtTime(r),this.control.cancelScheduledValues(r),this.control.linearRampToValueAtTime(s,r)),r+=this.dTime,this.isExponential===!0?(this.control.exponentialRampToValueAtTime(this.checkExpInput(this.dLevel),r),s=this.checkExpInput(this.control.getValueAtTime(r)),this.control.cancelScheduledValues(r),this.control.exponentialRampToValueAtTime(s,r)):(this.control.linearRampToValueAtTime(this.dLevel,r),s=this.control.getValueAtTime(r),this.control.cancelScheduledValues(r),this.control.linearRampToValueAtTime(s,r))},p5.Env.prototype.triggerRelease=function(e,i){if(this.wasTriggered){var n=t.audiocontext.currentTime,o=i||0,r=n+o;e&&this.connection!==e&&this.connect(e);var s=this.control.getValueAtTime(r);this.control.cancelScheduledValues(r),this.isExponential===!0?this.control.exponentialRampToValueAtTime(this.checkExpInput(s),r):this.control.linearRampToValueAtTime(s,r),r+=this.rTime,this.isExponential===!0?(this.control.exponentialRampToValueAtTime(this.checkExpInput(this.rLevel),r),s=this.checkExpInput(this.control.getValueAtTime(r)),this.control.cancelScheduledValues(r),this.control.exponentialRampToValueAtTime(s,r)):(this.control.linearRampToValueAtTime(this.rLevel,r),s=this.control.getValueAtTime(r),this.control.cancelScheduledValues(r),this.control.linearRampToValueAtTime(s,r)),this.wasTriggered=!1}},p5.Env.prototype.ramp=function(e,i,n,o){var r=t.audiocontext.currentTime,s=i||0,a=r+s,u=this.checkExpInput(n),p="undefined"!=typeof o?this.checkExpInput(o):void 0;e&&this.connection!==e&&this.connect(e);var c=this.checkExpInput(this.control.getValueAtTime(a));this.control.cancelScheduledValues(a),u>c?(this.control.setTargetAtTime(u,a,this._rampAttackTC),a+=this._rampAttackTime):c>u&&(this.control.setTargetAtTime(u,a,this._rampDecayTC),a+=this._rampDecayTime),void 0!==p&&(p>u?this.control.setTargetAtTime(p,a,this._rampAttackTC):u>p&&this.control.setTargetAtTime(p,a,this._rampDecayTC))},p5.Env.prototype.connect=function(e){this.connection=e,(e instanceof p5.Oscillator||e instanceof p5.SoundFile||e instanceof p5.AudioIn||e instanceof p5.Reverb||e instanceof p5.Noise||e instanceof p5.Filter||e instanceof p5.Delay)&&(e=e.output.gain),e instanceof AudioParam&&e.setValueAtTime(0,t.audiocontext.currentTime),e instanceof p5.Signal&&e.setValue(0),this.output.connect(e)},p5.Env.prototype.disconnect=function(){this.output.disconnect()},p5.Env.prototype.add=function(t){var i=new e(t),n=this.mathOps.length,o=this.output;return p5.prototype._mathChain(this,i,n,o,e)},p5.Env.prototype.mult=function(t){var e=new i(t),n=this.mathOps.length,o=this.output;return p5.prototype._mathChain(this,e,n,o,i)},p5.Env.prototype.scale=function(t,e,i,o){var r=new n(t,e,i,o),s=this.mathOps.length,a=this.output;return p5.prototype._mathChain(this,r,s,a,n)},p5.Env.prototype.dispose=function(){var e=t.soundArray.indexOf(this);t.soundArray.splice(e,1),this.disconnect();try{this.control.dispose(),this.control=null}catch(i){console.warn(i,"already disposed p5.Env")}for(var n=1;n<this.mathOps.length;n++)this.mathOps[n].dispose()}}(master,Tone_signal_Add,Tone_signal_Multiply,Tone_signal_Scale,Tone_signal_TimelineSignal,Tone_core_Tone);var pulse;pulse=function(){function t(){for(var t=e.audiocontext,i=t.createBuffer(1,2048,t.sampleRate),n=i.getChannelData(0),o=0;2048>o;o++)n[o]=1;var r=t.createBufferSource();return r.buffer=i,r.loop=!0,r}var e=master;p5.Pulse=function(i,n){p5.Oscillator.call(this,i,"sawtooth"),this.w=n||0,this.osc2=new p5.SawOsc(i),this.dNode=e.audiocontext.createDelay(),this.dcOffset=t(),this.dcGain=e.audiocontext.createGain(),this.dcOffset.connect(this.dcGain),this.dcGain.connect(this.output),this.f=i||440;var o=this.w/this.oscillator.frequency.value;this.dNode.delayTime.value=o,this.dcGain.gain.value=1.7*(.5-this.w),this.osc2.disconnect(),this.osc2.panner.disconnect(),this.osc2.amp(-1),this.osc2.output.connect(this.dNode),this.dNode.connect(this.output),this.output.gain.value=1,this.output.connect(this.panner)},p5.Pulse.prototype=Object.create(p5.Oscillator.prototype),p5.Pulse.prototype.width=function(t){if("number"==typeof t){if(1>=t&&t>=0){this.w=t;var e=this.w/this.oscillator.frequency.value;this.dNode.delayTime.value=e}this.dcGain.gain.value=1.7*(.5-this.w)}else{t.connect(this.dNode.delayTime);var i=new p5.SignalAdd(-.5);i.setInput(t),i=i.mult(-1),i=i.mult(1.7),i.connect(this.dcGain.gain)}},p5.Pulse.prototype.start=function(i,n){var o=e.audiocontext.currentTime,r=n||0;if(!this.started){var s=i||this.f,a=this.oscillator.type;this.oscillator=e.audiocontext.createOscillator(),this.oscillator.frequency.setValueAtTime(s,o),this.oscillator.type=a,this.oscillator.connect(this.output),this.oscillator.start(r+o),this.osc2.oscillator=e.audiocontext.createOscillator(),this.osc2.oscillator.frequency.setValueAtTime(s,r+o),this.osc2.oscillator.type=a,this.osc2.oscillator.connect(this.osc2.output),this.osc2.start(r+o),this.freqNode=[this.oscillator.frequency,this.osc2.oscillator.frequency],this.dcOffset=t(),this.dcOffset.connect(this.dcGain),this.dcOffset.start(r+o),void 0!==this.mods&&void 0!==this.mods.frequency&&(this.mods.frequency.connect(this.freqNode[0]),this.mods.frequency.connect(this.freqNode[1])),this.started=!0,this.osc2.started=!0}},p5.Pulse.prototype.stop=function(t){if(this.started){var i=t||0,n=e.audiocontext.currentTime;this.oscillator.stop(i+n),this.osc2.oscillator.stop(i+n),this.dcOffset.stop(i+n),this.started=!1,this.osc2.started=!1}},p5.Pulse.prototype.freq=function(t,i,n){if("number"==typeof t){this.f=t;var o=e.audiocontext.currentTime,i=i||0,n=n||0,r=this.oscillator.frequency.value;this.oscillator.frequency.cancelScheduledValues(o),this.oscillator.frequency.setValueAtTime(r,o+n),this.oscillator.frequency.exponentialRampToValueAtTime(t,n+i+o),this.osc2.oscillator.frequency.cancelScheduledValues(o),this.osc2.oscillator.frequency.setValueAtTime(r,o+n),this.osc2.oscillator.frequency.exponentialRampToValueAtTime(t,n+i+o),this.freqMod&&(this.freqMod.output.disconnect(),this.freqMod=null)}else t.output&&(t.output.disconnect(),t.output.connect(this.oscillator.frequency),t.output.connect(this.osc2.oscillator.frequency),this.freqMod=t)}}(master,oscillator);var noise;noise=function(){var t=master;p5.Noise=function(t){var o;p5.Oscillator.call(this),delete this.f,delete this.freq,delete this.oscillator,o="brown"===t?n:"pink"===t?i:e,this.buffer=o},p5.Noise.prototype=Object.create(p5.Oscillator.prototype);var e=function(){for(var e=2*t.audiocontext.sampleRate,i=t.audiocontext.createBuffer(1,e,t.audiocontext.sampleRate),n=i.getChannelData(0),o=0;e>o;o++)n[o]=2*Math.random()-1;return i.type="white",i}(),i=function(){var e,i,n,o,r,s,a,u=2*t.audiocontext.sampleRate,p=t.audiocontext.createBuffer(1,u,t.audiocontext.sampleRate),c=p.getChannelData(0);e=i=n=o=r=s=a=0;for(var h=0;u>h;h++){var l=2*Math.random()-1;e=.99886*e+.0555179*l,i=.99332*i+.0750759*l,n=.969*n+.153852*l,o=.8665*o+.3104856*l,r=.55*r+.5329522*l,s=-.7616*s-.016898*l,c[h]=e+i+n+o+r+s+a+.5362*l,c[h]*=.11,a=.115926*l}return p.type="pink",p}(),n=function(){for(var e=2*t.audiocontext.sampleRate,i=t.audiocontext.createBuffer(1,e,t.audiocontext.sampleRate),n=i.getChannelData(0),o=0,r=0;e>r;r++){var s=2*Math.random()-1;n[r]=(o+.02*s)/1.02,o=n[r],n[r]*=3.5}return i.type="brown",i}();p5.Noise.prototype.setType=function(o){switch(o){case"white":this.buffer=e;break;case"pink":this.buffer=i;break;case"brown":this.buffer=n;break;default:this.buffer=e}if(this.started){var r=t.audiocontext.currentTime;this.stop(r),this.start(r+.01)}},p5.Noise.prototype.getType=function(){return this.buffer.type},p5.Noise.prototype.start=function(){this.started&&this.stop(),this.noise=t.audiocontext.createBufferSource(),this.noise.buffer=this.buffer,this.noise.loop=!0,this.noise.connect(this.output);var e=t.audiocontext.currentTime;this.noise.start(e),this.started=!0},p5.Noise.prototype.stop=function(){var e=t.audiocontext.currentTime;this.noise&&(this.noise.stop(e),this.started=!1)},p5.Noise.prototype.dispose=function(){var e=t.audiocontext.currentTime,i=t.soundArray.indexOf(this);t.soundArray.splice(i,1),this.noise&&(this.noise.disconnect(),this.stop(e)),this.output&&this.output.disconnect(),this.panner&&this.panner.disconnect(),this.output=null,this.panner=null,this.buffer=null,this.noise=null}}(master);var audioin;audioin=function(){var t=master;p5.AudioIn=function(e){this.input=t.audiocontext.createGain(),this.output=t.audiocontext.createGain(),this.stream=null,this.mediaStream=null,this.currentSource=0,this.enabled=!1,this.amplitude=new p5.Amplitude,this.output.connect(this.amplitude.input),"undefined"==typeof window.MediaStreamTrack?e?e():window.alert("This browser does not support AudioIn"):"function"==typeof window.MediaDevices.enumerateDevices&&window.MediaDevices.enumerateDevices(this._gotSources),t.soundArray.push(this)},p5.AudioIn.prototype.start=function(e,i){var n=this;if(t.inputSources[n.currentSource]){var o=t.inputSources[n.currentSource].id,r={audio:{optional:[{sourceId:o}]}};window.navigator.getUserMedia(r,this._onStream=function(i){n.stream=i,n.enabled=!0,n.mediaStream=t.audiocontext.createMediaStreamSource(i),n.mediaStream.connect(n.output),e&&e(),n.amplitude.setInput(n.output)},this._onStreamError=function(t){i?i(t):console.error(t)})}else window.navigator.getUserMedia({audio:!0},this._onStream=function(i){n.stream=i,n.enabled=!0,n.mediaStream=t.audiocontext.createMediaStreamSource(i),n.mediaStream.connect(n.output),n.amplitude.setInput(n.output),e&&e()},this._onStreamError=function(t){i?i(t):console.error(t)})},p5.AudioIn.prototype.stop=function(){this.stream&&this.stream.getTracks()[0].stop()},p5.AudioIn.prototype.connect=function(e){e?e.hasOwnProperty("input")?this.output.connect(e.input):e.hasOwnProperty("analyser")?this.output.connect(e.analyser):this.output.connect(e):this.output.connect(t.input)},p5.AudioIn.prototype.disconnect=function(){this.output.disconnect(),this.output.connect(this.amplitude.input)},p5.AudioIn.prototype.getLevel=function(t){return t&&(this.amplitude.smoothing=t),this.amplitude.getLevel()},p5.AudioIn.prototype._gotSources=function(t){for(var e=0;e<t.length;e++){var i=t[e];if("audio"===i.kind)return i}},p5.AudioIn.prototype.amp=function(e,i){if(i){var n=i||0,o=this.output.gain.value;this.output.gain.cancelScheduledValues(t.audiocontext.currentTime),this.output.gain.setValueAtTime(o,t.audiocontext.currentTime),this.output.gain.linearRampToValueAtTime(e,n+t.audiocontext.currentTime)}else this.output.gain.cancelScheduledValues(t.audiocontext.currentTime),this.output.gain.setValueAtTime(e,t.audiocontext.currentTime)},p5.AudioIn.prototype.listSources=function(){return console.log("listSources is deprecated - please use AudioIn.getSources"),console.log("input sources: "),t.inputSources.length>0?t.inputSources:"This browser does not support MediaStreamTrack.getSources()"},p5.AudioIn.prototype.getSources=function(e){"function"==typeof window.MediaStreamTrack.getSources?window.MediaStreamTrack.getSources(function(i){for(var n=0,o=i.length;o>n;n++){var r=i[n];"audio"===r.kind&&t.inputSources.push(r)}e(t.inputSources)}):console.log("This browser does not support MediaStreamTrack.getSources()")},p5.AudioIn.prototype.setSource=function(e){var i=this;t.inputSources.length>0&&e<t.inputSources.length?(i.currentSource=e,console.log("set source to "+t.inputSources[i.currentSource].id)):console.log("unable to set input source")},p5.AudioIn.prototype.dispose=function(){var e=t.soundArray.indexOf(this);t.soundArray.splice(e,1),this.stop(),this.output&&this.output.disconnect(),this.amplitude&&this.amplitude.disconnect(),this.amplitude=null,this.output=null}}(master);var Tone_signal_Negate;Tone_signal_Negate=function(t){"use strict";return t.Negate=function(){this._multiply=this.input=this.output=new t.Multiply(-1)},t.extend(t.Negate,t.SignalBase),t.Negate.prototype.dispose=function(){return t.prototype.dispose.call(this),this._multiply.dispose(),this._multiply=null,this},t.Negate}(Tone_core_Tone,Tone_signal_Multiply);var Tone_signal_Subtract;Tone_signal_Subtract=function(t){"use strict";return t.Subtract=function(e){t.call(this,2,0),this._sum=this.input[0]=this.output=this.context.createGain(),this._neg=new t.Negate,this._param=this.input[1]=new t.Signal(e),this._param.chain(this._neg,this._sum)},t.extend(t.Subtract,t.Signal),t.Subtract.prototype.dispose=function(){return t.prototype.dispose.call(this),this._neg.dispose(),this._neg=null,this._sum.disconnect(),this._sum=null,this._param.dispose(),this._param=null,this},t.Subtract}(Tone_core_Tone,Tone_signal_Add,Tone_signal_Negate);var Tone_signal_GreaterThanZero;Tone_signal_GreaterThanZero=function(t){"use strict";return t.GreaterThanZero=function(){this._thresh=this.output=new t.WaveShaper(function(t){return 0>=t?0:1}),this._scale=this.input=new t.Multiply(1e4),this._scale.connect(this._thresh)},t.extend(t.GreaterThanZero,t.SignalBase),t.GreaterThanZero.prototype.dispose=function(){return t.prototype.dispose.call(this),this._scale.dispose(),this._scale=null,this._thresh.dispose(),this._thresh=null,this},t.GreaterThanZero}(Tone_core_Tone,Tone_signal_Signal,Tone_signal_Multiply);var Tone_signal_EqualZero;Tone_signal_EqualZero=function(t){"use strict";return t.EqualZero=function(){this._scale=this.input=new t.Multiply(1e4),this._thresh=new t.WaveShaper(function(t){return 0===t?1:0},128),this._gtz=this.output=new t.GreaterThanZero,this._scale.chain(this._thresh,this._gtz)},t.extend(t.EqualZero,t.SignalBase),t.EqualZero.prototype.dispose=function(){return t.prototype.dispose.call(this),this._gtz.dispose(),this._gtz=null,this._scale.dispose(),this._scale=null,this._thresh.dispose(),this._thresh=null,this},t.EqualZero}(Tone_core_Tone,Tone_signal_Signal,Tone_signal_GreaterThanZero);var Tone_signal_Equal;Tone_signal_Equal=function(t){"use strict";return t.Equal=function(e){t.call(this,2,0),this._sub=this.input[0]=new t.Subtract(e),this._equals=this.output=new t.EqualZero,this._sub.connect(this._equals),this.input[1]=this._sub.input[1]},t.extend(t.Equal,t.SignalBase),Object.defineProperty(t.Equal.prototype,"value",{get:function(){return this._sub.value},set:function(t){this._sub.value=t}}),t.Equal.prototype.dispose=function(){return t.prototype.dispose.call(this),this._equals.dispose(),this._equals=null,this._sub.dispose(),this._sub=null,this},t.Equal}(Tone_core_Tone,Tone_signal_EqualZero,Tone_signal_Subtract);var Tone_signal_Select;Tone_signal_Select=function(t){"use strict";t.Select=function(i){i=this.defaultArg(i,2),t.call(this,i,1),this.gate=new t.Signal(0),this._readOnly("gate");for(var n=0;i>n;n++){var o=new e(n);this.input[n]=o,this.gate.connect(o.selecter),o.connect(this.output)}},t.extend(t.Select,t.SignalBase),t.Select.prototype.select=function(t,e){return t=Math.floor(t),this.gate.setValueAtTime(t,this.toSeconds(e)),this},t.Select.prototype.dispose=function(){this._writable("gate"),this.gate.dispose(),this.gate=null;for(var e=0;e<this.input.length;e++)this.input[e].dispose(),this.input[e]=null;return t.prototype.dispose.call(this),this};var e=function(e){this.selecter=new t.Equal(e),this.gate=this.input=this.output=this.context.createGain(),this.selecter.connect(this.gate.gain)};return t.extend(e),e.prototype.dispose=function(){t.prototype.dispose.call(this),this.selecter.dispose(),this.gate.disconnect(),this.selecter=null,this.gate=null},t.Select}(Tone_core_Tone,Tone_signal_Equal);var Tone_signal_IfThenElse;Tone_signal_IfThenElse=function(t){"use strict";return t.IfThenElse=function(){t.call(this,3,0),this._selector=this.output=new t.Select(2),this["if"]=this.input[0]=this._selector.gate,this.then=this.input[1]=this._selector.input[1],this["else"]=this.input[2]=this._selector.input[0]},t.extend(t.IfThenElse,t.SignalBase),t.IfThenElse.prototype.dispose=function(){return t.prototype.dispose.call(this),this._selector.dispose(),this._selector=null,this["if"]=null,this.then=null,this["else"]=null,this},t.IfThenElse}(Tone_core_Tone,Tone_signal_Select);var Tone_signal_OR;Tone_signal_OR=function(t){"use strict";return t.OR=function(e){e=this.defaultArg(e,2),t.call(this,e,0),this._sum=this.context.createGain(),this._gtz=this.output=new t.GreaterThanZero;for(var i=0;e>i;i++)this.input[i]=this._sum;this._sum.connect(this._gtz)},t.extend(t.OR,t.SignalBase),t.OR.prototype.dispose=function(){return t.prototype.dispose.call(this),this._gtz.dispose(),this._gtz=null,this._sum.disconnect(),this._sum=null,this},t.OR}(Tone_core_Tone);var Tone_signal_AND;Tone_signal_AND=function(t){"use strict";return t.AND=function(e){e=this.defaultArg(e,2),t.call(this,e,0),this._equals=this.output=new t.Equal(e);for(var i=0;e>i;i++)this.input[i]=this._equals},t.extend(t.AND,t.SignalBase),t.AND.prototype.dispose=function(){return t.prototype.dispose.call(this),this._equals.dispose(),this._equals=null,this},t.AND}(Tone_core_Tone);var Tone_signal_NOT;Tone_signal_NOT=function(t){"use strict";return t.NOT=t.EqualZero,t.NOT}(Tone_core_Tone);var Tone_signal_GreaterThan;Tone_signal_GreaterThan=function(t){"use strict";return t.GreaterThan=function(e){t.call(this,2,0),this._param=this.input[0]=new t.Subtract(e),this.input[1]=this._param.input[1],this._gtz=this.output=new t.GreaterThanZero,this._param.connect(this._gtz)},t.extend(t.GreaterThan,t.Signal),t.GreaterThan.prototype.dispose=function(){return t.prototype.dispose.call(this),this._param.dispose(),this._param=null,this._gtz.dispose(),this._gtz=null,this},t.GreaterThan}(Tone_core_Tone,Tone_signal_GreaterThanZero,Tone_signal_Subtract);var Tone_signal_LessThan;Tone_signal_LessThan=function(t){"use strict";return t.LessThan=function(e){t.call(this,2,0),this._neg=this.input[0]=new t.Negate,this._gt=this.output=new t.GreaterThan,this._rhNeg=new t.Negate,this._param=this.input[1]=new t.Signal(e),this._neg.connect(this._gt),this._param.connect(this._rhNeg),this._rhNeg.connect(this._gt,0,1)},t.extend(t.LessThan,t.Signal),t.LessThan.prototype.dispose=function(){return t.prototype.dispose.call(this),this._neg.dispose(),this._neg=null,this._gt.dispose(),this._gt=null,this._rhNeg.dispose(),this._rhNeg=null,this._param.dispose(),this._param=null,this},t.LessThan}(Tone_core_Tone,Tone_signal_GreaterThan,Tone_signal_Negate);var Tone_signal_Abs;Tone_signal_Abs=function(t){"use strict";return t.Abs=function(){t.call(this,1,0),this._ltz=new t.LessThan(0),this._switch=this.output=new t.Select(2),this._negate=new t.Negate,this.input.connect(this._switch,0,0),this.input.connect(this._negate),this._negate.connect(this._switch,0,1),this.input.chain(this._ltz,this._switch.gate)},t.extend(t.Abs,t.SignalBase),t.Abs.prototype.dispose=function(){return t.prototype.dispose.call(this),this._switch.dispose(),this._switch=null,this._ltz.dispose(),this._ltz=null,this._negate.dispose(),this._negate=null,this},t.Abs}(Tone_core_Tone,Tone_signal_Select,Tone_signal_Negate,Tone_signal_LessThan);var Tone_signal_Max;Tone_signal_Max=function(t){"use strict";return t.Max=function(e){t.call(this,2,0),this.input[0]=this.context.createGain(),this._param=this.input[1]=new t.Signal(e),this._ifThenElse=this.output=new t.IfThenElse,this._gt=new t.GreaterThan,this.input[0].chain(this._gt,this._ifThenElse["if"]),this.input[0].connect(this._ifThenElse.then),this._param.connect(this._ifThenElse["else"]),this._param.connect(this._gt,0,1)},t.extend(t.Max,t.Signal),t.Max.prototype.dispose=function(){return t.prototype.dispose.call(this),this._param.dispose(),this._ifThenElse.dispose(),this._gt.dispose(),this._param=null,this._ifThenElse=null,this._gt=null,this},t.Max}(Tone_core_Tone,Tone_signal_GreaterThan,Tone_signal_IfThenElse);var Tone_signal_Min;Tone_signal_Min=function(t){"use strict";return t.Min=function(e){t.call(this,2,0),this.input[0]=this.context.createGain(),this._ifThenElse=this.output=new t.IfThenElse,this._lt=new t.LessThan,this._param=this.input[1]=new t.Signal(e),this.input[0].chain(this._lt,this._ifThenElse["if"]),this.input[0].connect(this._ifThenElse.then),this._param.connect(this._ifThenElse["else"]),this._param.connect(this._lt,0,1)},t.extend(t.Min,t.Signal),t.Min.prototype.dispose=function(){return t.prototype.dispose.call(this),this._param.dispose(),this._ifThenElse.dispose(),this._lt.dispose(),this._param=null,this._ifThenElse=null,this._lt=null,this},t.Min}(Tone_core_Tone,Tone_signal_LessThan,Tone_signal_IfThenElse);var Tone_signal_Modulo;Tone_signal_Modulo=function(t){"use strict";return t.Modulo=function(e){t.call(this,1,1),this._shaper=new t.WaveShaper(Math.pow(2,16)),this._multiply=new t.Multiply,this._subtract=this.output=new t.Subtract,this._modSignal=new t.Signal(e),this.input.fan(this._shaper,this._subtract),this._modSignal.connect(this._multiply,0,0),this._shaper.connect(this._multiply,0,1),this._multiply.connect(this._subtract,0,1),this._setWaveShaper(e)},t.extend(t.Modulo,t.SignalBase),t.Modulo.prototype._setWaveShaper=function(t){this._shaper.setMap(function(e){var i=Math.floor((e+1e-4)/t);return i})},Object.defineProperty(t.Modulo.prototype,"value",{get:function(){return this._modSignal.value},set:function(t){this._modSignal.value=t,this._setWaveShaper(t)}}),t.Modulo.prototype.dispose=function(){return t.prototype.dispose.call(this),this._shaper.dispose(),this._shaper=null,this._multiply.dispose(),this._multiply=null,this._subtract.dispose(),this._subtract=null,this._modSignal.dispose(),this._modSignal=null,this},t.Modulo}(Tone_core_Tone,Tone_signal_WaveShaper,Tone_signal_Multiply);var Tone_signal_Pow;Tone_signal_Pow=function(t){"use strict";return t.Pow=function(e){this._exp=this.defaultArg(e,1),this._expScaler=this.input=this.output=new t.WaveShaper(this._expFunc(this._exp),8192)},t.extend(t.Pow,t.SignalBase),Object.defineProperty(t.Pow.prototype,"value",{get:function(){return this._exp},set:function(t){this._exp=t,this._expScaler.setMap(this._expFunc(this._exp))}}),t.Pow.prototype._expFunc=function(t){return function(e){return Math.pow(Math.abs(e),t)}},t.Pow.prototype.dispose=function(){return t.prototype.dispose.call(this),this._expScaler.dispose(),this._expScaler=null,this},t.Pow}(Tone_core_Tone);var Tone_signal_AudioToGain;Tone_signal_AudioToGain=function(t){"use strict";return t.AudioToGain=function(){this._norm=this.input=this.output=new t.WaveShaper(function(t){return(t+1)/2})},t.extend(t.AudioToGain,t.SignalBase),t.AudioToGain.prototype.dispose=function(){return t.prototype.dispose.call(this),this._norm.dispose(),this._norm=null,this},t.AudioToGain}(Tone_core_Tone,Tone_signal_WaveShaper);var Tone_signal_Expr;Tone_signal_Expr=function(t){"use strict";function e(t,e,i){var n=new t;return i._eval(e[0]).connect(n,0,0),i._eval(e[1]).connect(n,0,1),n}function i(t,e,i){var n=new t;return i._eval(e[0]).connect(n,0,0),n}function n(t){return t?parseFloat(t):void 0}function o(t){return t&&t.args?parseFloat(t.args):void 0}return t.Expr=function(){var t=this._replacements(Array.prototype.slice.call(arguments)),e=this._parseInputs(t);this._nodes=[],this.input=new Array(e);for(var i=0;e>i;i++)this.input[i]=this.context.createGain();var n,o=this._parseTree(t);try{n=this._eval(o)}catch(r){throw this._disposeNodes(),new Error("Could evaluate expression: "+t)}this.output=n},t.extend(t.Expr,t.SignalBase),t.Expr._Expressions={value:{signal:{regexp:/^\d+\.\d+|^\d+/,method:function(e){var i=new t.Signal(n(e));return i}},input:{regexp:/^\$\d/,method:function(t,e){return e.input[n(t.substr(1))]}}},glue:{"(":{regexp:/^\(/},")":{regexp:/^\)/},",":{regexp:/^,/}},func:{abs:{regexp:/^abs/,method:i.bind(this,t.Abs)},min:{regexp:/^min/,method:e.bind(this,t.Min)},max:{regexp:/^max/,method:e.bind(this,t.Max)},"if":{regexp:/^if/,method:function(e,i){var n=new t.IfThenElse;return i._eval(e[0]).connect(n["if"]),i._eval(e[1]).connect(n.then),i._eval(e[2]).connect(n["else"]),n}},gt0:{regexp:/^gt0/,method:i.bind(this,t.GreaterThanZero)},eq0:{regexp:/^eq0/,method:i.bind(this,t.EqualZero)},mod:{regexp:/^mod/,method:function(e,i){var n=o(e[1]),r=new t.Modulo(n);return i._eval(e[0]).connect(r),r}},pow:{regexp:/^pow/,method:function(e,i){var n=o(e[1]),r=new t.Pow(n);return i._eval(e[0]).connect(r),r}},a2g:{regexp:/^a2g/,method:function(e,i){var n=new t.AudioToGain;return i._eval(e[0]).connect(n),n}}},binary:{"+":{regexp:/^\+/,precedence:1,method:e.bind(this,t.Add)},"-":{regexp:/^\-/,precedence:1,method:function(n,o){return 1===n.length?i(t.Negate,n,o):e(t.Subtract,n,o)}},"*":{regexp:/^\*/,precedence:0,method:e.bind(this,t.Multiply)},">":{regexp:/^\>/,precedence:2,method:e.bind(this,t.GreaterThan)},"<":{regexp:/^</,precedence:2,method:e.bind(this,t.LessThan)},"==":{regexp:/^==/,precedence:3,method:e.bind(this,t.Equal)},"&&":{regexp:/^&&/,precedence:4,method:e.bind(this,t.AND)},"||":{regexp:/^\|\|/,precedence:5,method:e.bind(this,t.OR)}},unary:{"-":{regexp:/^\-/,method:i.bind(this,t.Negate)},"!":{regexp:/^\!/,method:i.bind(this,t.NOT)}}},t.Expr.prototype._parseInputs=function(t){var e=t.match(/\$\d/g),i=0;if(null!==e)for(var n=0;n<e.length;n++){var o=parseInt(e[n].substr(1))+1;i=Math.max(i,o)}return i},t.Expr.prototype._replacements=function(t){for(var e=t.shift(),i=0;i<t.length;i++)e=e.replace(/\%/i,t[i]);return e},t.Expr.prototype._tokenize=function(e){function i(e){for(var i in t.Expr._Expressions){var n=t.Expr._Expressions[i];for(var o in n){var r=n[o],s=r.regexp,a=e.match(s);if(null!==a)return{type:i,value:a[0],method:r.method}}}throw new SyntaxError("Unexpected token "+e)}for(var n=-1,o=[];e.length>0;){e=e.trim();var r=i(e);o.push(r),e=e.substr(r.value.length)}return{next:function(){return o[++n]},peek:function(){return o[n+1]}}},t.Expr.prototype._parseTree=function(e){function i(t,e){return!c(t)&&"glue"===t.type&&t.value===e}function n(e,i,n){var o=!1,r=t.Expr._Expressions[i];if(!c(e))for(var s in r){var a=r[s];if(a.regexp.test(e.value)){if(c(n))return!0;if(a.precedence===n)return!0}}return o}function o(t){c(t)&&(t=5);var e;e=0>t?r():o(t-1);for(var i=p.peek();n(i,"binary",t);)i=p.next(),e={operator:i.value,method:i.method,args:[e,o(t)]},i=p.peek();return e}function r(){var t,e;return t=p.peek(),n(t,"unary")?(t=p.next(),e=r(),{operator:t.value,method:t.method,args:[e]}):s()}function s(){var t,e;if(t=p.peek(),c(t))throw new SyntaxError("Unexpected termination of expression");if("func"===t.type)return t=p.next(),a(t);if("value"===t.type)return t=p.next(),{method:t.method,args:t.value};if(i(t,"(")){if(p.next(),e=o(),t=p.next(),!i(t,")"))throw new SyntaxError("Expected )");
return e}throw new SyntaxError("Parse error, cannot process token "+t.value)}function a(t){var e,n=[];if(e=p.next(),!i(e,"("))throw new SyntaxError('Expected ( in a function call "'+t.value+'"');if(e=p.peek(),i(e,")")||(n=u()),e=p.next(),!i(e,")"))throw new SyntaxError('Expected ) in a function call "'+t.value+'"');return{method:t.method,args:n,name:name}}function u(){for(var t,e,n=[];;){if(e=o(),c(e))break;if(n.push(e),t=p.peek(),!i(t,","))break;p.next()}return n}var p=this._tokenize(e),c=this.isUndef.bind(this);return o()},t.Expr.prototype._eval=function(t){if(!this.isUndef(t)){var e=t.method(t.args,this);return this._nodes.push(e),e}},t.Expr.prototype._disposeNodes=function(){for(var t=0;t<this._nodes.length;t++){var e=this._nodes[t];this.isFunction(e.dispose)?e.dispose():this.isFunction(e.disconnect)&&e.disconnect(),e=null,this._nodes[t]=null}this._nodes=null},t.Expr.prototype.dispose=function(){t.prototype.dispose.call(this),this._disposeNodes()},t.Expr}(Tone_core_Tone,Tone_signal_Add,Tone_signal_Subtract,Tone_signal_Multiply,Tone_signal_IfThenElse,Tone_signal_OR,Tone_signal_AND,Tone_signal_NOT,Tone_signal_GreaterThan,Tone_signal_LessThan,Tone_signal_Equal,Tone_signal_EqualZero,Tone_signal_GreaterThanZero,Tone_signal_Abs,Tone_signal_Negate,Tone_signal_Max,Tone_signal_Min,Tone_signal_Modulo,Tone_signal_Pow);var Tone_signal_EqualPowerGain;Tone_signal_EqualPowerGain=function(t){"use strict";return t.EqualPowerGain=function(){this._eqPower=this.input=this.output=new t.WaveShaper(function(t){return Math.abs(t)<.001?0:this.equalPowerScale(t)}.bind(this),4096)},t.extend(t.EqualPowerGain,t.SignalBase),t.EqualPowerGain.prototype.dispose=function(){return t.prototype.dispose.call(this),this._eqPower.dispose(),this._eqPower=null,this},t.EqualPowerGain}(Tone_core_Tone);var Tone_component_CrossFade;Tone_component_CrossFade=function(t){"use strict";return t.CrossFade=function(e){t.call(this,2,1),this.a=this.input[0]=this.context.createGain(),this.b=this.input[1]=this.context.createGain(),this.fade=new t.Signal(this.defaultArg(e,.5),t.Type.NormalRange),this._equalPowerA=new t.EqualPowerGain,this._equalPowerB=new t.EqualPowerGain,this._invert=new t.Expr("1 - $0"),this.a.connect(this.output),this.b.connect(this.output),this.fade.chain(this._equalPowerB,this.b.gain),this.fade.chain(this._invert,this._equalPowerA,this.a.gain),this._readOnly("fade")},t.extend(t.CrossFade),t.CrossFade.prototype.dispose=function(){return t.prototype.dispose.call(this),this._writable("fade"),this._equalPowerA.dispose(),this._equalPowerA=null,this._equalPowerB.dispose(),this._equalPowerB=null,this.fade.dispose(),this.fade=null,this._invert.dispose(),this._invert=null,this.a.disconnect(),this.a=null,this.b.disconnect(),this.b=null,this},t.CrossFade}(Tone_core_Tone,Tone_signal_Signal,Tone_signal_Expr);var effect;effect=function(){var t=master,e=Tone_component_CrossFade;return p5.Effect=function(){this.ac=t.audiocontext,this.input=this.ac.createGain(),this.output=this.ac.createGain(),this._drywet=new e(1),this.wet=this.ac.createGain(),this.input.connect(this._drywet.a),this.wet.connect(this._drywet.b),this._drywet.connect(this.output),this.connect(),t.soundArray.push(this)},p5.Effect.prototype.amp=function(e,i,n){var i=i||0,n=n||0,o=t.audiocontext.currentTime,r=this.output.gain.value;this.output.gain.cancelScheduledValues(o),this.output.gain.linearRampToValueAtTime(r,o+n+.001),this.output.gain.linearRampToValueAtTime(e,o+n+i+.001)},p5.Effect.prototype.chain=function(){if(arguments.length>0){this.output.connect(arguments[0]);for(var t=1;t<arguments.length;t+=1)arguments[t-1].connect(arguments[t])}return this},p5.Effect.prototype.drywet=function(t){return"undefined"!=typeof t&&(this._drywet.fade.value=t),this._drywet.fade.value},p5.Effect.prototype.connect=function(t){var e=t||p5.soundOut.input;this.output.connect(e.input?e.input:e)},p5.Effect.prototype.disconnect=function(){this.output.disconnect()},p5.Effect.prototype.dispose=function(){var e=t.soundArray.indexOf(this);t.soundArray.splice(e,1),this.input.disconnect(),this.input=void 0,this.output.disconnect(),this.output=void 0,this._drywet.disconnect(),delete this._drywet,this.wet.disconnect(),delete this.wet,this.ac=void 0},p5.Effect}(master,Tone_component_CrossFade);var filter;filter=function(){var t=effect;return p5.Filter=function(e){t.call(this),this.biquad=this.ac.createBiquadFilter(),this.input.connect(this.biquad),this.biquad.connect(this.wet),e&&this.setType(e)},p5.Filter.prototype=Object.create(t.prototype),p5.Filter.prototype.process=function(t,e,i,n){t.connect(this.input),this.set(e,i,n)},p5.Filter.prototype.set=function(t,e,i){t&&this.freq(t,i),e&&this.res(e,i)},p5.Filter.prototype.freq=function(t,e){var i=e||0;return 0>=t&&(t=1),"number"==typeof t?(this.biquad.frequency.value=t,this.biquad.frequency.cancelScheduledValues(this.ac.currentTime+.01+i),this.biquad.frequency.exponentialRampToValueAtTime(t,this.ac.currentTime+.02+i)):t&&t.connect(this.biquad.frequency),this.biquad.frequency.value},p5.Filter.prototype.res=function(t,e){var i=e||0;return"number"==typeof t?(this.biquad.Q.value=t,this.biquad.Q.cancelScheduledValues(this.ac.currentTime+.01+i),this.biquad.Q.linearRampToValueAtTime(t,this.ac.currentTime+.02+i)):t&&t.connect(this.biquad.Q),this.biquad.Q.value},p5.Filter.prototype.setType=function(t){this.biquad.type=t},p5.Filter.prototype.dispose=function(){t.prototype.dispose.apply(this),this.biquad.disconnect(),this.biquad=void 0},p5.LowPass=function(){p5.Filter.call(this,"lowpass")},p5.LowPass.prototype=Object.create(p5.Filter.prototype),p5.HighPass=function(){p5.Filter.call(this,"highpass")},p5.HighPass.prototype=Object.create(p5.Filter.prototype),p5.BandPass=function(){p5.Filter.call(this,"bandpass")},p5.BandPass.prototype=Object.create(p5.Filter.prototype),p5.Filter}(effect);var delay;delay=function(){var t=filter,e=effect;p5.Delay=function(){e.call(this),this._split=this.ac.createChannelSplitter(2),this._merge=this.ac.createChannelMerger(2),this._leftGain=this.ac.createGain(),this._rightGain=this.ac.createGain(),this.leftDelay=this.ac.createDelay(),this.rightDelay=this.ac.createDelay(),this._leftFilter=new t,this._rightFilter=new t,this._leftFilter.disconnect(),this._rightFilter.disconnect(),this._leftFilter.biquad.frequency.setValueAtTime(1200,this.ac.currentTime),this._rightFilter.biquad.frequency.setValueAtTime(1200,this.ac.currentTime),this._leftFilter.biquad.Q.setValueAtTime(.3,this.ac.currentTime),this._rightFilter.biquad.Q.setValueAtTime(.3,this.ac.currentTime),this.input.connect(this._split),this.leftDelay.connect(this._leftGain),this.rightDelay.connect(this._rightGain),this._leftGain.connect(this._leftFilter.input),this._rightGain.connect(this._rightFilter.input),this._merge.connect(this.wet),this._leftFilter.biquad.gain.setValueAtTime(1,this.ac.currentTime),this._rightFilter.biquad.gain.setValueAtTime(1,this.ac.currentTime),this.setType(0),this._maxDelay=this.leftDelay.delayTime.maxValue,this.feedback(.5)},p5.Delay.prototype=Object.create(e.prototype),p5.Delay.prototype.process=function(t,e,i,n){var o=i||0,r=e||0;if(o>=1)throw new Error("Feedback value will force a positive feedback loop.");if(r>=this._maxDelay)throw new Error("Delay Time exceeds maximum delay time of "+this._maxDelay+" second.");t.connect(this.input),this.leftDelay.delayTime.setValueAtTime(r,this.ac.currentTime),this.rightDelay.delayTime.setValueAtTime(r,this.ac.currentTime),this._leftGain.gain.value=o,this._rightGain.gain.value=o,n&&(this._leftFilter.freq(n),this._rightFilter.freq(n))},p5.Delay.prototype.delayTime=function(t){"number"!=typeof t?(t.connect(this.leftDelay.delayTime),t.connect(this.rightDelay.delayTime)):(this.leftDelay.delayTime.cancelScheduledValues(this.ac.currentTime),this.rightDelay.delayTime.cancelScheduledValues(this.ac.currentTime),this.leftDelay.delayTime.linearRampToValueAtTime(t,this.ac.currentTime),this.rightDelay.delayTime.linearRampToValueAtTime(t,this.ac.currentTime))},p5.Delay.prototype.feedback=function(t){if(t&&"number"!=typeof t)t.connect(this._leftGain.gain),t.connect(this._rightGain.gain);else{if(t>=1)throw new Error("Feedback value will force a positive feedback loop.");"number"==typeof t&&(this._leftGain.gain.value=t,this._rightGain.gain.value=t)}return this._leftGain.gain.value},p5.Delay.prototype.filter=function(t,e){this._leftFilter.set(t,e),this._rightFilter.set(t,e)},p5.Delay.prototype.setType=function(t){switch(1===t&&(t="pingPong"),this._split.disconnect(),this._leftFilter.disconnect(),this._rightFilter.disconnect(),this._split.connect(this.leftDelay,0),this._split.connect(this.rightDelay,1),t){case"pingPong":this._rightFilter.setType(this._leftFilter.biquad.type),this._leftFilter.output.connect(this._merge,0,0),this._rightFilter.output.connect(this._merge,0,1),this._leftFilter.output.connect(this.rightDelay),this._rightFilter.output.connect(this.leftDelay);break;default:this._leftFilter.output.connect(this._merge,0,0),this._rightFilter.output.connect(this._merge,0,1),this._leftFilter.output.connect(this.leftDelay),this._rightFilter.output.connect(this.rightDelay)}},p5.Delay.prototype.dispose=function(){e.prototype.dispose.apply(this),this._split.disconnect(),this._leftFilter.dispose(),this._rightFilter.dispose(),this._merge.disconnect(),this._leftGain.disconnect(),this._rightGain.disconnect(),this.leftDelay.disconnect(),this.rightDelay.disconnect(),this._split=void 0,this._leftFilter=void 0,this._rightFilter=void 0,this._merge=void 0,this._leftGain=void 0,this._rightGain=void 0,this.leftDelay=void 0,this.rightDelay=void 0}}(filter,effect);var reverb;reverb=function(){var t=errorHandler,e=effect;p5.Reverb=function(){e.call(this),this.convolverNode=this.ac.createConvolver(),this.input.gain.value=.5,this.input.connect(this.convolverNode),this.convolverNode.connect(this.wet),this._seconds=3,this._decay=2,this._reverse=!1,this._buildImpulse()},p5.Reverb.prototype=Object.create(e.prototype),p5.Reverb.prototype.process=function(t,e,i,n){t.connect(this.input);var o=!1;e&&(this._seconds=e,o=!0),i&&(this._decay=i),n&&(this._reverse=n),o&&this._buildImpulse()},p5.Reverb.prototype.set=function(t,e,i){var n=!1;t&&(this._seconds=t,n=!0),e&&(this._decay=e),i&&(this._reverse=i),n&&this._buildImpulse()},p5.Reverb.prototype._buildImpulse=function(){var t,e,i=this.ac.sampleRate,n=i*this._seconds,o=this._decay,r=this.ac.createBuffer(2,n,i),s=r.getChannelData(0),a=r.getChannelData(1);for(e=0;n>e;e++)t=this._reverse?n-e:e,s[e]=(2*Math.random()-1)*Math.pow(1-t/n,o),a[e]=(2*Math.random()-1)*Math.pow(1-t/n,o);this.convolverNode.buffer=r},p5.Reverb.prototype.dispose=function(){e.prototype.dispose.apply(this),this.convolverNode&&(this.convolverNode.buffer=null,this.convolverNode=null)},p5.Convolver=function(t,i,n){e.call(this),this.convolverNode=this.ac.createConvolver(),this.input.gain.value=.5,this.input.connect(this.convolverNode),this.convolverNode.connect(this.wet),t?(this.impulses=[],this._loadBuffer(t,i,n)):(this._seconds=3,this._decay=2,this._reverse=!1,this._buildImpulse())},p5.Convolver.prototype=Object.create(p5.Reverb.prototype),p5.prototype.registerPreloadMethod("createConvolver",p5.prototype),p5.prototype.createConvolver=function(t,e,i){window.location.origin.indexOf("file://")>-1&&"undefined"===window.cordova&&alert("This sketch may require a server to load external files. Please see http://bit.ly/1qcInwS");var n=new p5.Convolver(t,e,i);return n.impulses=[],n},p5.Convolver.prototype._loadBuffer=function(e,i,n){var e=p5.prototype._checkFileFormats(e),o=this,r=(new Error).stack,s=p5.prototype.getAudioContext(),a=new XMLHttpRequest;a.open("GET",e,!0),a.responseType="arraybuffer",a.onload=function(){if(200===a.status)s.decodeAudioData(a.response,function(t){var n={},r=e.split("/");n.name=r[r.length-1],n.audioBuffer=t,o.impulses.push(n),o.convolverNode.buffer=n.audioBuffer,i&&i(n)},function(){var e=new t("decodeAudioData",r,o.url),i="AudioContext error at decodeAudioData for "+o.url;n?(e.msg=i,n(e)):console.error(i+"\n The error stack trace includes: \n"+e.stack)});else{var u=new t("loadConvolver",r,o.url),p="Unable to load "+o.url+". The request status was: "+a.status+" ("+a.statusText+")";n?(u.message=p,n(u)):console.error(p+"\n The error stack trace includes: \n"+u.stack)}},a.onerror=function(){var e=new t("loadConvolver",r,o.url),i="There was no response from the server at "+o.url+". Check the url and internet connectivity.";n?(e.message=i,n(e)):console.error(i+"\n The error stack trace includes: \n"+e.stack)},a.send()},p5.Convolver.prototype.set=null,p5.Convolver.prototype.process=function(t){t.connect(this.input)},p5.Convolver.prototype.impulses=[],p5.Convolver.prototype.addImpulse=function(t,e,i){window.location.origin.indexOf("file://")>-1&&"undefined"===window.cordova&&alert("This sketch may require a server to load external files. Please see http://bit.ly/1qcInwS"),this._loadBuffer(t,e,i)},p5.Convolver.prototype.resetImpulse=function(t,e,i){window.location.origin.indexOf("file://")>-1&&"undefined"===window.cordova&&alert("This sketch may require a server to load external files. Please see http://bit.ly/1qcInwS"),this.impulses=[],this._loadBuffer(t,e,i)},p5.Convolver.prototype.toggleImpulse=function(t){if("number"==typeof t&&t<this.impulses.length&&(this.convolverNode.buffer=this.impulses[t].audioBuffer),"string"==typeof t)for(var e=0;e<this.impulses.length;e++)if(this.impulses[e].name===t){this.convolverNode.buffer=this.impulses[e].audioBuffer;break}},p5.Convolver.prototype.dispose=function(){e.prototype.dispose.apply(this);for(var t in this.impulses)this.impulses[t]&&(this.impulses[t]=null);this.convolverNode.disconnect(),this.concolverNode=null}}(errorHandler,effect,sndcore);var Tone_core_TimelineState;Tone_core_TimelineState=function(t){"use strict";return t.TimelineState=function(e){t.Timeline.call(this),this._initial=e},t.extend(t.TimelineState,t.Timeline),t.TimelineState.prototype.getStateAtTime=function(t){var e=this.getEvent(t);return null!==e?e.state:this._initial},t.TimelineState.prototype.setStateAtTime=function(t,e){this.addEvent({state:t,time:this.toSeconds(e)})},t.TimelineState}(Tone_core_Tone,Tone_core_Timeline);var Tone_core_Clock;Tone_core_Clock=function(t){"use strict";return t.Clock=function(){var e=this.optionsObject(arguments,["callback","frequency"],t.Clock.defaults);this.callback=e.callback,this._lookAhead="auto",this._computedLookAhead=1/60,this._threshold=.5,this._nextTick=-1,this._lastUpdate=0,this._loopID=-1,this.frequency=new t.TimelineSignal(e.frequency,t.Type.Frequency),this.ticks=0,this._state=new t.TimelineState(t.State.Stopped),this._boundLoop=this._loop.bind(this),this._readOnly("frequency"),this._loop()},t.extend(t.Clock),t.Clock.defaults={callback:t.noOp,frequency:1,lookAhead:"auto"},Object.defineProperty(t.Clock.prototype,"state",{get:function(){return this._state.getStateAtTime(this.now())}}),Object.defineProperty(t.Clock.prototype,"lookAhead",{get:function(){return this._lookAhead},set:function(t){"auto"===t?this._lookAhead="auto":this._lookAhead=this.toSeconds(t)}}),t.Clock.prototype.start=function(e,i){return e=this.toSeconds(e),this._state.getStateAtTime(e)!==t.State.Started&&this._state.addEvent({state:t.State.Started,time:e,offset:i}),this},t.Clock.prototype.stop=function(e){return e=this.toSeconds(e),this._state.getStateAtTime(e)!==t.State.Stopped&&this._state.setStateAtTime(t.State.Stopped,e),this},t.Clock.prototype.pause=function(e){return e=this.toSeconds(e),this._state.getStateAtTime(e)===t.State.Started&&this._state.setStateAtTime(t.State.Paused,e),this},t.Clock.prototype._loop=function(e){if(this._loopID=requestAnimationFrame(this._boundLoop),"auto"===this._lookAhead){if(!this.isUndef(e)){var i=(e-this._lastUpdate)/1e3;this._lastUpdate=e,i<this._threshold&&(this._computedLookAhead=(9*this._computedLookAhead+i)/10)}}else this._computedLookAhead=this._lookAhead;var n=this.now(),o=2*this._computedLookAhead,r=this._state.getEvent(n+o),s=t.State.Stopped;if(r&&(s=r.state,-1===this._nextTick&&s===t.State.Started&&(this._nextTick=r.time,this.isUndef(r.offset)||(this.ticks=r.offset))),s===t.State.Started)for(;n+o>this._nextTick;){n>this._nextTick+this._threshold&&(this._nextTick=n);var a=this._nextTick;this._nextTick+=1/this.frequency.getValueAtTime(this._nextTick),this.callback(a),this.ticks++}else s===t.State.Stopped&&(this._nextTick=-1,this.ticks=0)},t.Clock.prototype.getStateAtTime=function(t){return this._state.getStateAtTime(t)},t.Clock.prototype.dispose=function(){cancelAnimationFrame(this._loopID),t.TimelineState.prototype.dispose.call(this),this._writable("frequency"),this.frequency.dispose(),this.frequency=null,this._boundLoop=t.noOp,this._nextTick=1/0,this.callback=null,this._state.dispose(),this._state=null},t.Clock}(Tone_core_Tone,Tone_signal_TimelineSignal);var metro;metro=function(){var t=master,e=Tone_core_Clock;p5.Metro=function(){this.clock=new e({callback:this.ontick.bind(this)}),this.syncedParts=[],this.bpm=120,this._init(),this.prevTick=0,this.tatumTime=0,this.tickCallback=function(){}},p5.Metro.prototype.ontick=function(e){var i=e-this.prevTick,n=e-t.audiocontext.currentTime;if(!(i-this.tatumTime<=-.02)){this.prevTick=e;var o=this;this.syncedParts.forEach(function(t){t.isPlaying&&(t.incrementStep(n),t.phrases.forEach(function(t){var e=t.sequence,i=o.metroTicks%e.length;0!==e[i]&&(o.metroTicks<e.length||!t.looping)&&t.callback(n,e[i])}))}),this.metroTicks+=1,this.tickCallback(n)}},p5.Metro.prototype.setBPM=function(e,i){var n=60/(e*this.tatums),o=t.audiocontext.currentTime;this.tatumTime=n;var i=i||0;this.clock.frequency.setValueAtTime(this.clock.frequency.value,o),this.clock.frequency.linearRampToValueAtTime(e,o+i),this.bpm=e},p5.Metro.prototype.getBPM=function(){return this.clock.getRate()/this.tatums*60},p5.Metro.prototype._init=function(){this.metroTicks=0},p5.Metro.prototype.resetSync=function(t){this.syncedParts=[t]},p5.Metro.prototype.pushSync=function(t){this.syncedParts.push(t)},p5.Metro.prototype.start=function(e){var i=e||0,n=t.audiocontext.currentTime;this.clock.start(n+i),this.setBPM(this.bpm)},p5.Metro.prototype.stop=function(e){var i=e||0,n=t.audiocontext.currentTime;this.clock.stop(n+i)},p5.Metro.prototype.beatLength=function(t){this.tatums=1/t/4}}(master,Tone_core_Clock);var looper;looper=function(){function t(t){t.currentPart++,t.currentPart>=t.parts.length?(t.scoreStep=0,t.onended()):(t.scoreStep=0,t.parts[t.currentPart-1].stop(),t.parts[t.currentPart].start())}var e=master,i=120;p5.prototype.setBPM=function(t,n){i=t;for(var o in e.parts)e.parts[o]&&e.parts[o].setBPM(t,n)},p5.Phrase=function(t,e,i){this.phraseStep=0,this.name=t,this.callback=e,this.sequence=i},p5.Part=function(t,n){this.length=t||0,this.partStep=0,this.phrases=[],this.isPlaying=!1,this.noLoop(),this.tatums=n||.0625,this.metro=new p5.Metro,this.metro._init(),this.metro.beatLength(this.tatums),this.metro.setBPM(i),e.parts.push(this),this.callback=function(){}},p5.Part.prototype.setBPM=function(t,e){this.metro.setBPM(t,e)},p5.Part.prototype.getBPM=function(){return this.metro.getBPM()},p5.Part.prototype.start=function(t){if(!this.isPlaying){this.isPlaying=!0,this.metro.resetSync(this);var e=t||0;this.metro.start(e)}},p5.Part.prototype.loop=function(t){this.looping=!0,this.onended=function(){this.partStep=0};var e=t||0;this.start(e)},p5.Part.prototype.noLoop=function(){this.looping=!1,this.onended=function(){this.stop()}},p5.Part.prototype.stop=function(t){this.partStep=0,this.pause(t)},p5.Part.prototype.pause=function(t){this.isPlaying=!1;var e=t||0;this.metro.stop(e)},p5.Part.prototype.addPhrase=function(t,e,i){var n;if(3===arguments.length)n=new p5.Phrase(t,e,i);else{if(!(arguments[0]instanceof p5.Phrase))throw"invalid input. addPhrase accepts name, callback, array or a p5.Phrase";n=arguments[0]}this.phrases.push(n),n.sequence.length>this.length&&(this.length=n.sequence.length)},p5.Part.prototype.removePhrase=function(t){for(var e in this.phrases)this.phrases[e].name===t&&this.phrases.splice(e,1)},p5.Part.prototype.getPhrase=function(t){for(var e in this.phrases)if(this.phrases[e].name===t)return this.phrases[e]},p5.Part.prototype.replaceSequence=function(t,e){for(var i in this.phrases)this.phrases[i].name===t&&(this.phrases[i].sequence=e)},p5.Part.prototype.incrementStep=function(t){this.partStep<this.length-1?(this.callback(t),this.partStep+=1):this.looping||this.partStep!==this.length-1||(console.log("done"),this.onended())},p5.Part.prototype.onStep=function(t){this.callback=t},p5.Score=function(){this.parts=[],this.currentPart=0;var e=this;for(var i in arguments)arguments[i]&&this.parts[i]&&(this.parts[i]=arguments[i],this.parts[i].nextPart=this.parts[i+1],this.parts[i].onended=function(){e.resetPart(i),t(e)});this.looping=!1},p5.Score.prototype.onended=function(){this.looping?this.parts[0].start():this.parts[this.parts.length-1].onended=function(){this.stop(),this.resetParts()},this.currentPart=0},p5.Score.prototype.start=function(){this.parts[this.currentPart].start(),this.scoreStep=0},p5.Score.prototype.stop=function(){this.parts[this.currentPart].stop(),this.currentPart=0,this.scoreStep=0},p5.Score.prototype.pause=function(){this.parts[this.currentPart].stop()},p5.Score.prototype.loop=function(){this.looping=!0,this.start()},p5.Score.prototype.noLoop=function(){this.looping=!1},p5.Score.prototype.resetParts=function(){var t=this;this.parts.forEach(function(e){t.resetParts[e]})},p5.Score.prototype.resetPart=function(t){this.parts[t].stop(),this.parts[t].partStep=0;for(var e in this.parts[t].phrases)this.parts[t]&&(this.parts[t].phrases[e].phraseStep=0)},p5.Score.prototype.setBPM=function(t,e){for(var i in this.parts)this.parts[i]&&this.parts[i].setBPM(t,e)}}(master);var compressor;compressor=function(){"use strict";var t=effect;return p5.Compressor=function(){t.call(this),this.compressor=this.ac.createDynamicsCompressor(),this.input.connect(this.compressor),this.compressor.connect(this.wet)},p5.Compressor.prototype=Object.create(t.prototype),p5.Compressor.prototype.process=function(t,e,i,n,o,r){t.connect(this.input),this.set(e,i,n,o,r)},p5.Compressor.prototype.set=function(t,e,i,n,o){"undefined"!=typeof t&&this.attack(t),"undefined"!=typeof e&&this.knee(e),"undefined"!=typeof i&&this.ratio(i),"undefined"!=typeof n&&this.threshold(n),"undefined"!=typeof o&&this.release(o)},p5.Compressor.prototype.attack=function(t,e){var i=e||0;return"number"==typeof t?(this.compressor.attack.value=t,this.compressor.attack.cancelScheduledValues(this.ac.currentTime+.01+i),this.compressor.attack.linearRampToValueAtTime(t,this.ac.currentTime+.02+i)):"undefined"!=typeof t&&t.connect(this.compressor.attack),this.compressor.attack.value},p5.Compressor.prototype.knee=function(t,e){var i=e||0;return"number"==typeof t?(this.compressor.knee.value=t,this.compressor.knee.cancelScheduledValues(this.ac.currentTime+.01+i),this.compressor.knee.linearRampToValueAtTime(t,this.ac.currentTime+.02+i)):"undefined"!=typeof t&&t.connect(this.compressor.knee),this.compressor.knee.value},p5.Compressor.prototype.ratio=function(t,e){var i=e||0;return"number"==typeof t?(this.compressor.ratio.value=t,this.compressor.ratio.cancelScheduledValues(this.ac.currentTime+.01+i),this.compressor.ratio.linearRampToValueAtTime(t,this.ac.currentTime+.02+i)):"undefined"!=typeof t&&t.connect(this.compressor.ratio),this.compressor.ratio.value},p5.Compressor.prototype.threshold=function(t,e){var i=e||0;return"number"==typeof t?(this.compressor.threshold.value=t,this.compressor.threshold.cancelScheduledValues(this.ac.currentTime+.01+i),this.compressor.threshold.linearRampToValueAtTime(t,this.ac.currentTime+.02+i)):"undefined"!=typeof t&&t.connect(this.compressor.threshold),this.compressor.threshold.value},p5.Compressor.prototype.release=function(t,e){var i=e||0;return"number"==typeof t?(this.compressor.release.value=t,this.compressor.release.cancelScheduledValues(this.ac.currentTime+.01+i),this.compressor.release.linearRampToValueAtTime(t,this.ac.currentTime+.02+i)):"undefined"!=typeof number&&t.connect(this.compressor.release),this.compressor.release.value},p5.Compressor.prototype.reduction=function(){return this.compressor.reduction.value},p5.Compressor.prototype.dispose=function(){t.prototype.dispose.apply(this),this.compressor.disconnect(),this.compressor=void 0},p5.Compressor}(master,effect,errorHandler);var soundRecorder;soundRecorder=function(){function t(t,e){for(var i=t.length+e.length,n=new Float32Array(i),o=0,r=0;i>r;)n[r++]=t[o],n[r++]=e[o],o++;return n}function e(t,e,i){for(var n=i.length,o=0;n>o;o++)t.setUint8(e+o,i.charCodeAt(o))}var i=master,n=i.audiocontext;p5.SoundRecorder=function(){this.input=n.createGain(),this.output=n.createGain(),this.recording=!1,this.bufferSize=1024,this._channels=2,this._clear(),this._jsNode=n.createScriptProcessor(this.bufferSize,this._channels,2),this._jsNode.onaudioprocess=this._audioprocess.bind(this),this._callback=function(){},this._jsNode.connect(p5.soundOut._silentNode),this.setInput(),i.soundArray.push(this)},p5.SoundRecorder.prototype.setInput=function(t){this.input.disconnect(),this.input=null,this.input=n.createGain(),this.input.connect(this._jsNode),this.input.connect(this.output),t?t.connect(this.input):p5.soundOut.output.connect(this.input)},p5.SoundRecorder.prototype.record=function(t,e,i){this.recording=!0,e&&(this.sampleLimit=Math.round(e*n.sampleRate)),t&&i?this._callback=function(){this.buffer=this._getBuffer(),t.setBuffer(this.buffer),i()}:t&&(this._callback=function(){this.buffer=this._getBuffer(),t.setBuffer(this.buffer)})},p5.SoundRecorder.prototype.stop=function(){this.recording=!1,this._callback(),this._clear()},p5.SoundRecorder.prototype._clear=function(){this._leftBuffers=[],this._rightBuffers=[],this.recordedSamples=0,this.sampleLimit=null},p5.SoundRecorder.prototype._audioprocess=function(t){if(this.recording!==!1&&this.recording===!0)if(this.sampleLimit&&this.recordedSamples>=this.sampleLimit)this.stop();else{var e=t.inputBuffer.getChannelData(0),i=t.inputBuffer.getChannelData(1);this._leftBuffers.push(new Float32Array(e)),this._rightBuffers.push(new Float32Array(i)),this.recordedSamples+=this.bufferSize}},p5.SoundRecorder.prototype._getBuffer=function(){var t=[];return t.push(this._mergeBuffers(this._leftBuffers)),t.push(this._mergeBuffers(this._rightBuffers)),t},p5.SoundRecorder.prototype._mergeBuffers=function(t){for(var e=new Float32Array(this.recordedSamples),i=0,n=t.length,o=0;n>o;o++){var r=t[o];e.set(r,i),i+=r.length}return e},p5.SoundRecorder.prototype.dispose=function(){this._clear();var t=i.soundArray.indexOf(this);i.soundArray.splice(t,1),this._callback=function(){},this.input&&this.input.disconnect(),this.input=null,this._jsNode=null},p5.prototype.saveSound=function(i,n){var o,r;o=i.buffer.getChannelData(0),r=i.buffer.numberOfChannels>1?i.buffer.getChannelData(1):o;var s=t(o,r),a=new window.ArrayBuffer(44+2*s.length),u=new window.DataView(a);e(u,0,"RIFF"),u.setUint32(4,36+2*s.length,!0),e(u,8,"WAVE"),e(u,12,"fmt "),u.setUint32(16,16,!0),u.setUint16(20,1,!0),u.setUint16(22,2,!0),u.setUint32(24,44100,!0),u.setUint32(28,176400,!0),u.setUint16(32,4,!0),u.setUint16(34,16,!0),e(u,36,"data"),u.setUint32(40,2*s.length,!0);for(var p=s.length,c=44,h=1,l=0;p>l;l++)u.setInt16(c,s[l]*(32767*h),!0),c+=2;p5.prototype.writeFile([u],n,"wav")}}(sndcore,master);var peakdetect;peakdetect=function(){p5.PeakDetect=function(t,e,i,n){this.framesPerPeak=n||20,this.framesSinceLastPeak=0,this.decayRate=.95,this.threshold=i||.35,this.cutoff=0,this.cutoffMult=1.5,this.energy=0,this.penergy=0,this.currentValue=0,this.isDetected=!1,this.f1=t||40,this.f2=e||2e4,this._onPeak=function(){}},p5.PeakDetect.prototype.update=function(t){var e=this.energy=t.getEnergy(this.f1,this.f2)/255;e>this.cutoff&&e>this.threshold&&e-this.penergy>0?(this._onPeak(),this.isDetected=!0,this.cutoff=e*this.cutoffMult,this.framesSinceLastPeak=0):(this.isDetected=!1,this.framesSinceLastPeak<=this.framesPerPeak?this.framesSinceLastPeak++:(this.cutoff*=this.decayRate,this.cutoff=Math.max(this.cutoff,this.threshold))),this.currentValue=e,this.penergy=e},p5.PeakDetect.prototype.onPeak=function(t,e){var i=this;i._onPeak=function(){t(i.energy,e)}}}();var gain;gain=function(){var t=master;p5.Gain=function(){this.ac=t.audiocontext,this.input=this.ac.createGain(),this.output=this.ac.createGain(),this.input.gain.value=.5,this.input.connect(this.output),t.soundArray.push(this)},p5.Gain.prototype.setInput=function(t){t.connect(this.input)},p5.Gain.prototype.connect=function(t){var e=t||p5.soundOut.input;this.output.connect(e.input?e.input:e)},p5.Gain.prototype.disconnect=function(){this.output.disconnect()},p5.Gain.prototype.amp=function(e,i,n){var i=i||0,n=n||0,o=t.audiocontext.currentTime,r=this.output.gain.value;this.output.gain.cancelScheduledValues(o),this.output.gain.linearRampToValueAtTime(r,o+n),this.output.gain.linearRampToValueAtTime(e,o+n+i)},p5.Gain.prototype.dispose=function(){var e=t.soundArray.indexOf(this);t.soundArray.splice(e,1),this.output.disconnect(),this.input.disconnect(),this.output=void 0,this.input=void 0}}(master,sndcore);var distortion;distortion=function(){function t(t){for(var e,i="number"==typeof t?t:50,n=44100,o=new Float32Array(n),r=Math.PI/180,s=0;n>s;++s)e=2*s/n-1,o[s]=(3+i)*e*20*r/(Math.PI+i*Math.abs(e));return o}var e=effect;p5.Distortion=function(i,n){if(e.call(this),"undefined"==typeof i&&(i=.25),"number"!=typeof i)throw new Error("amount must be a number");if("undefined"==typeof n&&(n="2x"),"string"!=typeof n)throw new Error("oversample must be a String");var o=p5.prototype.map(i,0,1,0,2e3);this.waveShaperNode=this.ac.createWaveShaper(),this.amount=o,this.waveShaperNode.curve=t(o),this.waveShaperNode.oversample=n,this.input.connect(this.waveShaperNode),this.waveShaperNode.connect(this.wet)},p5.Distortion.prototype=Object.create(e.prototype),p5.Distortion.prototype.process=function(t,e,i){t.connect(this.input),this.set(e,i)},p5.Distortion.prototype.set=function(e,i){if(e){var n=p5.prototype.map(e,0,1,0,2e3);this.amount=n,this.waveShaperNode.curve=t(n)}i&&(this.waveShaperNode.oversample=i)},p5.Distortion.prototype.getAmount=function(){return this.amount},p5.Distortion.prototype.getOversample=function(){return this.waveShaperNode.oversample},p5.Distortion.prototype.dispose=function(){e.prototype.dispose.apply(this),this.waveShaperNode.disconnect(),this.waveShaperNode=null}}(effect);var src_app;src_app=function(){var t=sndcore;return t}(sndcore,master,helpers,errorHandler,panner,soundfile,amplitude,fft,signal,oscillator,env,pulse,noise,audioin,filter,delay,reverb,metro,looper,compressor,soundRecorder,peakdetect,gain,distortion)});
