
/**
 * @fileoverview Math blocks for Blockly.
 *
 * This file is scraped to extract a .json file of block definitions. The array
 * passed to defineBlocksWithJsonArray(..) must be strict JSON: double quotes
 * only, no outside references, no functions, no trailing commas, etc. The one
 * exception is end-of-line comments, which the scraper will remove.
 * @author q.neutron@gmail.com (Quynh Neutron)
 */
'use strict';

//goog.provide('Blockly.Blocks.tortue');  // Deprecated
//goog.provide('Blockly.Constants.tortue');

goog.require('Blockly.Blocks');
goog.require('Blockly');



Blockly.defineBlocksWithJsonArray([  // BEGIN JSON EXTRACT
//LISTES (modification de Blockly
// Obtenir valeur de liste
{
  "type": "listes_obtenir",
  "message0": "élément numéro %2 de la liste %1",
  "args0": [
    {
      "type": "input_value",
      "name": "liste",
      "check": "Array",
    },
    {
      "type": "input_value",
      "name": "indice",
      "check": "Number",
    }
  ],
  "inputsInline": true,
  "output": ["Number", "String", "Array"],
  "colour": 260,
  "tooltip": "Retourne un élément d'une liste",
  "helpUrl": "p5BLOCS/DOCU/adaptations.html#obtenirListe"
},
// Changer valeur de liste
{
  "type": "listes_changer",
  "message0": "Donner à l'élément %2 de la liste %1 la valeur %3",
  "args0": [
    {
      "type": "input_value",
      "name": "liste",
      "check": "Array",
    },
    {
      "type": "input_value",
      "name": "indice",
      "check": "Number",
    },
    {
      "type": "input_value",
      "name": "valeur",
      "check": ["Number", "String", "Array"],
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 260,
  "tooltip": "Change un élément d'une liste",
  "helpUrl": "p5BLOCS/DOCU/adaptations.html#definirListe"
},
// Duplicata d'une liste
{
  "type": "listes_duplicata",
  "message0": "copie de la liste %1",
  "args0": [
    {
      "type": "input_value",
      "name": "liste",
      "check": "Array",
    }
  ],
  "inputsInline": true,
  "output": "Array",
  "colour": 260,
  "tooltip": "Retourne une copie de la liste. Les changements apportés à la copie n'affectent pas la liste originale.",
  "helpUrl": "p5BLOCS/DOCU/adaptations.html#duplicata"
},
//----------------------
//Programmation
//----------------------
//Commentaire
{
  "type": "programmation_commentaire",
  "message0": "Commentaire %1",
  "args0": [
    {
      "type": "input_value",
      "name": "TEXTE",
      "check": "String"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 210,
  "tooltip": "Un commentaire est un texte utile au programmeur. Il n'est jamais exécuté.",
  "helpUrl": "p5BLOCS/DOCU/programmation.html#commentaire"
},
// Faire
{
  "type": "programmation_faire",
  "message0": "Faire %1",
  "args0": [
    {
      "type": "input_value",
      "name": "fonction",
      "check": ["Number", "String", "Array"]
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 210,
  "tooltip": "Permet d'oublier la valeur retournée par une fonction.",
  "helpUrl": "p5BLOCS/DOCU/programmation.html#faire"
},
// Faire après délai
{
  "type": "programmation_faireDelai",
  "message0": "Faire %1 dans %2 secondes",
  "args0": [
    {
      "type": "input_value",
      "name": "fonction",
      "check": ["Number", "String", "Array"],
    },
    {
      "type": "input_value",
      "name": "delai",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 210,
  "tooltip": "Très peu utilisé. N'utiliser que si vous savez ce que vous faites.",
  "helpUrl": "p5BLOCS/DOCU/programmation.html#faireDelai"
},
//----------------------
//Variable locale
{
  "type": "programmation_varLocale",
  "message0": "variable locale %1",
  "args0": [
    {
      "type": "input_value",
      "name": "VARIABLE",
      "check": "String"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 210,
  "tooltip": "Déclare une variable locale à une fonction.",
  "helpUrl": "p5BLOCS/DOCU/programmation.html#varLocale"
},
// Block pour boucle 'for' (croissant).
  {
    "type": "programmation_pourCroiss",
    "message0": "boucle %1 de min %2 à max %3 avec pas %4",
    "args0": [
      {
        "type": "field_variable",
        "name": "VAR",
        "variable": null
      },
      {
        "type": "input_value",
        "name": "FROM",
        "check": "Number",
        "align": "RIGHT"
      },
      {
        "type": "input_value",
        "name": "TO",
        "check": "Number",
        "align": "RIGHT"
      },
      {
        "type": "input_value",
        "name": "BY",
        "check": "Number",
        "align": "RIGHT"
      }
    ],
    "message1": "%{BKY_CONTROLS_REPEAT_INPUT_DO} %1",
    "args1": [{
      "type": "input_statement",
      "name": "DO"
    }],
    "inputsInline": true,
    "previousStatement": null,
    "nextStatement": null,
    "colour": 120,
    "tooltip": "Boucle avec compteur croissant.",
    "helpUrl": "p5BLOCS/DOCU/adaptations.html#boucleAsc",
    "extensions": [
      "contextMenu_newGetVariableBlock",
      "controls_for_tooltip"
    ]
  },
// Block pour boucle 'for' (décroissant).
  {
    "type": "programmation_pourDecroiss",
    "message0": "boucle %1 de max %2 à min %3 avec pas %4",
    "args0": [
      {
        "type": "field_variable",
        "name": "VAR",
        "variable": null
      },
      {
        "type": "input_value",
        "name": "FROM",
        "check": "Number",
        "align": "RIGHT"
      },
      {
        "type": "input_value",
        "name": "TO",
        "check": "Number",
        "align": "RIGHT"
      },
      {
        "type": "input_value",
        "name": "BY",
        "check": "Number",
        "align": "RIGHT"
      }
    ],
    "message1": "%{BKY_CONTROLS_REPEAT_INPUT_DO} %1",
    "args1": [{
      "type": "input_statement",
      "name": "DO"
    }],
    "inputsInline": true,
    "previousStatement": null,
    "nextStatement": null,
    "colour": 120,
    "tooltip": "Boucle avec compteur décroissant.",
    "helpUrl": "p5BLOCS/DOCU/adaptations.html#boucleDesc",
    "extensions": [
      "contextMenu_newGetVariableBlock",
      "controls_for_tooltip"
    ]
  },   
//quitter la procédure
{
  "type": "programmation_quitter",
  "message0": "quitter %1",
  "args0": [
    {
      "type": "input_value",
      "name": "VALEUR"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 210,
  "tooltip": "Termine l'exécution de la fonction courante, en retournant éventuellement une valeur.",
  "helpUrl": "p5BLOCS/DOCU/programmation.html#quitter"
}, 
//tester si chaine est un nombre
{
  "type": "programmation_estNombre",
  "message0": "est un nombre ? %1",
  "args0": [
    {
      "type": "input_value",
      "name": "CHAINE",
      "check": "String"
    }
  ],
  "output": "Boolean",
  "colour": 210,
  "tooltip": "Retourne 'vrai' si c'est un nombre, et 'faux' sinon.",
  "helpUrl": "p5BLOCS/DOCU/programmation.html#nombreP"
},
//conversion en radians
{
  "type": "programmation_radians",
  "message0": "radians( %1 )",
  "args0": [
    {
      "type": "input_value",
      "name": "ANGLE",
      "check": "Number"
    }
  ],
  "output": "Number",
  "colour": 210,
  "tooltip": "Conversion de degrés à radians.",
  "helpUrl": "p5BLOCS/DOCU/programmation.html#radians"
},
//conversion en degrés
{
  "type": "programmation_degres",
  "message0": "degres( %1 )",
  "args0": [
    {
      "type": "input_value",
      "name": "ANGLE",
      "check": "Number"
    }
  ],
  "output": "Number",
  "colour": 210,
  "tooltip": "Conversion de radians à degrés.",
  "helpUrl": "p5BLOCS/DOCU/programmation.html#degres"
},
//Clic sur bouton de la souris
{
  "type": "programmation_clicSouris",
  "message0": "le bouton de la souris est enfoncé",
  "output": "Boolean",
  "colour": 210,
  "tooltip": "Retourne 'vrai' si c'est le bouton de la souris est enfoncé, et 'faux' sinon.",
  "helpUrl": "p5BLOCS/DOCU/programmation.html#boutonPresse"
},
//Retourne l'ancienne position en X de la souris
{
  "type": "programmation_EXsourisX",
  "message0": "ancienne position en X de la souris",
  "output": "Number",
  "colour": 210,
  "tooltip": "",
  "helpUrl": "p5BLOCS/DOCU/"
},
//Retourne l'ancienne position en Y de la souris
{
  "type": "programmation_EXsourisY",
  "message0": "ancienne position en Y de la souris",
  "output": "Number",
  "colour": 210,
  "tooltip": "",
  "helpUrl": "p5BLOCS/DOCU/"
},
//Retourne la position en X de la souris
{
  "type": "programmation_sourisX",
  "message0": "position en X de la souris",
  "output": "Number",
  "colour": 210,
  "tooltip": "Retourne la position en X de la souris, 0 correspondant à la gauche du canvas.",
  "helpUrl": "p5BLOCS/DOCU/programmation.html#sourisX"
},
//Retourne la position en Y de la souris
{
  "type": "programmation_sourisY",
  "message0": "position en Y de la souris",
  "output": "Number",
  "colour": 210,
  "tooltip": "Retourne la position en X de la souris, 0 correspondant au haut du canvas.",
  "helpUrl": "p5BLOCS/DOCU/programmation.html#sourisY"
},
//remplacement
{
  "type": "programmation_remplacement",
  "message0": "dans le texte %1 remplacer %2 par %3",
  "args0": [
    {
      "type": "input_value",
      "name": "TEXTE",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "DEPART",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "ARRIVEE",
      "check": "String"
    }
  ],
  "inputsInline": true,
  "output": "String",
  "colour": 210,
  "tooltip": "Dans un texte, remplacer toutes les occurence d'un bloc de texte par un autre.",
  "helpUrl": "p5BLOCS/DOCU/programmation.html#remplacer"
},
//substitution
{
  "type": "programmation_substitution",
  "message0": "substituer dans %1 les valeurs %2",
  "args0": [
    {
      "type": "input_value",
      "name": "MODELE",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "LISTEVALEURS",
      "check": "Array"
    }
  ],
  "inputsInline": true,
  "output": "String",
  "colour": 210,
  "tooltip": "Dans un texte, substituer les expressions @1, @2, ... par des valeurs prises dans une liste.",
  "helpUrl": "p5BLOCS/DOCU/programmation.html#substituer"
},
//code mathématique
{
  "type": "programmation_codeMath",
  "message0": "code math %1",
  "args0": [
    {
      "type": "input_value",
      "name": "CHAINE",
      "check": "String"
    }
  ],
  "output": "String",
  "colour": 210,
  "tooltip": "Conversion d'une chaîne AsciiMath en une forme reconnaissable par MathJax. MathJax n'en fait pas encore le rendu.",
  "helpUrl": "p5BLOCS/DOCU/programmation.html#codeMath"
},
//Crée les formules mathématiques
{
  "type": "programmation_refreshMathJax",
  "message0": "Finaliser les expressions mathématiques",
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 210,
  "tooltip": "Demande à MathJax de faire le rendu de toutes les expressions mathématiques de la page.",
  "helpUrl": "p5BLOCS/DOCU/programmation.html#finaliserMaths"
},
//p5.js
//----------------------
// Créer une entrée %1 de contenu initial %2
{
  "type": "catégorie_margeGauche",
  "message0": "Marge gauche %1 pixels",
  "args0": [
    {
      "type": "input_value",
      "name": "NB_PIXELS",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 120,
  "tooltip": "Spécifie une marge pour toute la page web.",
  "helpUrl": "p5BLOCS/DOCU/p5js.html#margeG"
},
//Créer Canvas
{
  "type": "p5_js_creerCanvas",
  "message0": "Canvas : dim horizontale %1 dimension verticale %2",
  "args0": [
    {
      "type": "input_value",
      "name": "HORIZ",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "VERT",
      "check": "Number"
    }
  ],
  "inputsInline": false,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 120,
  "tooltip": "Crée le canvas, et place la référence à cet objet dans la variable 'canvas'.",
  "helpUrl": "p5BLOCS/DOCU/p5js.html#dimCanvas"
},
//Retourne la largeur du canvas (width)
{
  "type": "p5_js_largeurCanvas",
  "message0": "largeur du canvas",
  "output": "Number",
  "colour": 120,
  "tooltip": "Retourne la largeur du canvas.",
  "helpUrl": "p5BLOCS/DOCU/p5js.html#largeurCanvas"
},
//Retourne la hauteur du canvas (height)
{
  "type": "p5_js_hauteurCanvas",
  "message0": "hauteur du canvas",
  "output": "Number",
  "colour": 120,
  "tooltip": "Retourne la hauteur du canvas.",
  "helpUrl": "p5BLOCS/DOCU/p5js.html#hauteurCanvas"
},
//enregistre l'image du canvas
{
  "type": "p5_js_enregistrerCanvas",
  "message0": "Enregistrer l'image du canvas",
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 120,
  "tooltip": "Enregistre le canvas en format 'png'.",
  "helpUrl": "p5BLOCS/DOCU/p5js.html#enregistrerCanvas"
},
//noCanvas
{
  "type": "p5_js_noCanvas",
  "message0": "Pas de canvas",
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 120,
  "tooltip": "",
  "helpUrl": "p5BLOCS/DOCU/p5js.html#sansCanvas"
},
//noLoop
{
  "type": "p5_js_noLoop",
  "message0": "'actions en boucle' appelée une seule fois",
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 120,
  "tooltip": "Empêche la fonction 'actions en boucle' de s'exécuter plus d'une fois.",
  "helpUrl": "p5BLOCS/DOCU/p5js.html#drawSansBoucle"
},
// vitesse de boucle "draw" (en pourcentage)
{
  "type": "p5_js_vitesseDraw",
  "message0": "'actions en boucle' appelée  %1 fois par secondeç",
  "args0": [
    {
      "type": "input_value",
      "name": "VITESSE",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 120,
  "tooltip": "Spécifie à quelle fréquence la fonction 'actions en boucle' sera appelée (maximum : 60 fois par secondes).",
  "helpUrl": "p5BLOCS/DOCU/p5js.html#vitesseDraw"
},
//----------------------
//Expression   --> modifié et à tester : output est null au lieu de "Number"
{
  "type": "p5_js_expression",
  "message0": "expression p5 %1",
  "args0": [
    {
      "type": "input_value",
      "name": "TEXTE",
      "check": "String"
    }
  ],
  "output": null,
  "colour": 120,
  "tooltip": "Évalue une expression JavaScript. À n'utiliser que si vous savez ce que vous faites.",
  "helpUrl": "p5BLOCS/DOCU/p5js.html#expressionP5"
},
//----------------------
//Commande
{
  "type": "p5_js_commande",
  "message0": "commande p5 %1",
  "args0": [
    {
      "type": "input_value",
      "name": "TEXTE",
      "check": "String"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 120,
  "tooltip": "Exécute une commande JavaScript. À n'utiliser que si vous savez ce que vous faites.",
  "helpUrl": "p5BLOCS/DOCU/p5js.html#commandeP5"
},
//***********************************************************
//Couleurs
//----------------------
// couleur de fond --> background(r,g,b)
{
  "type": "couleurs_fond",
  "message0": "couleur du fond : rouge %1 vert %2 bleu %3",
  "args0": [
    {
      "type": "input_value",
      "name": "R",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "G",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "B",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 330,
  "tooltip": "",
  "helpUrl": "p5BLOCS/DOCU/apparence.html#fond"
},
// couleur du trait --> stroke(r,g,b)
{
  "type": "couleurs_trait",
  "message0": "couleur du trait : rouge %1 vert %2 bleu %3",
  "args0": [
    {
      "type": "input_value",
      "name": "R",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "G",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "B",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 330,
  "tooltip": "",
  "helpUrl": "p5BLOCS/DOCU/apparence.html#trait"
},
// couleur de remplissage --> fill(r,g,b)
{
  "type": "couleurs_remplissage",
  "message0": "couleur de remplissage : rouge %1 vert %2 bleu %3 opacité %4",
  "args0": [
    {
      "type": "input_value",
      "name": "R",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "G",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "B",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "A",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 330,
  "tooltip": "",
  "helpUrl": "p5BLOCS/DOCU/apparence.html#remplissage"
},
//retourne couleur associée
{
  "type": "couleurs_couleur",
  "message0": "couleur rouge %1 vert %2 bleu %3 opacité %4",
  "args0": [
    {
      "type": "input_value",
      "name": "R",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "V",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "B",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "A",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "output": "String",
  "colour": 330,
  "tooltip": "Retourne une couleur définie par son format RVB.",
  "helpUrl": "p5BLOCS/DOCU/apparence.html#couleur"
},
//couleur du fond
{
  "type": "couleurs_fond_C",
  "message0": "fond %1",
  "args0": [
    {
      "type": "input_value",
      "name": "C",
      "check": "String"
    }
  ],
  "inputsInline": false,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 330,
  "tooltip": "Efface le canvas en le remplissant avec la couleur spécifiée.",
  "helpUrl": "p5BLOCS/DOCU/apparence.html#fond"
},
//couleur du trait
{
  "type": "couleurs_trait_C",
  "message0": "trait %1",
  "args0": [
    {
      "type": "input_value",
      "name": "C",
      "check": "String"
    }
  ],
  "inputsInline": false,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 330,
  "tooltip": "Spécifie la couleur des tracés futurs.",
  "helpUrl": "p5BLOCS/DOCU/apparence.html#trait"
},
//couleur du remplissage
{
  "type": "couleurs_remplissage_C",
  "message0": "remplissage %1",
  "args0": [
    {
      "type": "input_value",
      "name": "C",
      "check": "String"
    }
  ],
  "inputsInline": false,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 330,
  "tooltip": "Spécifie la couleur des remplissages futurs.",
  "helpUrl": "p5BLOCS/DOCU/apparence.html#remplissage"
},
//Fixer la taille du crayon
{
  "type": "couleurs_tailleCrayon",
  "message0": "Fixer la taille du crayon à %1",
  "args0": [
    {
      "type": "input_value",
      "name": "TAILLE",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 330,
  "tooltip": "Spécifie l'épaisseur des traits.",
  "helpUrl": "p5BLOCS/DOCU/apparence.html#tailleCrayon"
},
//***********************************************************
//Objets web
//----------------------

//Créer un texte %1 de contenu %2
{
  "type": "catégorie_objetsWebTexte",
  "message0": "Créer un texte %1 de contenu %2",
  "args0": [
    {
      "type": "input_value",
      "name": "OBJET",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "CONTENU",
      "check": "String"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 230,
  "tooltip": "Crée un objet 'texte', sans faire de saut de ligne.",
  "helpUrl": "p5BLOCS/DOCU/objetsWeb.html#texte"
},


//Créer un zone de texte %1 de contenu %2
{
  "type": "objetsWeb_zoneTexte",
  "message0": "Créer une zone de texte %1 de contenu %2 nb lignes %3 nb colonnes %4",
  "args0": [
    {
      "type": "input_value",
      "name": "OBJET",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "CONTENU",
      "check": "Array"
    },
    {
      "type": "input_value",
      "name": "LIGNES",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "COLONNES",
      "check": "Number"
    }
  ],
  "inputsInline": false,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 230,
  "tooltip": "Crée un objet 'zone de texte' dont les dimensions sont spécifiées.",
  "helpUrl": "p5BLOCS/DOCU/objetsWeb.html#zoneTexte"
},

// Créer une entrée %1 de contenu initial %2
{
  "type": "catégorie_objetsWebEntree",
  "message0": "Créer une entrée %1 de contenu initial %2",
  "args0": [
    {
      "type": "input_value",
      "name": "OBJET",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "CONTENU",
      "check": "String"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 230,
  "tooltip": "Crée un objet 'entrée' dans lequel l'utilisateur pourra entrer du texte ou un nombre.",
  "helpUrl": "p5BLOCS/DOCU/objetsWeb.html#entree"
},

// Créer glissière
{
  "type": "objetsWeb_glissiere",
  "message0": "Créer une glissière %1 minimum %2 maximum %3 valeur initiale %4 pas %5",
  "args0": [
    {
      "type": "input_value",
      "name": "NOM_VAR",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "MIN",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "MAX",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "VALEUR",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "PAS",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 230,
  "tooltip": "Crée un objet 'glissière' dotée des caractéristiques spécifiées.",
  "helpUrl": "p5BLOCS/DOCU/objetsWeb.html#glissiere"
},
//Créer bouton
{
  "type": "objetsWeb_bouton",
  "message0": "Créer un bouton %1 affichant %2",
  "args0": [
    {
      "type": "input_value",
      "name": "NOM_VAR",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "TEXTE",
      "check": "String"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 230,
  "tooltip": "Crée un objet 'bouton'.",
  "helpUrl": "p5BLOCS/DOCU/objetsWeb.html#bouton"
},
//Création d'une case à cocher
{
  "type": "objetsWeb_caseCocher",
  "message0": "Créer une case à cocher %1 affichant %2 avec coche %3",
  "args0": [
    {
      "type": "input_value",
      "name": "OBJET",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "TEXTE",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "COCHE",
      "check": "Boolean"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 230,
  "tooltip": "",
  "helpUrl": "p5BLOCS/DOCU/objetsWeb.html#caseAcocher"
},
//Créer paragraphe
{
  "type": "objetsWeb_paragraphe",
  "message0": "Créer un paragraphe %1 contenant %2",
  "args0": [
    {
      "type": "input_value",
      "name": "NOM_VAR",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "TEXTE",
      "check": "String"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 230,
  "tooltip": "Crée un objet 'paragraphe', avec les sauts de lignes appropriés.",
  "helpUrl": "p5BLOCS/DOCU/objetsWeb.html#paragraphe"
},
//Créer titre
{
  "type": "objetsWeb_titre",
  "message0": "Créer un titre %1 contenant %2",
  "args0": [
    {
      "type": "input_value",
      "name": "NOM_VAR",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "TEXTE",
      "check": "String"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 230,
  "tooltip": "Crée un objet 'titre', avec les sauts de lignes appropriés.",
  "helpUrl": "p5BLOCS/DOCU/objetsWeb.html#titre"
},
// Insérer un saut de ligne
{
  "type": "objetsWeb_sautLigne",
  "message0": "Insérer un saut de ligne %1",
  "args0": [
    {
      "type": "input_value",
      "name": "NOM_VAR",
      "check": "String"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 230,
  "tooltip": "Crée un objet 'saut de ligne'. Utile pour séparer les objets non dotés de sauts de lignes automatiques.",
  "helpUrl": "p5BLOCS/DOCU/objetsWeb.html#sautLigne"
},
// Insérer un espacement de pixels
{
  "type": "objetsWeb_espacement",
  "message0": "Insérer %1 un espace de %2 pixels",
  "args0": [
    {
      "type": "input_value",
      "name": "NOM_VAR",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "NBPIX",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 230,
  "tooltip": "Crée un espacement entre deux objets.",
  "helpUrl": "p5BLOCS/DOCU/objetsWeb.html#espacement"
},
//Créer élément
{
  "type": "objetsWeb_element",
  "message0": "Créer élément %1 type %2 texte %3",
  "args0": [
    {
      "type": "input_value",
      "name": "NOM_VAR",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "TYPE",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "TEXTE",
      "check": "String"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 230,
  "tooltip": "Si vous savez ce que vous faites, ce bloc vous permettra de créer certains types d'objets web non définis dans p5Visuel.",
  "helpUrl": "p5BLOCS/DOCU/objetsWeb.html#elementGenerique"
},
//objet correspondant à ID
{
  "type": "objetsWeb_viaID",
  "message0": "élément dont l'ID est %1",
  "args0": [
    {
      "type": "input_value",
      "name": "ID",
      "check": "String"
    }
  ],
  "output": "String",
  "colour": 230,
  "tooltip": "Retourne une référence à un objet défini dans une page web qui n'a pas été créée uniquement avec p5Visuel.",
  "helpUrl": "p5BLOCS/DOCU/objetsWeb.html#elementViaID"
},
//***********************************************************
//Formes
//----------------------
//Tracer un point
{
  "type": "formes_point",
  "message0": "Tracer le point ( %1 , %2 )",
  "args0": [
    {
      "type": "input_value",
      "name": "X",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "Y",
      "check": "Number"
    },
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 160,
  "tooltip": "Trace un point à l'endroit spécifié.",
  "helpUrl": "p5BLOCS/DOCU/formes.html#point"
},
//Tracer un segment
{
  "type": "formes_segment",
  "message0": "Tracer un segment de ( %1 , %2 ) à ( %3 , %4 )",
  "args0": [
    {
      "type": "input_value",
      "name": "X1",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "Y1",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "X2",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "Y2",
      "check": "Number"
    },
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 160,
  "tooltip": "Trace un segment joignant les points spécifiés.",
  "helpUrl": "p5BLOCS/DOCU/formes.html#segment"
},
  //tracer triangle de sommets donnés
{
  "type": "formes_triangle",
  "message0": "triangle de sommets ( %1 , %2 ) , ( %3 , %4 ) et ( %5 , %6 )",
  "args0": [
    {
      "type": "input_value",
      "name": "X1",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "Y1",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "X2",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "Y2",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "X3",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "Y3",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 160,
  "tooltip": "Trace un triangle joignant les points spécifiés.",
  "helpUrl": "p5BLOCS/DOCU/formes.html#triangle"
},
//Tracer un rectangle
{
  "type": "formes_rectangle",
  "message0": "Tracer un rectangle de diag ( %1 , %2 ) à ( %3 , %4 )",
  "args0": [
    {
      "type": "input_value",
      "name": "X1",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "Y1",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "X2",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "Y2",
      "check": "Number"
    },
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 160,
  "tooltip": "Trace un rectangle de diagonale spécifiée.",
  "helpUrl": "p5BLOCS/DOCU/formes.html#rectangle"
},
//Tracer une ellipse
{
  "type": "formes_ellipse",
  "message0": "Ellipse de centre ( %1 , %2 ) et de demi-axes %3 et %4",
  "args0": [
    {
      "type": "input_value",
      "name": "X",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "Y",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "A",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "B",
      "check": "Number"
    },
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 160,
  "tooltip": "Trace une ellipse. Trace un cercle si les deux demi-axes sont égaux au rayon.",
  "helpUrl": "p5BLOCS/DOCU/formes.html#ellipse"
},  
//Tracer un arc d'ellipse
{
  "type": "formes_arc",
  "message0": "Arc de centre ( %1 , %2 ) et demi-axes %3 et %4 , allant de %5 à %6",
  "args0": [
    {
      "type": "input_value",
      "name": "X",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "Y",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "A",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "B",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "DEBUT",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "FIN",
      "check": "Number"
    },
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 160,
  "tooltip": "Trace un arc d'ellipse joignant le premier angle au second, dans le sens des aiguilles d'une montre.",
  "helpUrl": "p5BLOCS/DOCU/formes.html#arc"
},    
//débuter polygone
{
  "type": "formes_debutPoly",
  "message0": "Débuter le polygone",
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 160,
  "tooltip": "Annonce que l'on va spécifier les sommets d'un polygone.",
  "helpUrl": "p5BLOCS/DOCU/formes.html#debutPoly"
},    
//ajouter un sommet au polygone
{
  "type": "formes_sommet",
  "message0": "sommet ( %1 , %2 )",
  "args0": [
    {
      "type": "input_value",
      "name": "X",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "Y",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 160,
  "tooltip": "Spécifie un sommet du polygone courant.",
  "helpUrl": "p5BLOCS/DOCU/formes.html#sommet"
}, 
//finir polygone
{
  "type": "formes_finPoly",
  "message0": "Terminer le polygone",
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 160,
  "tooltip": "Annonce que l'on a fini de spécifier les sommets d'un polygone.",
  "helpUrl": "p5BLOCS/DOCU/formes.html#finPoly"
},  
//Translation du système de coordonnées
{
  "type": "formes_translation",
  "message0": "Translation des coordonnées par ( %1 , %2 )",
  "args0": [
    {
      "type": "input_value",
      "name": "X",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "Y",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 160,
  "tooltip": "Déplace l'origine du système de coordonnées.",
  "helpUrl": "p5BLOCS/DOCU/formes.html#translation"
},
//***********************************************************
//Géométrie de la tortue
//----------------------

//Initialise la tortue
{
  "type": "tortue_initTortue",
  "message0": "Initialiser les paramètres tortue",
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 260,
  "tooltip": "Efface le canvas et place la tortue dans son état initial",
  "helpUrl": "p5BLOCS/DOCU/tortue.html#init"
},

//Lève le crayon de la tortue
{
  "type": "tortue_leveCrayon",
  "message0": "Lever le crayon de la tortue",
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 330,
  "tooltip": "À partir de ce moment, la tortue se déplace sans laisser de trace.",
  "helpUrl": "p5BLOCS/DOCU/apparence.html#leverCrayon"
},

//Ne pas remplir
{
  "type": "tortue_sansRemplissage",
  "message0": "Sans remplissage",
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 330,
  "tooltip": "Les figures seront tracées sans remplissage.",
  "helpUrl": "p5BLOCS/DOCU/apparence.html#sansRemplissage"
},

//Baisse le crayon de la tortue
{
  "type": "tortue_baisseCrayon",
  "message0": "Baisser le crayon de la tortue",
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 330,
  "tooltip": "À partir de ce moment, la tortue se déplace en laissant une trace.",
  "helpUrl": "p5BLOCS/DOCU/apparence.html#baisserCrayon"
},

// avance(d)
{
  "type": "tortue_avance",
  "message0": "avance d'une distance %1",
  "args0": [
    {
      "type": "input_value",
      "name": "distance",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 260,
  "tooltip": "La tortue avance d'une distance (en pixels).",
  "helpUrl": "p5BLOCS/DOCU/tortue.html#avance"
},

// recule(d)
{
  "type": "tortue_recule",
  "message0": "recule d'une distance %1",
  "args0": [
    {
      "type": "input_value",
      "name": "distance",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 260,
  "tooltip": "La tortue recule d'une distance (en pixels).",
  "helpUrl": "p5BLOCS/DOCU/tortue.html#recule"
},

//droite(angle)
{
  "type": "tortue_droite",
  "message0": "tourne à droite de %1 degrés",
  "args0": [
    {
      "type": "input_value",
      "name": "alpha",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 260,
  "tooltip": "La tortue tourne à droite d'un angle (en degrés).",
  "helpUrl": "p5BLOCS/DOCU/tortue.html#droite"
},
//gauche(angle)
{
  "type": "tortue_gauche",
  "message0": "tourne à gauche de %1 degrés",
  "args0": [
    {
      "type": "input_value",
      "name": "alpha",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 260,
  "tooltip": "La tortue tourne à gauche d'un angle (en degrés).",
  "helpUrl": "p5BLOCS/DOCU/tortue.html#gauche"
},
// posX()
{
    "type": "tortue_posX",
    "message0": "coordonnée en x de la tortue",
    "output": "Number",
    "colour": 260,
    "tooltip": "Retourne la coordonnée en X de la position actuelle de la tortue.",
    "helpUrl": "p5BLOCS/DOCU/tortue.html#coordX"
},
//posY()
{
    "type": "tortue_posY",
    "message0": "coordonnée en y de la tortue",
    "output": "Number",
    "colour": 260,
    "tooltip": "Retourne la coordonnée en Y de la position actuelle de la tortue.",
    "helpUrl": "p5BLOCS/DOCU/tortue.html#coordY"
},
//fixePos(x,y)
{
  "type": "tortue_fixePos",
  "message0": "aller au point ( %1 , %2 )",
  "args0": [
    {
      "type": "input_value",
      "name": "X",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "Y",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 260,
  "tooltip": "Déplace la tortue à la position spécifiée. Laisse une trace si le crayon est baissé.",
  "helpUrl": "p5BLOCS/DOCU/tortue.html#allerPos"
},
//sautePos(x,y)
{
  "type": "tortue_sautePos",
  "message0": "sauter au point ( %1 , %2 )",
  "args0": [
    {
      "type": "input_value",
      "name": "X",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "Y",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 260,
  "tooltip": "Déplace la tortue à la position spécifiée, sans laisser de trace, que le crayon soit levé ou non.",
  "helpUrl": "p5BLOCS/DOCU/tortue.html#sauterPos"
},
//cap()
{
    "type": "tortue_cap",
    "message0": "cap de la tortue",
    "output": "Number",
    "colour": 260,
    "tooltip": "Retourne le cap actuel de la tortue.",
    "helpUrl": "p5BLOCS/DOCU/tortue.html#cap"
},
//fixeCap(angle)
{
  "type": "tortue_fixeCap",
  "message0": "fixer le cap à %1 ",
  "args0": [
    {
      "type": "input_value",
      "name": "ALPHA",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 260,
  "tooltip": "Fixe de cap de la tortue à l'angle spécifié.",
  "helpUrl": "p5BLOCS/DOCU/tortue.html#fixeCap"
},
//vers(x,y)
{
  "type": "tortue_vers",
  "message0": "angle vers ( %1 , %2 )",
  "args0": [
    {
      "type": "input_value",
      "name": "X",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "Y",
      "check": "Number"
    }
  ],
  "output": "Number",
  "colour": 260,
  "tooltip": "Retourne quel devrait être le cap de la tortue pour qu'elle pointe vers le point spécifié.",
  "helpUrl": "p5BLOCS/DOCU/tortue.html#angleVers"
},
//***********************************************************
//Propriétés
//----------------------

// valeur de la glissière et des boites de texte/input
{
  "type": "proprietes_valeur",
  "message0": "valeur de %1",
  "args0": [
    {
      "type": "input_value",
      "name": "OBJ",
      "check": "String"
    }
  ],
  "output": "Number",
  "colour": 20,
  "tooltip": "Retourne la valeur actuelle de l'objet spécifié (entrée ou glissière).",
  "helpUrl": "p5BLOCS/DOCU/proprietes.html#valeur"
},
// contenu d'un élément
{
  "type": "proprietes_contenu",
  "message0": "contenu de %1",
  "args0": [
    {
      "type": "input_value",
      "name": "OBJ",
      "check": "String"
    }
  ],
  "output": "String",
  "colour": 20,
  "tooltip": "Retourne un texte, qui est le contenu de l'objet en question (texte, paragraphe, titre)",
  "helpUrl": "p5BLOCS/DOCU/proprietes.html#contenu"
},
// état de la case à cocher
{
  "type": "proprietes_etatCC",
  "message0": "état de la case à cocher %1",
  "args0": [
    {
      "type": "input_value",
      "name": "OBJ",
      "check": "String"
    }
  ],
  "output": "Boolean",
  "colour": 20,
  "tooltip": "",
  "helpUrl": "p5BLOCS/DOCU/proprietes.html#etatCoche"
},
//cacher l'objet
{
  "type": "proprietes_cacher",
  "message0": "Cacher l'objet %1",
  "args0": [
    {
      "type": "input_value",
      "name": "OBJET",
      "check": "String"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 20,
  "tooltip": "Fait disparaître l'objet spécifié.",
  "helpUrl": "p5BLOCS/DOCU/proprietes.html#cacher"
},
//montrer l'objet
{
  "type": "proprietes_montrer",
  "message0": "Montrer l'objet %1",
  "args0": [
    {
      "type": "input_value",
      "name": "OBJET",
      "check": "String"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 20,
  "tooltip": "Fait apparaître l'objet spécifié.",
  "helpUrl": "p5BLOCS/DOCU/proprietes.html#montrer"
},

//----------------------
//Fixe la valeur (glissière <-- nombre)
{
  "type": "proprietes_fixeValeur",
  "message0": "Fixe la valeur de %1 à %2",
  "args0": [
    {
      "type": "input_value",
      "name": "OBJET",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "VALEUR",
      "check": ["String","Number"]
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 20,
  "tooltip": "Le nombre ou le texte devient la valeur de l'objet en question (entrée, glissière)",
  "helpUrl": "p5BLOCS/DOCU/proprietes.html#fixerValeur"
},

//----------------------
//Fixe le contenu HTML
{
  "type": "proprietes_fixeContenu",
  "message0": "Fixe le contenu de %1 à %2",
  "args0": [
    {
      "type": "input_value",
      "name": "OBJET",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "TEXTE",
      "check": ["String","Number"]
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 20,
  "tooltip": "Le texte devient le contenu de l'objet en question (texte, paragraphe, titre)",
  "helpUrl": "p5BLOCS/DOCU/proprietes.html#fixerContenu"
},

//----------------------
//Fixe le contenu d'une zone de texte
{
  "type": "proprietes_fixeContenuZone",
  "message0": "Fixe le contenu de la zone de texte %1 à %2",
  "args0": [
    {
      "type": "input_value",
      "name": "OBJET",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "TEXTE",
      "check": "Array"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 20,
  "tooltip": "Les éléments de la liste deviennent les lignes successives de la zone de texte",
  "helpUrl": "p5BLOCS/DOCU/proprietes.html#fixerContenuZone"
},
//----------------------
//associe procédure à bouton
{
  "type": "proprietes_boutonClic",
  "message0": "si clic sur %1 faire  %2",
  "args0": [
    {
      "type": "input_value",
      "name": "VAR_BOUTON",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "PROC",
      "check": "String"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 20,
  "tooltip": "En cas de clic sur l'objet (bouton, canvas, etc) exécuter la fonction spécifiée.",
  "helpUrl": "p5BLOCS/DOCU/proprietes.html#siClic"
},
//----------------------
//associe procédure à changement
{
  "type": "proprietes_etatChange",
  "message0": "si l'état de %1 change faire  %2",
  "args0": [
    {
      "type": "input_value",
      "name": "VAR_OBJET",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "PROC",
      "check": "String"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 20,
  "tooltip": "En cas de changement de l'objet (glissière, case à cocher) exécuter la fonction spécifiée.",
  "helpUrl": "p5BLOCS/DOCU/proprietes.html#siChangement"
},
//----------------------
//associe parent à un objet
{
  "type": "proprietes_parent",
  "message0": "l'objet %1 aura l'ID %2 pour parent",
  "args0": [
    {
      "type": "input_value",
      "name": "VAR_OBJET",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "ID",
      "check": "String"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 20,
  "tooltip": "Spécifie que l'objet doit être contenu dans le parent spécifié.",
  "helpUrl": "p5BLOCS/DOCU/proprietes.html#parent"
},
//associe parent à un objet 2
{
  "type": "proprietes_parent2",
  "message0": "l'objet %1 aura l'objet %2 pour parent",
  "args0": [
    {
      "type": "input_value",
      "name": "VAR_OBJET",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "PAR",
      "check": "String"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 20,
  "tooltip": "Spécifie que l'objet doit être contenu dans le parent spécifié.",
  "helpUrl": "p5BLOCS/DOCU/proprietes.html#parent"
},
//style
{
  "type": "proprietes_style",
  "message0": "Pour l'objet %1 style %2 valeur %3",
  "args0": [
    {
      "type": "input_value",
      "name": "OBJET",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "ITEM",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "VALEUR",
      "check": "String"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 20,
  "tooltip": "Permet de changer certaines caractéristiques de l'objet.",
  "helpUrl": "p5BLOCS/DOCU/proprietes.html#propriete"
},
//fixer position absolue
{
  "type": "proprietes_positionAbs",
  "message0": "Placer l'élément %1 en position absolue ( %2 , %3 )",
  "args0": [
    {
      "type": "input_value",
      "name": "OBJET",
      "check": "String"
    },
    {
      "type": "input_value",
      "name": "X",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "Y",
      "check": "Number"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 20,
  "tooltip": "Fixe la position de l'objet. L'origine est en haut à gauche de la fenêtre (et non du canvas).",
  "helpUrl": "p5BLOCS/DOCU/proprietes.html#position"
},
// Charger une image
{
  "type": "image_charger",
  "message0": "Charger le fichier image de nom %1",
  "args0": [
    {
      "type": "input_value",
      "name": "nomImage",
      "check": "String",
    }
  ],
  "output": "String",
  "colour": 306,
  "tooltip": "Charge en mémoire un fichier image. Elle n'apparaît pas encore sur notre page web.",
  "helpUrl": "p5BLOCS/DOCU/images.html#chargerFichier"
},
// Placer une image
{
  "type": "image_placer",
  "message0": "Placer image %1 dans canvas en position (%2,%3) en taille originale %4",
  "args0": [
    {
      "type": "input_value",
      "name": "nomImage",
      "check": "String",
    },
    {
      "type": "input_value",
      "name": "posX",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "posY",
      "check": "Number"
    },
    {
      "type": "input_value",
      "name": "memeTaille",
      "check": "Boolean"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 306,
  "tooltip": "Place une image en mémoire dans le canvas.",
  "helpUrl": "p5BLOCS/DOCU/images.html#placerImage"
},
// Retourne la liste pixels
{
  "type": "image_pixelsDuCanvas",
  "message0": "PIXELS",
  "args0": [],
  "inputsInline": true,
  "output": "Array",
  "colour": 306,
  "tooltip": "Retourne la liste des pixels du canvas (initiale ou modifiée).",
  "helpUrl": "p5BLOCS/DOCU/images.html#initialiserPixels"
},
// Charger les pixels du canvas
{
  "type": "image_chargerPixels",
  "message0": "Transfert des pixels du canvas dans PIXELS",
  "args0": [],
  "previousStatement": null,
  "nextStatement": null,
  "colour": 306,
  "tooltip": "Charge les pixels du canvas dans une liste, que l'on pourra récupérer et modifier via le bloc PIXELS.",
  "helpUrl": "p5BLOCS/DOCU/images.html#chargerPixels"
},
// Modifier les pixels
{
  "type": "image_modifier",
  "message0": "Transfert de PIXELS dans les pixels du canvas",
  "args0": [],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 306,
  "tooltip": "Redéfinir le canvas à partir de notre liste de pixels.",
  "helpUrl": "p5BLOCS/DOCU/images.html#miseAjour"
},
// Obtenir valeur d'une composante de pixel
{
  "type": "image_obtenirPixel",
  "message0": "Lire info dans %1 ligne %2 colonne %3 composante %4",
  "args0": [
    {
      "type": "input_value",
      "name": "bloc",
      "check": "Array",
    },
    {
      "type": "input_value",
      "name": "ligne",
      "check": "Number",
    },
    {
      "type": "input_value",
      "name": "colonne",
      "check": "Number",
    },
    {
      "type": "input_value",
      "name": "composante",
      "check": "Number",
    }
  ],
  "inputsInline": true,
  "output": "Number",
  "colour": 306,
  "tooltip": "Obtenir la composante spécifiée de la liste des pixels.",
  "helpUrl": "p5BLOCS/DOCU/images.html#lirePixel"
},
// Définir valeur d'une composante de pixel
{
  "type": "image_definirPixel",
  "message0": "Écrire info dans %1 ligne %2 colonne %3 composante %4 valeur %5",
  "args0": [
    {
      "type": "input_value",
      "name": "bloc",
      "check": "Array",
    },
    {
      "type": "input_value",
      "name": "ligne",
      "check": "Number",
    },
    {
      "type": "input_value",
      "name": "colonne",
      "check": "Number",
    },
    {
      "type": "input_value",
      "name": "composante",
      "check": "Number",
    },
    {
      "type": "input_value",
      "name": "valeur",
      "check": "Number",
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 306,
  "tooltip": "Modifier la composante spécifiée de la liste des pixels.",
  "helpUrl": "p5BLOCS/DOCU/images.html#ecrirePixel"
},
// Dépôt d'une image dans le canvas
{
  "type": "image_depot",
  "message0": "Si image déposée dans canvas, faire %1",
  "args0": [
    {
      "type": "input_value",
      "name": "nomFonction",
      "check": "String"
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 306,
  "tooltip": "Spécifie une fonction pour gérer un glisser-déposer dans le canvas.",
  "helpUrl": "p5BLOCS/DOCU/images.html#depot"
},
// Charger une vidéo
{
  "type": "video_charger",
  "message0": "Charger vidéo %1 puis faire %2 quand c'est prêt",
  "args0": [
    {
      "type": "input_value",
      "name": "nomVideo",
      "check": "String",
    },
    {
      "type": "input_value",
      "name": "fonction",
      "check": ["Number", "String", "Array"]
    }
  ],
  "output": "String",
  "colour": 120,
  "tooltip": "Charge en mémoire la vidéo contenue dans le fichier spécifié, et l'affiche dans notre page web",
  "helpUrl": "p5BLOCS/DOCU/videos.html#charger"
},
// Vidéo en marche
{
  "type": "video_marche",
  "message0": "Mettre la vidéo %1 en marche",
  "args0": [
    {
      "type": "input_value",
      "name": "objetVideo",
      "check": "String",
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 120,
  "tooltip": "Mettre la vidéo en marche.",
  "helpUrl": "p5BLOCS/DOCU/videos.html#marche"
},
// Vidéo en pause
{
  "type": "video_pause",
  "message0": "Mettre la vidéo %1 en pause",
  "args0": [
    {
      "type": "input_value",
      "name": "objetVideo",
      "check": "String",
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 120,
  "tooltip": "Mettre la vidéo en pause.",
  "helpUrl": "p5BLOCS/DOCU/videos.html#pause"
},
// Fixer temps de la vidéo
{
  "type": "video_fixePos",
  "message0": "Amener la vidéo %1 au temps %2",
  "args0": [
    {
      "type": "input_value",
      "name": "objetVideo",
      "check": "String",
    },
    {
      "type": "input_value",
      "name": "temps",
      "check": "Number",
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 120,
  "tooltip": "Faire sauter la vidéo au temps donné.",
  "helpUrl": "p5BLOCS/DOCU/videos.html#sauter"
},
// Action vidéo au temps donné
{
  "type": "video_signal",
  "message0": "Définir action %1 avec paramètre %2 au temps %3 secondes de la vidéo %4",
  "args0": [
    {
      "type": "input_value",
      "name": "action",
      "check": "String",
    },
    {
      "type": "input_value",
      "name": "param",
      "check": ["Number", "String", "Array"],
    },
    {
      "type": "input_value",
      "name": "temps",
      "check": "Number",
    },
    {
      "type": "input_value",
      "name": "objetVideo",
      "check": "String",
    }
  ],
  "inputsInline": true,
  "previousStatement": null,
  "nextStatement": null,
  "colour": 120,
  "tooltip": "Définir une action à réaliser quand la vidéo arrivera à un temps donné.",
  "helpUrl": "p5BLOCS/DOCU/videos.html#action"
}
]);  // END JSON EXTRACT (Do not delete this comment.)

