
'use strict';

//goog.provide('Blockly.JavaScript.tortue');

goog.require('Blockly.JavaScript');

// Listes (Blockly modifié)
//-------------------------
// Obtenir valeur de liste
Blockly.JavaScript['listes_obtenir'] = function(block) {
  var valeur1 = Blockly.JavaScript.valueToCode(block, 'liste', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur2 = Blockly.JavaScript.valueToCode(block, 'indice', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur3 = Blockly.JavaScript.valueToCode(block, 'valeur', Blockly.JavaScript.ORDER_ATOMIC);
  var code = valeur1+'['+valeur2+']'; 
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
// Changer valeur de liste
Blockly.JavaScript['listes_changer'] = function(block) {
  var valeur1 = Blockly.JavaScript.valueToCode(block, 'liste', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur2 = Blockly.JavaScript.valueToCode(block, 'indice', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur3 = Blockly.JavaScript.valueToCode(block, 'valeur', Blockly.JavaScript.ORDER_ATOMIC);
  var code = valeur1+'['+valeur2+'] = '+valeur3+';\n'; 
  return code;
};
// Dublicata d'une liste
Blockly.JavaScript['listes_duplicata'] = function(block) {
  var valeur1 = Blockly.JavaScript.valueToCode(block, 'liste', Blockly.JavaScript.ORDER_ATOMIC);
  var code = valeur1+'.slice()';
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//Programmation
//----------------------
//Commentaire
Blockly.JavaScript['programmation_commentaire'] = function(block) {
  var value_comment = Blockly.JavaScript.valueToCode(block, 'TEXTE', Blockly.JavaScript.ORDER_ATOMIC);
  var code = '// '+value_comment+'\n';
  return code;
};
// Faire
Blockly.JavaScript['programmation_faire'] = function(block) {
  var valeur1 = Blockly.JavaScript.valueToCode(block, 'fonction', Blockly.JavaScript.ORDER_ATOMIC);
  var code = valeur1.slice(1,-1)+';\n';
  return code;
};
// Faire après délai
Blockly.JavaScript['programmation_faireDelai'] = function(block) {
  var valeur1 = Blockly.JavaScript.valueToCode(block, 'fonction', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur2 = Blockly.JavaScript.valueToCode(block, 'delai', Blockly.JavaScript.ORDER_ATOMIC);
  valeur1 = valeur1.slice(1,-3);
  var code = 'setTimeout('+valeur1+','+valeur2+'*1000);\n'; 
  return code;
};
//Variable locale
Blockly.JavaScript['programmation_varLocale'] = function(block) {
  var nom_var = Blockly.JavaScript.valueToCode(block, 'VARIABLE', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'var '+nom_var+';\n';
  return code;
};
// boucle POUR croissant
Blockly.JavaScript['programmation_pourCroiss'] = function(block) {
  // For loop.
  var variable0 = Blockly.JavaScript.variableDB_.getName(
      block.getFieldValue('VAR'), Blockly.Variables.NAME_TYPE);
  var argument0 = Blockly.JavaScript.valueToCode(block, 'FROM',
      Blockly.JavaScript.ORDER_ASSIGNMENT) || '0';
  var argument1 = Blockly.JavaScript.valueToCode(block, 'TO',
      Blockly.JavaScript.ORDER_ASSIGNMENT) || '0';
  var increment = Blockly.JavaScript.valueToCode(block, 'BY',
      Blockly.JavaScript.ORDER_ASSIGNMENT) || '1';
  var branch = Blockly.JavaScript.statementToCode(block, 'DO');
  branch = Blockly.JavaScript.addLoopTrap(branch, block.id);
  var code;
  code = 'for (' + variable0 + ' = ' + argument0 + '; ' +
        variable0 + ' <= ' + argument1 + '; ' +
        variable0 + ' += abs(' + increment + ')) {\n' +
        branch + '}\n';
  return code;
};
// boucle POUR décroissant
Blockly.JavaScript['programmation_pourDecroiss'] = function(block) {
  // For loop.
  var variable0 = Blockly.JavaScript.variableDB_.getName(
      block.getFieldValue('VAR'), Blockly.Variables.NAME_TYPE);
  var argument0 = Blockly.JavaScript.valueToCode(block, 'FROM',
      Blockly.JavaScript.ORDER_ASSIGNMENT) || '0';
  var argument1 = Blockly.JavaScript.valueToCode(block, 'TO',
      Blockly.JavaScript.ORDER_ASSIGNMENT) || '0';
  var increment = Blockly.JavaScript.valueToCode(block, 'BY',
      Blockly.JavaScript.ORDER_ASSIGNMENT) || '1';
  var branch = Blockly.JavaScript.statementToCode(block, 'DO');
  branch = Blockly.JavaScript.addLoopTrap(branch, block.id);
  var code;
  code = 'for (' + variable0 + ' = ' + argument0 + '; ' +
        variable0 + ' >= ' + argument1 + '; ' +
        variable0 + ' -= abs(' + increment + ')) {\n' +
        branch + '}\n';
  return code;
};
//quitter la procédure
Blockly.JavaScript['programmation_quitter'] = function(block) {
  var valeur = Blockly.JavaScript.valueToCode(block, 'VALEUR', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'return '+valeur+';\n'; 
  return code;
};
//tester si chaine est un nombre
Blockly.JavaScript['programmation_estNombre'] = function(block) {
  var chaine = Blockly.JavaScript.valueToCode(block, 'CHAINE', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'estNombre('+chaine+')'; 
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//conversion en radians
Blockly.JavaScript['programmation_radians'] = function(block) {
  var alpha = Blockly.JavaScript.valueToCode(block, 'ANGLE', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'radians('+alpha+')'; 
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//conversion en degres
Blockly.JavaScript['programmation_degres'] = function(block) {
  var alpha = Blockly.JavaScript.valueToCode(block, 'ANGLE', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'degres('+alpha+')'; 
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//Clic sur bouton de la souris
Blockly.JavaScript['programmation_clicSouris'] = function(block) {
  var code = 'mouseIsPressed';
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//Retourne l'ancienne position en X de la souris
Blockly.JavaScript['programmation_EXsourisX'] = function(block) {
  var code = 'pmouseX';
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//Retourne l'ancienne position en Y de la souris
Blockly.JavaScript['programmation_EXsourisY'] = function(block) {
  var code = 'pmouseY';
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//Retourne la position en X de la souris
Blockly.JavaScript['programmation_sourisX'] = function(block) {
  var code = 'mouseX';
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//Retourne la position en Y de la souris
Blockly.JavaScript['programmation_sourisY'] = function(block) {
  var code = 'mouseY';
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//remplacement
Blockly.JavaScript['programmation_remplacement'] = function(block) {
  var texte = Blockly.JavaScript.valueToCode(block, 'TEXTE', Blockly.JavaScript.ORDER_ATOMIC);
  var depart = Blockly.JavaScript.valueToCode(block, 'DEPART', Blockly.JavaScript.ORDER_ATOMIC);
  var arrivee = Blockly.JavaScript.valueToCode(block, 'ARRIVEE', Blockly.JavaScript.ORDER_ATOMIC);
  var code = texte+'.replace(new RegExp('+depart+',"g"),'+arrivee+')'; 
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//substitution
Blockly.JavaScript['programmation_substitution'] = function(block) {
  var modele = Blockly.JavaScript.valueToCode(block, 'MODELE', Blockly.JavaScript.ORDER_ATOMIC);
  var listeValeurs = Blockly.JavaScript.valueToCode(block, 'LISTEVALEURS', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'substitution('+modele+','+listeValeurs+')';
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//Crée les formules mathématiques
Blockly.JavaScript['programmation_refreshMathJax'] = function(block) {
  var code = 'refreshMathJax();'; 
  return code;
};
//code mathématique
Blockly.JavaScript['programmation_codeMath'] = function(block) {
  var chaine = Blockly.JavaScript.valueToCode(block, 'CHAINE', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'codeMath('+chaine+')'; 
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//p5.js
//----------------------
// Créer une entrée %1 de contenu initial %2
Blockly.JavaScript['catégorie_margeGauche'] = function(block) {
  var nbPixels = Blockly.JavaScript.valueToCode(block, 'NB_PIXELS', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'document.body.style.paddingLeft="'+nbPixels+'px";\n';
  return code;
};
//Créer le canvas (ancienne version)
//Blockly.JavaScript['p5_js_creerCanvas'] = function(block) {
//  var nom_var = Blockly.JavaScript.valueToCode(block, 'NOM_VAR', Blockly.JavaScript.ORDER_ATOMIC);
//  if (nom_var.length != 0) {nom_var=nom_var+"=";}
//  var horiz = Blockly.JavaScript.valueToCode(block, 'HORIZ', Blockly.JavaScript.ORDER_ATOMIC);
//  var vert = Blockly.JavaScript.valueToCode(block, 'VERT', Blockly.JavaScript.ORDER_ATOMIC);
//  var code = nom_var+'createCanvas('+horiz+','+vert+');\n'+'creerTortue();\n';
//  return code;
//};

//Créer le canvas
Blockly.JavaScript['p5_js_creerCanvas'] = function(block) {
  var horiz = Blockly.JavaScript.valueToCode(block, 'HORIZ', Blockly.JavaScript.ORDER_ATOMIC);
  var vert = Blockly.JavaScript.valueToCode(block, 'VERT', Blockly.JavaScript.ORDER_ATOMIC);
  //var code = 'canvas=createCanvas('+horiz+','+vert+');\n'+'initTortue();\n';
  var code = 'canvas=creerCanvas('+horiz+','+vert+');\n';
  return code;
};
//Lève le crayon de la tortue
Blockly.JavaScript['tortue_leveCrayon'] = function(block) {
  var code = 'leveCrayon();\n'; 
  return code;
};
//Baisse le crayon de la tortue
Blockly.JavaScript['tortue_baisseCrayon'] = function(block) {
  var code = 'baisseCrayon();\n'; 
  return code;
};
//Sans remplissage
Blockly.JavaScript['tortue_sansRemplissage'] = function(block) {
  var code = 'noFill();\n'; 
  return code;
};
//Retourne la largeur du canvas (width)
Blockly.JavaScript['p5_js_largeurCanvas'] = function(block) {
  var code = 'width';
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//Retourne la hauteur du canvas (height)
Blockly.JavaScript['p5_js_hauteurCanvas'] = function(block) {
  var code = 'height';
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//enregistre l'image du canvas
Blockly.JavaScript['p5_js_enregistrerCanvas'] = function(block) {
  var code = 'enregistrerCanvas();'; 
  return code;
};
//noCanvas
Blockly.JavaScript['p5_js_noCanvas'] = function(block) {
  var code = '//noCanvas();\n'; 
  return code; 
};
//noLoop
Blockly.JavaScript['p5_js_noLoop'] = function(block) {
  var code = 'noLoop();\n'; 
  return code; 
};
// vitesse de boucle "draw" (en pourcentage)
Blockly.JavaScript['p5_js_vitesseDraw'] = function(block) {
  var valeur1 = Blockly.JavaScript.valueToCode(block, 'VITESSE', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'frameRate(round('+valeur1+'));\n'; 
  return code;
};
//----------------------
//Expression p5
Blockly.JavaScript['p5_js_expression'] = function(block) {
  var commande = Blockly.JavaScript.valueToCode(block, 'TEXTE', Blockly.JavaScript.ORDER_ATOMIC);
  var code = "("+commande.slice(1,-1)+")";
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//----------------------
//Commande
Blockly.JavaScript['p5_js_commande'] = function(block) {
  var commande = Blockly.JavaScript.valueToCode(block, 'TEXTE', Blockly.JavaScript.ORDER_ATOMIC);
  var code = commande.slice(1,-1)+';\n';
  return code;
};
//******************************************************
//Objets web
//----------------------
//Créer un texte %1 de contenu %2
Blockly.JavaScript['catégorie_objetsWebTexte'] = function(block) {
  var objet = Blockly.JavaScript.valueToCode(block, 'OBJET', Blockly.JavaScript.ORDER_ATOMIC);
  if (objet.length != 0) {objet=objet+"=";}
  var contenu = Blockly.JavaScript.valueToCode(block, 'CONTENU', Blockly.JavaScript.ORDER_ATOMIC);
  var code = objet+"createSpan("+contenu+");\n";
  return code;
};
//----------------------
//Créer une zone de texte %1 de contenu %2
Blockly.JavaScript['objetsWeb_zoneTexte'] = function(block) {
  var objet = Blockly.JavaScript.valueToCode(block, 'OBJET', Blockly.JavaScript.ORDER_ATOMIC);
  if (objet.length != 0) {objet=objet+"=";}
  var contenu = Blockly.JavaScript.valueToCode(block, 'CONTENU', Blockly.JavaScript.ORDER_ATOMIC);
  var lignes = Blockly.JavaScript.valueToCode(block, 'LIGNES', Blockly.JavaScript.ORDER_ATOMIC);
  var colonnes = Blockly.JavaScript.valueToCode(block, 'COLONNES', Blockly.JavaScript.ORDER_ATOMIC);
  var code = objet+"creerZoneTexte("+contenu+","+lignes+","+colonnes+");\n";
  return code;
};
// Créer une entrée %1 de contenu initial %2
Blockly.JavaScript['catégorie_objetsWebEntree'] = function(block) {
  var objet = Blockly.JavaScript.valueToCode(block, 'OBJET', Blockly.JavaScript.ORDER_ATOMIC);
  if (objet.length != 0) {objet=objet+"=";}
  var contenu = Blockly.JavaScript.valueToCode(block, 'CONTENU', Blockly.JavaScript.ORDER_ATOMIC);
  var code = objet+"createInput("+contenu+");\n";
  return code;
};
//Glissière
Blockly.JavaScript['objetsWeb_glissiere'] = function(block) {
  var nom_var = Blockly.JavaScript.valueToCode(block, 'NOM_VAR', Blockly.JavaScript.ORDER_ATOMIC);
  if (nom_var.length != 0) {nom_var=nom_var+"=";}
  var val_min = Blockly.JavaScript.valueToCode(block, 'MIN', Blockly.JavaScript.ORDER_ATOMIC);
  var val_max = Blockly.JavaScript.valueToCode(block, 'MAX', Blockly.JavaScript.ORDER_ATOMIC);
  var val_valeur = Blockly.JavaScript.valueToCode(block, 'VALEUR', Blockly.JavaScript.ORDER_ATOMIC);
  var val_pas = Blockly.JavaScript.valueToCode(block, 'PAS', Blockly.JavaScript.ORDER_ATOMIC);
  var code = nom_var+'createSlider('+val_min+','+val_max+','+val_valeur+','+val_pas+');\n';
  return code;
};
//bouton
Blockly.JavaScript['objetsWeb_bouton'] = function(block) {
  var nom_var = Blockly.JavaScript.valueToCode(block, 'NOM_VAR', Blockly.JavaScript.ORDER_ATOMIC);
  if (nom_var.length != 0) {nom_var=nom_var+"=";}
  var texte = Blockly.JavaScript.valueToCode(block, 'TEXTE', Blockly.JavaScript.ORDER_ATOMIC);
  var code = nom_var+'createButton('+texte+');\n';
  return code;
};
//Création d'une case à cocher
Blockly.JavaScript['objetsWeb_caseCocher'] = function(block) {
  var nom = Blockly.JavaScript.valueToCode(block, 'OBJET', Blockly.JavaScript.ORDER_ATOMIC);
  if (nom.length != 0) {nom=nom+"=";}
  var texte = Blockly.JavaScript.valueToCode(block, 'TEXTE', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur = Blockly.JavaScript.valueToCode(block, 'COCHE', Blockly.JavaScript.ORDER_ATOMIC);
  var code = nom+"createCheckbox("+texte+","+valeur+");\n"; 
  return code;
};
//----------------------
//Paragraphe
Blockly.JavaScript['objetsWeb_paragraphe'] = function(block) {
  var nom_var = Blockly.JavaScript.valueToCode(block, 'NOM_VAR', Blockly.JavaScript.ORDER_ATOMIC);
  if (nom_var.length != 0) {nom_var=nom_var+"=";}
  var contenu = Blockly.JavaScript.valueToCode(block, 'TEXTE', Blockly.JavaScript.ORDER_ATOMIC);
  var code = nom_var+'createP('+contenu+');\n';
  return code;
};
//----------------------
//Titre
Blockly.JavaScript['objetsWeb_titre'] = function(block) {
  var nom_var = Blockly.JavaScript.valueToCode(block, 'NOM_VAR', Blockly.JavaScript.ORDER_ATOMIC);
  if (nom_var.length != 0) {nom_var=nom_var+"=";}
  var contenu = Blockly.JavaScript.valueToCode(block, 'TEXTE', Blockly.JavaScript.ORDER_ATOMIC);
  var code = nom_var+'createElement("h1",'+contenu+');\n';
  return code;
};
//----------------------
// Insérer un saut de ligne
Blockly.JavaScript['objetsWeb_sautLigne'] = function(block) {
  var nom_var = Blockly.JavaScript.valueToCode(block, 'NOM_VAR', Blockly.JavaScript.ORDER_ATOMIC);
  if (nom_var.length != 0) {nom_var=nom_var+"=";}
  var code = nom_var+'createSpan("<br>");\n';
  return code;
};
//----------------------
// Insérer un espacement
Blockly.JavaScript['objetsWeb_espacement'] = function(block) {
  var nom_var = Blockly.JavaScript.valueToCode(block, 'NOM_VAR', Blockly.JavaScript.ORDER_ATOMIC);
  if (nom_var.length != 0) {nom_var=nom_var+"=";}
  var nbPixels = Blockly.JavaScript.valueToCode(block, 'NBPIX', Blockly.JavaScript.ORDER_ATOMIC);
  var code = nom_var+'createSpan("").style("display","inline-block").style("width","'+nbPixels+'px");\n';
  return code;
};
//----------------------
//Élément
Blockly.JavaScript['objetsWeb_element'] = function(block) {
  var nom_var = Blockly.JavaScript.valueToCode(block, 'NOM_VAR', Blockly.JavaScript.ORDER_ATOMIC);
  if (nom_var.length != 0) {nom_var=nom_var+"=";}
  var type = Blockly.JavaScript.valueToCode(block, 'TYPE', Blockly.JavaScript.ORDER_ATOMIC);
  var contenu = Blockly.JavaScript.valueToCode(block, 'TEXTE', Blockly.JavaScript.ORDER_ATOMIC);
  var code = nom_var+'createElement('+type+','+contenu+');\n';
  return code;
};
//----------------------
//Objet correspondant à ID
Blockly.JavaScript['objetsWeb_viaID'] = function(block) {
  var nom_ID = Blockly.JavaScript.valueToCode(block, 'ID', Blockly.JavaScript.ORDER_ATOMIC);
  nom_ID = nom_ID.slice(1,-1);
  var code = 'select("#'+nom_ID+'")';
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//******************************************************
//Couleurs
//----------------------
//couleur de fond
Blockly.JavaScript['couleurs_fond'] = function(block) {
  var value_R = Blockly.JavaScript.valueToCode(block, 'R', Blockly.JavaScript.ORDER_ATOMIC);
  var value_G = Blockly.JavaScript.valueToCode(block, 'G', Blockly.JavaScript.ORDER_ATOMIC);
  var value_B = Blockly.JavaScript.valueToCode(block, 'B', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'background('+value_R+','+value_G+','+value_B+');\n';
  return code;
};
//couleur du trait
Blockly.JavaScript['couleurs_trait'] = function(block) {
  var value_R = Blockly.JavaScript.valueToCode(block, 'R', Blockly.JavaScript.ORDER_ATOMIC);
  var value_G = Blockly.JavaScript.valueToCode(block, 'G', Blockly.JavaScript.ORDER_ATOMIC);
  var value_B = Blockly.JavaScript.valueToCode(block, 'B', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'stroke('+value_R+','+value_G+','+value_B+');\n';
  return code;
};
//couleur de remplissage
Blockly.JavaScript['couleurs_remplissage'] = function(block) {
  var value_R = Blockly.JavaScript.valueToCode(block, 'R', Blockly.JavaScript.ORDER_ATOMIC);
  var value_G = Blockly.JavaScript.valueToCode(block, 'G', Blockly.JavaScript.ORDER_ATOMIC);
  var value_B = Blockly.JavaScript.valueToCode(block, 'B', Blockly.JavaScript.ORDER_ATOMIC);
  var value_A = Blockly.JavaScript.valueToCode(block, 'A', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'fill('+value_R+','+value_G+','+value_B+','+value_A+');\n';
  return code;
};
//retourne couleur associée
Blockly.JavaScript['couleurs_couleur'] = function(block) {
  var r = Blockly.JavaScript.valueToCode(block, 'R', Blockly.JavaScript.ORDER_ATOMIC);
  var v = Blockly.JavaScript.valueToCode(block, 'V', Blockly.JavaScript.ORDER_ATOMIC);
  var b = Blockly.JavaScript.valueToCode(block, 'B', Blockly.JavaScript.ORDER_ATOMIC);
  var a = Blockly.JavaScript.valueToCode(block, 'A', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'color('+r+','+v+','+b+','+a+')';
  return [code, Blockly.JavaScript.ORDER_MEMBER]; 
};
//couleur du fond
Blockly.JavaScript['couleurs_fond_C'] = function(block) {
  var c = Blockly.JavaScript.valueToCode(block, 'C', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'background('+c+');'; 
  return code; 
};
//couleur du trait
Blockly.JavaScript['couleurs_trait_C'] = function(block) {
  var c = Blockly.JavaScript.valueToCode(block, 'C', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'stroke('+c+');\n'; 
  return code; 
};
//couleur du remplissage
Blockly.JavaScript['couleurs_remplissage_C'] = function(block) {
  var c = Blockly.JavaScript.valueToCode(block, 'C', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'fill('+c+');\n'; 
  return code; 
};
//Fixer taille crayon
Blockly.JavaScript['couleurs_tailleCrayon'] = function(block) {
  var taille = Blockly.JavaScript.valueToCode(block, 'TAILLE', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'strokeWeight('+taille+');\n'; 
  return code;
};
//******************************************************
//Formes
//----------------------
//Tracer un point
Blockly.JavaScript['formes_point'] = function(block) {
  var x = Blockly.JavaScript.valueToCode(block, 'X', Blockly.JavaScript.ORDER_ATOMIC);
  var y = Blockly.JavaScript.valueToCode(block, 'Y', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'point('+x+','+y+');\n'; 
  return code;
};
//Tracer un segment
Blockly.JavaScript['formes_segment'] = function(block) {
  var x1 = Blockly.JavaScript.valueToCode(block, 'X1', Blockly.JavaScript.ORDER_ATOMIC);
  var y1 = Blockly.JavaScript.valueToCode(block, 'Y1', Blockly.JavaScript.ORDER_ATOMIC);
  var x2 = Blockly.JavaScript.valueToCode(block, 'X2', Blockly.JavaScript.ORDER_ATOMIC);
  var y2 = Blockly.JavaScript.valueToCode(block, 'Y2', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'segment('+x1+','+y1+','+x2+','+y2+');\n'; 
  return code;
};
//tracer triangle de sommets donnés
Blockly.JavaScript['formes_triangle'] = function(block) {
  var x1 = Blockly.JavaScript.valueToCode(block, 'X1', Blockly.JavaScript.ORDER_ATOMIC);
  var y1 = Blockly.JavaScript.valueToCode(block, 'Y1', Blockly.JavaScript.ORDER_ATOMIC);
  var x2 = Blockly.JavaScript.valueToCode(block, 'X2', Blockly.JavaScript.ORDER_ATOMIC);
  var y2 = Blockly.JavaScript.valueToCode(block, 'Y2', Blockly.JavaScript.ORDER_ATOMIC);
  var x3 = Blockly.JavaScript.valueToCode(block, 'X3', Blockly.JavaScript.ORDER_ATOMIC);
  var y3 = Blockly.JavaScript.valueToCode(block, 'Y3', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'triangle('+x1+','+y1+','+x2+','+y2+','+x3+','+y3+');\n'; 
  return code;
};
//Tracer un rectangle
Blockly.JavaScript['formes_rectangle'] = function(block) {
  var x1 = Blockly.JavaScript.valueToCode(block, 'X1', Blockly.JavaScript.ORDER_ATOMIC);
  var y1 = Blockly.JavaScript.valueToCode(block, 'Y1', Blockly.JavaScript.ORDER_ATOMIC);
  var x2 = Blockly.JavaScript.valueToCode(block, 'X2', Blockly.JavaScript.ORDER_ATOMIC);
  var y2 = Blockly.JavaScript.valueToCode(block, 'Y2', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'rect('+x1+','+y1+','+x2+','+y2+');\n'; 
  return code;
};
//----------------------
//Tracer une ellipse
Blockly.JavaScript['formes_ellipse'] = function(block) {
  var x = Blockly.JavaScript.valueToCode(block, 'X', Blockly.JavaScript.ORDER_ATOMIC);
  var y = Blockly.JavaScript.valueToCode(block, 'Y', Blockly.JavaScript.ORDER_ATOMIC);
  var a = Blockly.JavaScript.valueToCode(block, 'A', Blockly.JavaScript.ORDER_ATOMIC);
  var b = Blockly.JavaScript.valueToCode(block, 'B', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'ellipse('+x+','+y+','+a+','+b+');\n'; 
  return code;
};
//----------------------
//Tracer un arc
Blockly.JavaScript['formes_arc'] = function(block) {
  var x = Blockly.JavaScript.valueToCode(block, 'X', Blockly.JavaScript.ORDER_ATOMIC);
  var y = Blockly.JavaScript.valueToCode(block, 'Y', Blockly.JavaScript.ORDER_ATOMIC);
  var a = Blockly.JavaScript.valueToCode(block, 'A', Blockly.JavaScript.ORDER_ATOMIC);
  var b = Blockly.JavaScript.valueToCode(block, 'B', Blockly.JavaScript.ORDER_ATOMIC);
  var debut = Blockly.JavaScript.valueToCode(block, 'DEBUT', Blockly.JavaScript.ORDER_ATOMIC);
  var fin = Blockly.JavaScript.valueToCode(block, 'FIN', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'arc('+x+','+y+','+a+','+b+',radians('+debut+'),radians('+fin+'),OPEN);\n'; 
  return code;
};
//Débuter un polygone
Blockly.JavaScript['formes_debutPoly'] = function(block) {
  var code = 'debutPoly();\n'; 
  return code;
};
//Ajouter un sommet au polygone
Blockly.JavaScript['formes_sommet'] = function(block) {
  var x = Blockly.JavaScript.valueToCode(block, 'X', Blockly.JavaScript.ORDER_ATOMIC);
  var y = Blockly.JavaScript.valueToCode(block, 'Y', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'sommet('+x+','+y+');\n'; 
  return code;
};
//Terminer un polygone
Blockly.JavaScript['formes_finPoly'] = function(block) {
  var code = 'finPoly();\n'; 
  return code;
};
//Translation du systàme de coordonnées
Blockly.JavaScript['formes_translation'] = function(block) {
  var x = Blockly.JavaScript.valueToCode(block, 'X', Blockly.JavaScript.ORDER_ATOMIC);
  var y = Blockly.JavaScript.valueToCode(block, 'Y', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'translate('+x+','+y+');\n'; 
  return code;
};
//******************************************************
//Géométrie de la tortue
//----------------------
//Initialise la tortue
Blockly.JavaScript['tortue_initTortue'] = function(block) {
  var code = 'initTortue();'; 
  return code;
};
//avance(distance)
Blockly.JavaScript['tortue_avance'] = function(block) {
  var value_distance = Blockly.JavaScript.valueToCode(block, 'distance', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'avance('+value_distance+');\n';
  return code;
};
//recule(distance)
Blockly.JavaScript['tortue_recule'] = function(block) {
  var value_distance = Blockly.JavaScript.valueToCode(block, 'distance', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'recule('+value_distance+');\n';
  return code;
};
//droite(angle)
Blockly.JavaScript['tortue_droite'] = function(block) {
  var value_alpha = Blockly.JavaScript.valueToCode(block, 'alpha', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'droite('+value_alpha+');\n';
  return code;
};
//gauche(angle)
Blockly.JavaScript['tortue_gauche'] = function(block) {
  var value_alpha = Blockly.JavaScript.valueToCode(block, 'alpha', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'gauche('+value_alpha+');\n';
  return code;
};
//posX()
Blockly.JavaScript['tortue_posX'] = function(block) {
  var code = 'tortueX';
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//posY()
Blockly.JavaScript['tortue_posY'] = function(block) {
  var code = 'tortueY';
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//fixePos(x,y)
Blockly.JavaScript['tortue_fixePos'] = function(block) {
  var value_x = Blockly.JavaScript.valueToCode(block, 'X', Blockly.JavaScript.ORDER_ATOMIC);
  var value_y = Blockly.JavaScript.valueToCode(block, 'Y', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'fixePos('+value_x+','+value_y+');\n';
  return code;
};
//sautePos(x,y)
Blockly.JavaScript['tortue_sautePos'] = function(block) {
  var value_x = Blockly.JavaScript.valueToCode(block, 'X', Blockly.JavaScript.ORDER_ATOMIC);
  var value_y = Blockly.JavaScript.valueToCode(block, 'Y', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'sautePos('+value_x+','+value_y+');\n';
  return code;
};
//cap()
Blockly.JavaScript['tortue_cap'] = function(block) {
  var code = 'tortueAngle';
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//fixeCap(angle)
Blockly.JavaScript['tortue_fixeCap'] = function(block) {
  var value_alpha = Blockly.JavaScript.valueToCode(block, 'ALPHA', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'fixeCap('+value_alpha+');\n';
  return code;
};
//vers(x,y)
Blockly.JavaScript['tortue_vers'] = function(block) {
  var value_x = Blockly.JavaScript.valueToCode(block, 'X', Blockly.JavaScript.ORDER_ATOMIC);
  var value_y = Blockly.JavaScript.valueToCode(block, 'Y', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'vers('+value_x+','+value_y+')';
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//******************************************************
//Propriétés d'objets web
//----------------------
//valeur de la glissière
Blockly.JavaScript['proprietes_valeur'] = function(block) {
  var value_obj = Blockly.JavaScript.valueToCode(block, 'OBJ', Blockly.JavaScript.ORDER_ATOMIC);
  //var code = 'Number('+value_obj+'.value())'; 
  var code = 'traiterNombre('+value_obj+'.value())';
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//contenu de l'élément
Blockly.JavaScript['proprietes_contenu'] = function(block) {
  var value_obj = Blockly.JavaScript.valueToCode(block, 'OBJ', Blockly.JavaScript.ORDER_ATOMIC);
  var code = value_obj+'.html()'; 
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//état de la case à cocher
Blockly.JavaScript['proprietes_etatCC'] = function(block) {
  var value_obj = Blockly.JavaScript.valueToCode(block, 'OBJ', Blockly.JavaScript.ORDER_ATOMIC);
  var code = value_obj+'.checked()'; 
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
//cacher l'objet
Blockly.JavaScript['proprietes_cacher'] = function(block) {
  var objet = Blockly.JavaScript.valueToCode(block, 'OBJET', Blockly.JavaScript.ORDER_ATOMIC);
  var code = objet+'.hide();\n'; 
  return code;
};
//montrer l'objet
Blockly.JavaScript['proprietes_montrer'] = function(block) {
  var objet = Blockly.JavaScript.valueToCode(block, 'OBJET', Blockly.JavaScript.ORDER_ATOMIC);
  var code = objet+'.show();\n'; 
  return code;
};
//Fixe la valeur (glissière <-- nombre)
Blockly.JavaScript['proprietes_fixeValeur'] = function(block) {
  var obj = Blockly.JavaScript.valueToCode(block, 'OBJET', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur = Blockly.JavaScript.valueToCode(block, 'VALEUR', Blockly.JavaScript.ORDER_ATOMIC);
  var code = obj+'.value('+valeur+');\n'; 
  return code;
};
//Fixe le contenu HTML
Blockly.JavaScript['proprietes_fixeContenu'] = function(block) {
  var obj = Blockly.JavaScript.valueToCode(block, 'OBJET', Blockly.JavaScript.ORDER_ATOMIC);
  var texte = Blockly.JavaScript.valueToCode(block, 'TEXTE', Blockly.JavaScript.ORDER_ATOMIC);
  var code = obj+'.html('+texte+');\n'; 
  return code;
};
//Fixe le contenu d'une zone de texte
Blockly.JavaScript['proprietes_fixeContenuZone'] = function(block) {
  var obj = Blockly.JavaScript.valueToCode(block, 'OBJET', Blockly.JavaScript.ORDER_ATOMIC);
  var contenu = Blockly.JavaScript.valueToCode(block, 'TEXTE', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'contenuZoneTexte('+obj+','+contenu+');\n'; 
  return code;
};
//associe procédure à bouton
Blockly.JavaScript['proprietes_boutonClic'] = function(block) {
  var bouton = Blockly.JavaScript.valueToCode(block, 'VAR_BOUTON', Blockly.JavaScript.ORDER_ATOMIC);
  var proc = Blockly.JavaScript.valueToCode(block, 'PROC', Blockly.JavaScript.ORDER_ATOMIC);
  proc=proc.slice(1,-3);
  var code = bouton+'.mouseClicked('+proc+');\n';
  return code;
};
//associe procédure à changement
Blockly.JavaScript['proprietes_etatChange'] = function(block) {
  var objet = Blockly.JavaScript.valueToCode(block, 'VAR_OBJET', Blockly.JavaScript.ORDER_ATOMIC);
  var proc = Blockly.JavaScript.valueToCode(block, 'PROC', Blockly.JavaScript.ORDER_ATOMIC);
  proc=proc.slice(1,-3);
  var code = objet+'.changed('+proc+');\n'; 
  return code;
};
//associe parent à objet
Blockly.JavaScript['proprietes_parent'] = function(block) {
  var objet = Blockly.JavaScript.valueToCode(block, 'VAR_OBJET', Blockly.JavaScript.ORDER_ATOMIC);
  var id = Blockly.JavaScript.valueToCode(block, 'ID', Blockly.JavaScript.ORDER_ATOMIC);
  id = id.slice(1,-1);
  var code = objet+'.parent("#'+id+'");';  // variable.parent("#nomID");
  return code;
};
//associe parent à objet
Blockly.JavaScript['proprietes_parent2'] = function(block) {
  var objet = Blockly.JavaScript.valueToCode(block, 'VAR_OBJET', Blockly.JavaScript.ORDER_ATOMIC);
  var par = Blockly.JavaScript.valueToCode(block, 'PAR', Blockly.JavaScript.ORDER_ATOMIC);
  var code = objet+'.parent('+par+');\n';
  return code;
};
//style
Blockly.JavaScript['proprietes_style'] = function(block) {
  var objet = Blockly.JavaScript.valueToCode(block, 'OBJET', Blockly.JavaScript.ORDER_ATOMIC);
  var item = Blockly.JavaScript.valueToCode(block, 'ITEM', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur = Blockly.JavaScript.valueToCode(block, 'VALEUR', Blockly.JavaScript.ORDER_ATOMIC);
  var code = objet+'.style('+item+','+valeur+');\n'; 
  return code; 
};
//position absolue
Blockly.JavaScript['proprietes_positionAbs'] = function(block) {
  var objet = Blockly.JavaScript.valueToCode(block, 'OBJET', Blockly.JavaScript.ORDER_ATOMIC);
  var x = Blockly.JavaScript.valueToCode(block, 'X', Blockly.JavaScript.ORDER_ATOMIC);
  var y = Blockly.JavaScript.valueToCode(block, 'Y', Blockly.JavaScript.ORDER_ATOMIC);
  var code = objet+'.position('+x+','+y+');\n'; 
  return code; 
};
// Charger une image
Blockly.JavaScript['image_charger'] = function(block) {
  var valeur1 = Blockly.JavaScript.valueToCode(block, 'nomImage', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'loadImage('+valeur1+')\n'; 
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
// Placer une image
Blockly.JavaScript['image_placer'] = function(block) {
  var valeur1 = Blockly.JavaScript.valueToCode(block, 'nomImage', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur2 = Blockly.JavaScript.valueToCode(block, 'posX', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur3 = Blockly.JavaScript.valueToCode(block, 'posY', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur4 = Blockly.JavaScript.valueToCode(block, 'memeTaille', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'if ('+valeur4+') {image('+valeur1+','+valeur2+','+valeur3+
  					')} else {image('+valeur1+','+valeur2+','+valeur3+',width,height)}\n'; 
  return code;
};
// Retourne la liste pixels
Blockly.JavaScript['image_pixelsDuCanvas'] = function(block) {
  var code = 'pixelsDuCanvas()'; 
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
// Charger les pixels
Blockly.JavaScript['image_chargerPixels'] = function(block) {
  var code = 'loadPixels();\n'; 
  return code;
};
// Modifier les pixels
Blockly.JavaScript['image_modifier'] = function(block) {
  var valeur1 = Blockly.JavaScript.valueToCode(block, 'pixelsCanvas', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'updatePixels();\n'; 
  return code;
};
// Obtenir valeur d'une composante de pixel
Blockly.JavaScript['image_obtenirPixel'] = function(block) {
  var valeur1 = Blockly.JavaScript.valueToCode(block, 'bloc', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur2 = Blockly.JavaScript.valueToCode(block, 'ligne', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur3 = Blockly.JavaScript.valueToCode(block, 'colonne', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur4 = Blockly.JavaScript.valueToCode(block, 'composante', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'obtenirPixel('+valeur1+','+valeur2+','+valeur3+','+valeur4+')'; 
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
// Définir valeur d'une composante de pixel
Blockly.JavaScript['image_definirPixel'] = function(block) {
  var valeur1 = Blockly.JavaScript.valueToCode(block, 'bloc', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur2 = Blockly.JavaScript.valueToCode(block, 'ligne', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur3 = Blockly.JavaScript.valueToCode(block, 'colonne', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur4 = Blockly.JavaScript.valueToCode(block, 'composante', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur5 = Blockly.JavaScript.valueToCode(block, 'valeur', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'definirPixel('+valeur1+','+valeur2+','+valeur3+','+valeur4+','+valeur5+');\n'; 
  return code;
};
// Dépôt d'une image dans le canvas
Blockly.JavaScript['image_depot'] = function(block) {
  var valeur1 = Blockly.JavaScript.valueToCode(block, 'nomFonction', Blockly.JavaScript.ORDER_ATOMIC);
  var code = 'depotImageDansCanvas('+enleverParentheses(valeur1)+');\n'; 
  return code;
};
// Charger une vidéo
Blockly.JavaScript['video_charger'] = function(block) {
  var valeur1 = Blockly.JavaScript.valueToCode(block, 'nomVideo', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur2 = Blockly.JavaScript.valueToCode(block, 'fonction', Blockly.JavaScript.ORDER_ATOMIC);
  valeur2 = valeur2.slice(1,-3);
  var code = 'createVideo('+valeur1+','+valeur2+');\n'; 
  return [code, Blockly.JavaScript.ORDER_MEMBER];
};
// Vidéo en marche
Blockly.JavaScript['video_marche'] = function(block) {
  var valeur1 = Blockly.JavaScript.valueToCode(block, 'objetVideo', Blockly.JavaScript.ORDER_ATOMIC);
  var code = valeur1+'.play();\n'; 
  return code;
};
// Vidéo en pause
Blockly.JavaScript['video_pause'] = function(block) {
  var valeur1 = Blockly.JavaScript.valueToCode(block, 'objetVideo', Blockly.JavaScript.ORDER_ATOMIC);
  var code = valeur1+'.pause();\n'; 
  return code;
};
// Fixer temps de la vidéo
Blockly.JavaScript['video_fixePos'] = function(block) {
  var valeur1 = Blockly.JavaScript.valueToCode(block, 'objetVideo', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur2 = Blockly.JavaScript.valueToCode(block, 'temps', Blockly.JavaScript.ORDER_ATOMIC);
  var code = valeur1+'.time('+valeur2+');\n'; 
  return code;
};
// Action vidéo au temps donné
Blockly.JavaScript['video_signal'] = function(block) {
  var valeur1 = Blockly.JavaScript.valueToCode(block, 'action', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur2 = Blockly.JavaScript.valueToCode(block, 'param', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur3 = Blockly.JavaScript.valueToCode(block, 'temps', Blockly.JavaScript.ORDER_ATOMIC);
  var valeur4 = Blockly.JavaScript.valueToCode(block, 'objetVideo', Blockly.JavaScript.ORDER_ATOMIC);
  valeur1=enleverParentheses(valeur1); //valeur1 = valeur1.slice(1,-3);
  var code = valeur4+'.addCue('+valeur3+','+valeur1+','+valeur2+');\n'; 
  return code;
};

function enleverParentheses(liste) {
	liste = liste.slice(1,-1);
	var pos = liste.indexOf('(');
	return liste.slice(0,pos);
}