#declare numerofilm = 4; // 4 films

global_settings {max_trace_level 25}

light_source
        {<0, 2, 0>
        color rgb <1, 1, 1>}
light_source
        {<0, 0, -5>
        color rgb <1, 1, 1>}
light_source
        {<0, 0, 5>
        color rgb <1, 1, 1>}        
light_source
        {<3, 2, -2>
        color rgb <1, 1, 1>}

#if (numerofilm <=2 ) 
        camera{location <0, 0, -5>       
               look_at <0.0, 0.0, 0.0>}
#else
        #if(numerofilm=3)
                camera {location <2*clock,2*clock,3*clock-5> 
                        look_at <0.0, 0.0, 0.0>}
        #else
                camera{location <2,2,-2> 
                       rotate <0.0, -180*clock, 0.0> 
                       look_at <0.0, 0.0, 0.0>}
        #end
#end

background { color rgb <0,0,0>}
plane {y, -sqrt(3)-0.03 pigment {color rgbt <0.58, 0.42, 0.20>}} 

#declare gold = texture {pigment {color rgbt <1.00, 0.87, 0.475,0>}
finish {
    ambient 0.30
    brilliance 3
    diffuse 0.4
    metallic
    specular 0.2
    roughness 1/60}};

#declare bronze = texture {pigment {color rgbt <0.58, 0.42, 0.20>} 
finish {
    ambient 0.25
    brilliance 3
    diffuse 0.4
    metallic
    specular 0.20
    roughness 1/60}};
    
#declare rayon2 = 0.02;
#declare Coin=(sqrt(3)/3);               

#if (numerofilm = 1)
        #declare rayon = 0;
#else 
        #if (numerofilm = 2)         
                #declare rayon = 0.03*clock;
        #else
                #declare rayon = 0.03;
        #end   
#end

#if (numerofilm=1)
        #declare A = <-Coin, Coin, Coin>;
        #declare B = <Coin, Coin, Coin>;
        #declare C1 = <-2*Coin*clock+3*Coin, Coin, -2*Coin*clock+Coin>;
        #declare C2 = <Coin, -2*Coin*clock+3*Coin, -2*Coin*clock+Coin>;
        #declare D1 = <2*Coin*clock-3*Coin, Coin, -2*Coin*clock+Coin>;
        #declare D2 = <-6*Coin*clock+5*Coin, Coin, -2*Coin*clock+Coin>; 
        #declare D3 = <-Coin, -2*Coin*clock+3*Coin,-2*Coin*clock+Coin>;
        #declare E1 = <2*Coin*clock-3*Coin, -Coin, -2*Coin*clock+Coin>;
        #declare E2 = <-6*Coin*clock+5*Coin, -Coin, -2*Coin*clock+Coin>; 
        #declare E3 = <-Coin, 2*Coin*clock-3*Coin, -2*Coin*clock+Coin>;
        #declare F1 = <-2*Coin*clock+3*Coin, -Coin, -2*Coin*clock+Coin>;
        #declare F2 = <Coin, 2*Coin*clock-3*Coin, -2*Coin*clock+Coin>;
        #declare G = <Coin, -Coin, Coin>;
        #declare H = <-Coin, -Coin, Coin>; 

#else
        #declare A = <-Coin, Coin, Coin>;
        #declare B = <Coin, Coin, Coin>;
        #declare C1 = <Coin, Coin, -Coin>;
        #declare C2 = <Coin, Coin, -Coin>;
        #declare D1 = <-Coin, Coin, -Coin>;
        #declare D2 = <-Coin, Coin, -Coin>; 
        #declare D3 = <-Coin, Coin, -Coin>;
        #declare E1 = <-Coin, -Coin, -Coin>;
        #declare E2 = <-Coin, -Coin, -Coin>; 
        #declare E3 = <-Coin, -Coin, -Coin>;
        #declare F1 = <Coin,  -Coin, -Coin>;
        #declare F2 = <Coin, -Coin, -Coin>;
        #declare G = <Coin, -Coin, Coin>;
        #declare H = <-Coin, -Coin, Coin>; 
#end

#declare DEVL = object
{union {
        polygon { 5, D1, A, H, E1, D1}
        polygon { 5, A, B, G, H, A}
        polygon { 5, B, C1, F1, F1, G}
        polygon { 5, C1, D2, E2, F1, C1}             
        polygon { 5, D3,C2, B, A, D3}
        polygon { 5, H, G, F2, E3, H}
         texture {gold}}}
               
#declare ACUBE = object
{union {
        cylinder { D1,A, rayon2} 
        cylinder { A, B, rayon2}         
        cylinder { B, C1, rayon2}        
        cylinder { C1,D2, rayon2}   
        cylinder { D2,E2, rayon2} 
        cylinder { E2,F1, rayon2}   
        cylinder { F1,G, rayon2}      
        cylinder { G, H, rayon2}
        cylinder { H, E1, rayon2}  
        cylinder { D1,E1, rayon2}     
        cylinder { A,D3, rayon2}    
        cylinder { D3,C2, rayon2}
        cylinder { C2,B, rayon2} 
        cylinder { H,E3, rayon2} 
        cylinder { E3,F2, rayon2} 
        cylinder { F2,G, rayon2}
        cylinder { A,H, rayon2}
        cylinder { B,G, rayon2}
        cylinder { C1,F1, rayon2}
        cylinder { F2,G, rayon2}
         texture {bronze}}}

#declare SCUBE = object
{union {
        sphere { A, rayon} 
        sphere { B, rayon}         
        sphere { C1, rayon}        
        sphere { D1, rayon}   
        sphere { E1, rayon} 
        sphere { F1, rayon}   
        sphere { G, rayon}      
        sphere { H, rayon}
         texture {bronze}}}
   
DEVL
ACUBE
SCUBE











 



 

  


