#declare numerofilm = 3; // 3 films

global_settings {max_trace_level 25}

light_source
        {<0, 0, 5>
        color rgb <1, 1, 1>}
light_source
        {<0, 0, -5>
        color rgb <1, 1, 1>}        
light_source
        {<0, 5, 0>
        color rgb <1, 1, 1>}
light_source
        {<5, 4, 5>
        color rgb <1, 1, 1>}

#if (numerofilm =1)
        camera{location <0,0,8*clock-13>
               look_at <0.0, 0.0, 0.0>}
#else 
        #if(numerofilm=2)
                camera{ location <0,0,-5>
                        look_at <0.0, 0.0, 0.0>}
        #else
                camera{ location <0,0,-5>
                        rotate <0.0, -180*clock, 0.0> 
                        look_at <0.0, 0.0, 0.0>}
        #end
#end

background { color rgb <0,0,0> }
plane {y, -5.2 pigment {color rgbt <0.58, 0.42, 0.20>}} 

#declare gold = texture {pigment {color rgbt <1.00, 0.87, 0.475,0>}
finish {
    ambient 0.30
    brilliance 3
    diffuse 0.4
    metallic
    specular 0.2
    roughness 1/60}};

#declare bronze = texture {pigment {color rgbt <0.58, 0.42, 0.20>} 
finish {
    ambient 0.25
    brilliance 3
    diffuse 0.4
    metallic
    specular 0.20
    roughness 1/60}};

#declare rayon2 = 0.02;
#declare OR = ((sqrt(5)+1)/2);

#if(numerofilm =1)
        #declare A = <(OR-2)*clock+2,(1-sqrt(3))*clock+sqrt(3), -OR*clock+OR>;
        #declare B1 = <(OR-3)*clock+3,-clock+0,-OR*clock+OR>;
        #declare B2 = <(OR-2)*clock+2, (-1+sqrt(3))*clock-sqrt(3), -OR*clock+OR>;
        #declare C = <(-OR+2)*clock-2,(1-sqrt(3))*clock+sqrt(3),-OR*clock+OR>;
        #declare D1 = <(-OR+3)*clock-3,-clock+0,-OR*clock+OR>;
        #declare D2 = <(-OR+2)*clock-2, (-1+sqrt(3))*clock-sqrt(3),-OR*clock+OR>;
        #declare E = <1,0,OR>;
        #declare F1 = <-2*clock+3,-2*sqrt(3)*clock+2*sqrt(3), -2*OR*clock+OR>;
        #declare F2 = <-3*clock+4,-sqrt(3)*clock+sqrt(3),-2*OR*clock+OR>;
        #declare F3 = <-2*clock+3,2*sqrt(3)*clock-2*sqrt(3), -2*OR*clock+OR>;
        #declare F4 = <3*clock-2, 3*sqrt(3)*clock-3*sqrt(3), -2*OR*clock+OR>; 
        #declare G = <-1,0,OR>;
        #declare H1 = <3*clock-4,-sqrt(3)*clock+sqrt(3),-2*OR*clock+OR>;
        #declare H2 = <2*clock-3,-2*sqrt(3)*clock+2*sqrt(3), -2*OR*clock+OR>;
        #declare H3 = <-3*clock+2,-3*sqrt(3)*clock+3*sqrt(3), -2*OR*clock+OR>;
        #declare H4 = <2*clock-3, 2*sqrt(3)*clock-2*sqrt(3), -2*OR*clock+OR>;
        #declare I = <0,(OR-sqrt(3))*clock+sqrt(3),(1-OR)*clock+OR>;
        #declare J1 = <clock-1, (OR-2*sqrt(3))*clock+2*sqrt(3), (-1-OR)*clock+OR>;
        #declare J2 = <-clock+1, (OR-2*sqrt(3))*clock+2*sqrt(3), (-1-OR)*clock+OR>;
        #declare K = <0,(-OR+sqrt(3))*clock-sqrt(3), (1-OR)*clock+OR>;
        #declare L1 = <clock-1, (-OR+2*sqrt(3))*clock-2*sqrt(3), (-1-OR)*clock+OR>; 
        #declare L2 = <-clock+1, (-OR+2*sqrt(3))*clock-2*sqrt(3), (-1-OR)*clock+OR>; 
#else
        #declare A = <OR,1,0>;
        #declare B1 = <OR,-1,0>;
        #declare B2 = <OR,-1,0>;
        #declare C = <-OR,1,0>;
        #declare D1 = <-OR,-1,0>;
        #declare D2 = <-OR,-1,0>;
        #declare E = <1,0,OR>;
        #declare F1 = <1,0,-OR>;
        #declare F2 = <1,0,-OR>;
        #declare F3 = <1,0,-OR>;
        #declare F4 = <1,0,-OR>; 
        #declare G = <-1,0,OR>;
        #declare H1 = <-1,0,-OR>;
        #declare H2 = <-1,0,-OR>;
        #declare H3 = <-1,0,-OR>;
        #declare H4 = <-1,0,-OR>;
        #declare I = <0, OR, 1>;
        #declare J1 = <0, OR, -1>;
        #declare J2 = <0, OR, -1>;
        #declare K = <0, -OR, 1>;
        #declare L1 = <0, -OR, -1>;
        #declare L2 = <0, -OR, -1>; 
#end

#declare DEVL = object
{union {
        polygon { 4, J2, H3, F1, J2}
        polygon { 4, C,H2, J1, C} 
        polygon { 4, I, C,  J1, I}
        polygon { 4, I, J2, A, I}
        polygon { 4, A, J2, F1, A}
        polygon { 4, D1, H1,C,D1}
        polygon { 4, D1, C, G, D1}
        polygon { 4, G, C, I, G}
        polygon { 4, G, I, E, G}
        polygon { 4, E, I, A, E }
        polygon { 4, E, A, B1,E}
        polygon { 4, B1, A, F2, B1}
        polygon { 4, D2, G, K, D2}
        polygon { 4, K, G, E, K}
        polygon { 4, K, E, B2, K}
        polygon { 4, H4, D2, L1, H4}
        polygon { 4, L1, D2, K, L1}
        polygon { 4, L2, K, B2, L2}
        polygon { 4, L2, B2, F3,L2}
        polygon { 4, F4, H4, L1, F4}
         texture {gold}}}

#declare AICO = object
{union {
        cylinder { H2,J1, rayon2} 
        cylinder { J2, F1, rayon2}         
        cylinder { H1,C, rayon2}        
        cylinder { C,I, rayon2}   
        cylinder { I,A, rayon2} 
        cylinder { A,F2, rayon2}   
        cylinder { D1,G, rayon2}      
        cylinder { G, E, rayon2}
        cylinder { E,B1, rayon2}  
        cylinder { D2,K, rayon2}     
        cylinder { K,B2, rayon2}    
        cylinder { H4,L1, rayon2}
        cylinder { L2,F3, rayon2} 
        cylinder { D1,C, rayon2} 
        cylinder { C,J1, rayon2} 
        cylinder { H4,D2, rayon2}
        cylinder { D2,G, rayon2}
        cylinder { G,I, rayon2}
        cylinder { I,J2, rayon2}
        cylinder { J2,H3, rayon2}
        cylinder { F4,L1, rayon2} 
        cylinder { L1,K, rayon2}         
        cylinder { K,E, rayon2}        
        cylinder { E,A, rayon2}   
        cylinder { A,F1, rayon2} 
        cylinder { L2,B2, rayon2}   
        cylinder { B1,F2, rayon2}      
        cylinder { H4,F4, rayon2}
        cylinder { L1,D2, rayon2}  
        cylinder { D1,H1, rayon2}     
        cylinder { L2,K, rayon2}    
        cylinder { K,G, rayon2}
        cylinder { G,C, rayon2} 
        cylinder { C,H2, rayon2} 
        cylinder { F3,B2, rayon2} 
        cylinder { B2,E, rayon2}
        cylinder { E,I, rayon2}
        cylinder { I,J1, rayon2}
        cylinder { B1,A, rayon2}
        cylinder { A, J2, rayon2} 
        cylinder { F1,H3, rayon2}         
         texture {bronze}}}

#if (numerofilm = 1)
        #declare rayon = 0;
#else 
        #if (numerofilm = 2)         
                #declare rayon = 0.04*clock;
        #else
                #declare rayon = 0.04;
        #end   
#end
         
#declare SICO = object
{union {
        sphere { A, rayon} 
        sphere { B1, rayon}         
        sphere { C, rayon}        
        sphere { D1, rayon}   
        sphere { E, rayon} 
        sphere { F1, rayon}   
        sphere { G, rayon}      
        sphere { H1, rayon}
        sphere { I, rayon}
        sphere { J1, rayon}
        sphere { K, rayon}
        sphere { L1, rayon}
        texture {bronze}}}         
      
DEVL
AICO
SICO