#declare numerofilm = 3; // 3 films

global_settings {max_trace_level 25}

light_source
        {<0, 2, 0>
        color rgb <1, 1, 1>}
light_source
        {<0, 0, -5>
        color rgb <1, 1, 1>}
light_source
        {<0, 0, 5>
        color rgb <1, 1, 1>}        
light_source
        {<3, 2, -2>
        color rgb <1, 1, 1>}

#if(numerofilm=1)
        camera{location <0.5*clock,clock,5*clock-8> 
               look_at  <0,0, 0>} 
#else 
        #if(numerofilm=2)
                camera{location <0.5,1,-3> 
                       look_at  <0,0, 0>}
        #else
                camera{location <0.5,1,-3>
                        rotate <0.0, -180*clock, 0.0> 
                       look_at  <0,0, 0>}
        #end
#end

background { color rgb <0,0,0> }
plane {y, -sqrt(3)-0.03 pigment {color rgbt <0.58, 0.42, 0.20>}}

#declare gold = texture {pigment {color rgbt <1.00, 0.87, 0.475,0>}
finish {
    ambient 0.30
    brilliance 3
    diffuse 0.4
    metallic
    specular 0.2
    roughness 1/60}};

#declare bronze = texture {pigment {color rgbt <0.58, 0.42, 0.20>} 
finish {
    ambient 0.25
    brilliance 3
    diffuse 0.4
    metallic
    specular 0.20
    roughness 1/60}};

#declare rayon2 = 0.02;
#declare hauteur = sqrt(3);
       
#if(numerofilm=1)      
        #declare A1 = <3*clock-3, (1-hauteur)*clock+hauteur, 0>;
        #declare A2 = <-3*clock+3, (1-hauteur)*clock+hauteur, 0>;
        #declare A3 = <-3*clock+3, (1+hauteur)*clock-hauteur,0>;
        #declare B = <-clock+1,-hauteur*clock+hauteur,clock>;
        #declare C = <0,-clock,0>;
        #declare D1 = <2*clock-2,0,-clock>;
        #declare D2 =<-clock+1, hauteur*clock-hauteur, -clock>;
        #declare E = <-clock+2,0,0>;
        #declare F1 = <-1, -hauteur*clock+hauteur,0>;
        #declare F2 = <-3*clock+2, -2*hauteur*clock+2*hauteur,0>;
#else
        #declare A1 = <0, 1, 0>;
        #declare A2 = <0, 1, 0>;
        #declare A3 = <0, 1, 0>;
        #declare B = <0, 0, 1>;
        #declare C = <0, -1, 0>;
        #declare D1 = <0, 0, -1>;
        #declare D2 =<0, 0, -1>;
        #declare E = <1, 0, 0>;
        #declare F1 = <-1, 0, 0>;
        #declare F2 = <-1, 0, 0>;
#end

#declare DEVL = object
{union { 
        polygon { 4, A3,D2, E, A3}
        polygon { 4, A2, B, E, A2}
        polygon { 4, A2, F2, B, A2}
        polygon { 4, F1, A1, D1, F1}
        polygon { 4, C, F1, D1, C}
        polygon { 4, E, C, D2, E}
        polygon { 4, E, B, C, E}
        polygon { 4, B, F1, C, B}
         texture {gold}}}      

#declare AOCTA = object
{union {
        cylinder { A1,F1, rayon2} 
        cylinder { F1,B, rayon2}         
        cylinder { B,A2, rayon2}        
        cylinder { B,F2, rayon2}   
        cylinder { F2,A2, rayon2} 
        cylinder { A1,D1, rayon2}   
        cylinder { D1,C, rayon2}      
        cylinder { C,E, rayon2}
        cylinder { E,A2, rayon2}  
        cylinder { D1,F1, rayon2}     
        cylinder { F1,C, rayon2}    
        cylinder { C,B, rayon2}
        cylinder { B,E, rayon2} 
        cylinder { C,D2, rayon2} 
        cylinder { D2,E, rayon2} 
        cylinder { E,A3, rayon2}
        cylinder { D2,A3, rayon2}
         texture {bronze}}}

#if (numerofilm = 1)
        #declare rayon = 0;
#else 
        #if (numerofilm = 2)         
                #declare rayon = 0.04*clock;
        #else
                #declare rayon = 0.04;
        #end   
#end

#declare SOCTA = object
{union {
        sphere { A1, rayon} 
        sphere { B, rayon}         
        sphere { C, rayon}        
        sphere { D1, rayon}   
        sphere { E, rayon} 
        sphere { F1, rayon}   
         texture {bronze}}}         

DEVL
AOCTA
SOCTA