#declare numerofilm = 1; // 3 films

global_settings {max_trace_level 25}
#include "math.inc"

light_source
        {<0,-2, -10>
        color rgb <1, 1, 1>}
light_source
        {<0,-2, 10>
        color rgb <1, 1, 1>}
light_source
        {<0,10, 0>
        color rgb <1, 1, 1>}

#declare rayon2 = 0.06;
#declare OR = (sqrt(5)+1)/2;
#declare cote = 2*OR;
#declare largeur = 2*cote*cosd(36);
#declare hauteur = cote*sind(72);
#declare haut = cote*sind(36);

#if (numerofilm = 1)
        light_source 
        {<0, ((-(-hauteur-haut)/2))*clock+((-hauteur-haut)/2), -25> 
        color rgb <1, 1, 1>}
#else
        light_source
        {<0, ((-(-hauteur-haut)/2))+((-hauteur-haut)/2), -25> 
        color rgb <1, 1, 1>}
#end      

#if (numerofilm =1)       
        camera{ location <0,(-hauteur-haut)/2,8*clock-22>    
                look_at <0.0, ((hauteur+haut)/2)*clock+(-hauteur-haut)/2 , 0.0>}
#else
        #if (numerofilm = 3)
                camera{ location <0,(-hauteur-haut)/2,-14>    
                        rotate <0,180*clock,0>
                        look_at <0.0, ((hauteur+haut)/2)+(-hauteur-haut)/2 , 0.0>}
        #else
                camera{ location <0,(-hauteur-haut)/2,-14>    
                        look_at <0.0, ((hauteur+haut)/2)+(-hauteur-haut)/2 , 0.0>}
        
        #end
#end

background { color rgb <0,0,0> }
plane {y, -3*hauteur-2*haut-0.05 pigment {color rgbt <0.58, 0.42, 0.20>}}

#declare gold = texture {pigment {color rgbt <1.00, 0.87, 0.475,0>}
finish {
    ambient 0.30
    brilliance 3
    diffuse 0.4
    metallic
    specular 0.2
    roughness 1/60}};

#declare bronze = texture {pigment {color rgbt <0.58, 0.42, 0.20>} 
finish {
    ambient 0.25
    brilliance 3
    diffuse 0.4
    metallic
    specular 0.20
    roughness 1/60}}; 

#if (numerofilm = 1)
        #declare A = <((OR+1)-largeur/2)*clock+largeur/2, (OR+1+hauteur)*clock-hauteur,(OR+1-OR)*clock+OR>;
        #declare B = <(OR-cote/2)*clock+cote/2,(2*OR+1)*clock,-OR*clock+OR>;
        #declare C = <(-OR+cote/2)*clock-cote/2, (2*OR+1)*clock, -OR*clock+OR>;
        #declare D = <(-OR-1+largeur/2)*clock-largeur/2, (OR+1+hauteur)*clock-hauteur,(OR+1-OR)*clock+OR>;
        #declare E = <0,(OR+haut+hauteur)*clock-haut-hauteur,(2*OR+1-OR)*clock+OR>;
        #declare F1 = <(-OR-1+largeur/2)*clock-largeur/2, (OR+1-hauteur)*clock+hauteur,(-OR-1-OR)*clock+OR>;
        #declare F2 = <(-OR-1+cote/2+largeur/2)*clock-cote/2-largeur/2, (OR+1-haut)*clock+haut, (-OR-1-OR)*clock+OR>;
        #declare G1 = <0,(OR-haut-hauteur)*clock+haut+hauteur,(-2*OR-1-OR)*clock+OR>;
        #declare G2 = <-largeur*clock+largeur, (OR-haut-hauteur)*clock+haut+hauteur, (-2*OR-1-OR)*clock+OR>;
        #declare G3 = <largeur*clock-largeur, (OR-haut-hauteur)*clock+haut+hauteur, (-2*OR-1-OR)*clock+OR>;
        #declare H1 = <(OR+1-largeur/2)*clock+largeur/2, (OR+1-hauteur)*clock+hauteur,(-OR-1-OR)*clock+OR>;
        #declare H2 = <(OR+1-cote/2-largeur/2)*clock+cote/2+largeur/2, (OR+1-haut)*clock+haut, (-OR-1-OR)*clock+OR>;
        #declare I1 = <(2*OR+1-cote/2-largeur)*clock+cote/2+largeur, 0, (-OR-OR)*clock+OR>;
        #declare I2 = <(2*OR+1-largeur-cote)*clock+largeur+cote,(hauteur+haut)*clock-hauteur-haut,  (-OR-OR)*clock+OR>;
        #declare J1 = <(2*OR+1-largeur/2-cote)*clock+largeur/2+cote, hauteur*clock-hauteur, OR>;
        #declare J2 = <(2*OR+1-largeur)*clock+largeur,(hauteur+haut)*clock-hauteur-haut, OR>;
        #declare L1 = <(-2*OR-1+cote/2+largeur)*clock-cote/2-largeur, 0, (-OR-OR)*clock+OR>;
        #declare M1 = <(-2*OR-1+largeur/2+cote)*clock-largeur/2-cote, hauteur*clock-hauteur, OR>;
        #declare M2 = <(-2*OR-1+largeur)*clock-largeur,(hauteur+haut)*clock-hauteur-haut, OR>;
        #declare N1 = <(-OR-1+cote/2+largeur/2)*clock-cote/2-largeur/2, (-OR-1+2*hauteur+haut)*clock-2*hauteur-haut, (OR+1-OR)*clock+OR>;
        #declare N2 = <(-OR-1+largeur+cote)*clock-largeur-cote, (-OR-1+hauteur+haut)*clock-hauteur-haut, (OR+1-OR)*clock+OR>;
        #declare O1 = <(-cote/2+largeur/2)*clock+cote/2-largeur/2, (-OR+2*hauteur+haut)*clock-2*hauteur-haut, (2*OR+1-OR)*clock+OR>;
        #declare O2 = <(cote/2-largeur/2)*clock-cote/2+largeur/2, (-OR+2*hauteur+haut)*clock-2*hauteur-haut, (2*OR+1-OR)*clock+OR>;
        #declare P1 = <(OR+1-cote/2-largeur/2)*clock+cote/2+largeur/2, (-OR-1+2*hauteur+haut)*clock-2*hauteur-haut, (OR+1-OR)*clock+OR>;
        #declare P2 = <(OR+1)*clock,(-OR-1+3*hauteur+haut)*clock-3*hauteur-haut, (OR+1-OR)*clock+OR>;
        #declare Q1 = <(-OR-1+(3*largeur/2)+cote/2)*clock-(3*largeur/2)-cote/2, (-OR-1-haut)*clock+haut, (-OR-1-OR)*clock+OR>;
        #declare Q2 = <(-OR-1+(3*cote/2)+largeur)*clock-(3*cote/2)-largeur, (-OR-1)*clock, (-OR-1-OR)*clock+OR>;
        #declare Q3 = <(-OR-1-(3*largeur/2+cote))*clock+(3*largeur/2)+cote, (-OR-1+3*hauteur+2*haut)*clock-3*hauteur-2*haut, (-OR-1-OR)*clock+OR>;
        #declare R1 = <(-OR-(3*largeur/2))*clock+3*largeur/2, (-2*OR-1+3*hauteur+2*haut)*clock-3*hauteur-2*haut,(-OR)*clock+OR>; 
        #declare R2 = <(-OR+(3*largeur/2)+cote)*clock-(3*largeur/2)-cote, (-2*OR-1+hauteur)*clock-hauteur, (-OR)*clock+OR>;
        #declare R3 = <(-OR+largeur)*clock-largeur,(-2*OR-1+3*hauteur+haut)*clock-3*hauteur-haut, (-OR)*clock+OR>;
        #declare S1 = <(OR+largeur/2)*clock-largeur/2, (-2*OR-1+3*hauteur+2*haut)*clock-3*hauteur-2*haut, (-OR)*clock+OR>;
        #declare S2 = <(OR-cote/2-largeur)*clock+cote/2+largeur, (-2*OR-1+2*hauteur+2*haut)*clock-2*hauteur-2*haut, (-OR)*clock+OR>;
        #declare T1 = <(OR+1-cote/2-3*largeur/2)*clock+cote/2+3*largeur/2, (-OR-1+2*hauteur+haut)*clock-2*hauteur-haut, (-OR-1-OR)*clock+OR>;
        #declare T2 = <(OR+1-cote/2-3*largeur/2)*clock+cote/2+3*largeur/2, (-OR-1-haut)*clock+haut, (-OR-1-OR)*clock+OR>;
        #declare U1 = <(largeur+cote)*clock-largeur-cote, (-OR-hauteur-haut)*clock+hauteur+haut, (-2*OR-1-OR)*clock+OR>; 
        #declare U2 = <(-largeur-cote)*clock+largeur+cote, (-OR-haut-hauteur)*clock+haut+hauteur, (-2*OR-1-OR)*clock+OR>;
        #declare U3 = <(-cote/2-2*largeur)*clock+(cote/2)+2*largeur, (-OR+2*hauteur+2*haut)*clock-2*hauteur-2*haut, (-2*OR-1-OR)*clock+OR>;
#else        
        #declare A = <OR+1, OR+1, OR+1>;
        #declare B = <OR, 2*OR+1, 0>;
        #declare C = <-OR, 2*OR+1, 0>;
        #declare D = <-OR-1, OR+1, OR+1>;
        #declare E = <0, OR, 2*OR+1>;
        #declare F1 = <-OR-1, OR+1, -OR-1>;
        #declare F2 = <-OR-1, OR+1, -OR-1>;
        #declare G1 = <0, OR, -2*OR-1>;
        #declare G2 = <0, OR, -2*OR-1>;
        #declare G3 = <0, OR, -2*OR-1>;
        #declare H1 = <OR+1, OR+1, -OR-1>;
        #declare H2 = <OR+1, OR+1, -OR-1>;
        #declare I1 = <2*OR+1, 0, -OR>;
        #declare I2 = <2*OR+1, 0, -OR>;
        #declare J1 = <2*OR+1, 0, OR>;
        #declare J2 = <2*OR+1, 0, OR>;
        #declare L1 = <-2*OR-1, 0, -OR>;
        #declare L2 = <-2*OR-1, 0, -OR>;
        #declare M1 = <-2*OR-1, 0, OR>;
        #declare M2 = <-2*OR-1, 0, OR>;
        #declare N1 = <-OR-1, -OR-1, OR+1>;
        #declare N2 = <-OR-1, -OR-1, OR+1>;
        #declare O1 = <0, -OR, 2*OR+1>;
        #declare O2 = <0, -OR, 2*OR+1>;
        #declare P1 = <OR+1, -OR-1, OR+1>;
        #declare P2 = <OR+1, -OR-1, OR+1>;
        #declare Q1 = <-OR-1, -OR-1, -OR-1>;
        #declare Q2 = <-OR-1, -OR-1, -OR-1>;
        #declare Q3 = <-OR-1, -OR-1, -OR-1>;
        #declare R1 = <-OR, -2*OR-1, 0>;
        #declare R2 = <-OR, -2*OR-1, 0>;
        #declare R3 = <-OR, -2*OR-1, 0>;
        #declare S1 = <OR, -2*OR-1, 0>;
        #declare S2 = <OR, -2*OR-1, 0>;
        #declare T1 = <OR+1, -OR-1, -OR-1>;
        #declare T2 = <OR+1, -OR-1, -OR-1>;
        #declare U1 = <0, -OR, -2*OR-1>;
        #declare U2 = <0, -OR, -2*OR-1>;
        #declare U3 = <0, -OR, -2*OR-1>;
#end        
      
#declare DEVL = object
{union {
        polygon { 6, A, B, C, D, E, A}
        polygon { 6, H1, G1, F1, C, B, H1}
        polygon { 6, B, H2, I1, J1, A, B}
        polygon { 6, C, F2, L1, M1, D, C}
        polygon { 6, D, E, O1, N1, M2, D}
        polygon { 6, E, A, J2,P1, O2, E}
        polygon { 6, L1, Q1, U1, G3, F2, L1}
        polygon { 6, S2, T1, U3, Q3, R1, S2}
        polygon { 6, L1, Q2, R2, N2, M1, L1}
        polygon { 6, N1, R3, S1, P2, O1, N1}
        polygon { 6, P1, J2, I2, T1, S2, P1}
        polygon { 6,H2, G2, U2, T2, I1, H2}
         texture {gold}}} 
                
#declare ADODE = object
{union {
        cylinder { S2, R1, rayon2} 
        cylinder { R1,Q3, rayon2}         
        cylinder { Q3,U3 rayon2}        
        cylinder { U3,T1, rayon2}   
        cylinder { U1,Q1, rayon2} 
        cylinder { U1,G3 rayon2}   
        cylinder { G1,F1, rayon2}      
        cylinder { L1, Q1, rayon2}
        cylinder { F2, G3, rayon2}
        cylinder { G1,H1, rayon2}     
        cylinder { H1,B, rayon2}    
        cylinder { B,C, rayon2}
        cylinder { C,F1, rayon2}
        cylinder { M1,N2, rayon2} 
        cylinder { N2,R2, rayon2} 
        cylinder { R2,Q2, rayon2}
        cylinder { Q2,L1, rayon2}
        cylinder { L1,M1, rayon2}
        cylinder { L1,F2, rayon2}   
        cylinder { F2,C, rayon2}      
        cylinder { C,D, rayon2}
        cylinder { D,M1, rayon2}
        cylinder { H2,G2, rayon2}     
        cylinder { G2,U2, rayon2}    
        cylinder { U2,T2, rayon2}
        cylinder { T2,I1, rayon2}
        cylinder { I1,H2, rayon2}
        cylinder { H2,B, rayon2}   
        cylinder { B,A, rayon2}      
        cylinder { A,J1, rayon2}
        cylinder { J1,I1, rayon2}
        cylinder { J2,I2, rayon2}     
        cylinder { I2,T1, rayon2}    
        cylinder { T1,S2, rayon2}
        cylinder { S2,P1, rayon2}
        cylinder { P1,J2, rayon2}
        cylinder { J2,A, rayon2}   
        cylinder { A,E, rayon2}      
        cylinder { E,O2, rayon2}
        cylinder { O2,P1, rayon2}
        cylinder { O1,P2, rayon2}     
        cylinder { P2,S1, rayon2}    
        cylinder { S1,R3, rayon2}
        cylinder { R3,N1, rayon2} 
        cylinder { N1,O1, rayon2}
        cylinder { O1,E, rayon2}   
        cylinder { E,D, rayon2}      
        cylinder { D,M2, rayon2}
        cylinder { M2,N1, rayon2}
         texture {bronze}}} 
  
#if (numerofilm =1)
       #declare rayon = 0;
#else
        #if (numerofilm=2)
                #declare rayon = 0.12*clock;       
        #else
                #declare rayon = 0.12;
        #end    
#end

#declare SDODE = object
{union {
        sphere { A, rayon}    
        sphere { B, rayon}         
        sphere { C, rayon}      
        sphere { D, rayon}         
        sphere { E, rayon}      
        sphere { F1, rayon}
        sphere { G1, rayon}    
        sphere { H1, rayon}         
        sphere { I1, rayon}      
        sphere { J1, rayon}               
        sphere { L1, rayon}
        sphere { M1, rayon}    
        sphere { N1, rayon}         
        sphere { O1, rayon}      
        sphere { P1, rayon}         
        sphere { Q1, rayon}      
        sphere { R1, rayon}
        sphere { S1, rayon}
        sphere { T1, rayon}
        sphere { U1, rayon}    
         texture { bronze}}} 
        
DEVL         
ADODE
SDODE

