#declare numerofilm = 3; // 3 films

global_settings {max_trace_level 25}

light_source
        {<0, 3, 0>
        color rgb <1, 1, 1>}
light_source
        {<0, 0, 5>
        color rgb <1, 1, 1>}
light_source
        {<0, 0, -5>
        color rgb <1, 1, 1>}       
light_source
        {<10, 10, 0>
        color rgb <1, 1, 1>}

#if (numerofilm = 1)
        camera{location <0, 0, 5>    
               look_at <0.0, 0.0, 0.0>}
#else
        #if (numerofilm = 2)
                camera{location <0,0,-2.5*clock+5> 
                       look_at <0.0, 0.0, 0.0>}
        #else 
                camera{ location <0,0,2.5> 
                        rotate <0.0, -180*clock, 0.0>
                        look_at <0.0, 0.0, 0.0>}
        #end
#end
        
background { color rgb <0,0,0> }
plane {y, -0.03-2*sqrt(2)/3 pigment {color rgbt <0.58, 0.42, 0.20>}} 

#declare gold = texture {pigment {color rgbt <1.00, 0.87, 0.475,0>}
finish {
    ambient 0.30
    brilliance 3
    diffuse 0.4
    metallic
    specular 0.2
    roughness 1/60}};

#declare bronze = texture {pigment {color rgbt <0.58, 0.42, 0.20>} 
finish {
    ambient 0.25
    brilliance 3
    diffuse 0.4
    metallic
    specular 0.20
    roughness 1/60}};

#declare rayon2 = 0.02;

#if (numerofilm=1)
        #declare A = <-sqrt(2)/3, -sqrt(6)/3, -1/3>;
        #declare B = <2*sqrt(2)/3, 0, -1/3>;
        #declare C = <-sqrt(2)/3, sqrt(6)/3, -1/3>;
        #declare D1 = <4*sqrt(2)/3*clock-4*sqrt(2)/3, 0, 4/3*clock-1/3>;
        #declare D2 = <-2*sqrt(2)/3*clock+2*sqrt(2)/3,2*sqrt(6)/3*clock-2*sqrt(6)/3,  4/3*clock-1/3> ;
        #declare D3 = <-2*sqrt(2)/3*clock+2*sqrt(2)/3,-2*sqrt(6)/3*clock+2*sqrt(6)/3, 4/3*clock-1/3> ;
#else
        #declare A = <-sqrt(2)/3, -sqrt(6)/3, -1/3>;
        #declare B = <2*sqrt(2)/3, 0, -1/3>;
        #declare C = <-sqrt(2)/3, sqrt(6)/3, -1/3>;
        #declare D1 = <0,0,1>;
        #declare D2 = <0,0,1>;
        #declare D3 = <0,0,1>;
#end

#declare DEVL = object
{union {
        polygon { 4, C, B, A, C}
        polygon { 4, A, C, D1, A}
        polygon { 4, A, B, D2, A}
        polygon { 4, B, C, D3, B}
         texture {gold}
         rotate <0, 0, 30>}}

#declare ATETRA = object
{union {
        cylinder { A,B, rayon2} 
        cylinder { B,C, rayon2}         
        cylinder { A,C, rayon2}        
        cylinder { B,D3, rayon2}   
        cylinder { D3,C, rayon2} 
        cylinder { C,D1, rayon2}   
        cylinder { A,D1, rayon2}      
        cylinder { A,D2, rayon2}
        cylinder { D2,B, rayon2}  
         texture {bronze}
         rotate <0, 0, 30>}}

#if (numerofilm = 1)
        #declare rayon = 0;
#else 
        #if (numerofilm = 2)         
                #declare rayon = 0.03*clock;
        #else
                #declare rayon = 0.03;
        #end   
#end

#declare STETRA = object
{union {
        sphere { A, rayon} 
        sphere { B, rayon}         
        sphere { C, rayon}        
        sphere { D1, rayon}   
        texture {bronze} 
        rotate <0, 0, 30>}}         

DEVL
ATETRA
STETRA
