#declare numerofilm = 11; // 11 films
#declare rapport = 1/3;
#declare rapport2 = 1/9; 

global_settings {max_trace_level 25}
background { color rgb <0,0,0> }

#if (numerofilm <=10)
        light_source {
          0*x                     
          color rgb <1,1,1>       
          spotlight               
          translate <-5,5,-5> 
          point_at <0, 0, 0>      
          radius 60              
          tightness 50            
          falloff 8}
        light_source {
          0*x                     
          color rgb <1,1,1>       
          spotlight              
          translate <0,5,-5> 
          point_at <0, 0, 0>     
          radius 60             
          tightness 1            
          falloff 20}
        
#else
        light_source {
          0*x                     
          color rgb <1,1,1>       
          spotlight               
          translate <(-5*rapport2+5)*clock-5,(5*rapport2-5)*clock+5,(-5*rapport2+5)*clock-5> 
          point_at <0, 0, 0>      
          radius 60              
          tightness 50            
          falloff 8}
        
        light_source {
          0*x                     
          color rgb <1,1,1>       
          spotlight              
          translate <0,(5*rapport2-5)*clock+5,(-5*rapport2+5)*clock-5> 
          point_at <0, 0, 0>     
          radius 60             
          tightness 1            
          falloff 20}  
        
        
#end

#if (numerofilm =1)
        #declare goldsphere = texture {pigment {color rgbt <0.65, 0.5, 0.2,clock>} 
        finish {
            ambient 0.7
            brilliance 15
            diffuse 0.9
            metallic
            specular -0.2*clock + 0.20
            roughness 1/60
            reflection -0.05*clock+0.05
            }}; 
        
        sphere { <0, 0, 0>, 1 texture {goldsphere}}
#end

#if (numerofilm <=5)
        camera{ location <sqrt(2)/3,0,-3> 
                look_at <0.0, 0.0, 0.0>}
#else
        #if (numerofilm =6)
                camera{location <(-2*sqrt(2)/9)*clock+sqrt(2)/3,0,2*clock-3> //film 6
                        look_at <0.0, 0.0, 0.0>}
        #else
                #if (numerofilm =11)
                        camera{location <(-2*sqrt(2)/27)*clock+sqrt(2)/9,0,2/3*clock-1> //film 11
                               look_at <0.0, 0.0, 0.0>}
                #else
                        camera{location <(-2*sqrt(2)/9)*1+sqrt(2)/3,0,2*1-3>//film 7 
                               look_at <0.0, 0.0, 0.0>}
                #end
        #end
#end
                 

#if (numerofilm <=2 | 7<=numerofilm)
        #declare bronze = texture {pigment {color rgbt<0.58, 0.42, 0.20,0.3>} 
#else
        #if (numerofilm =3)
                #declare bronze = texture {pigment {color rgbt <0.58, 0.42, 0.20,0.7*clock+0.3>} 
        #else
                #declare bronze = texture {pigment {color rgbt <0.58, 0.42, 0.20,1>} 
        #end
#end
        finish {ambient 0.6
                brilliance 3
                diffuse 0.2
                metallic
                roughness 1/90
                #if (numerofilm =4) 
                        reflection 0.5-0.5*clock 
                        specular -0.2*clock+0.2 
                #else
                        #if (numerofilm =5)
                                specular 0  
                                reflection 0 
                        #else
                                 specular 0.20 
                                 reflection 0.5
                        #end
                #end}};         

#if (numerofilm < 5| 7<=numerofilm)
        #declare gold = texture {pigment {color rgbt <1.00, 0.87, 0.475,0>} 
#else
        #if (numerofilm =5)
                #declare gold = texture {pigment {color rgbt <1.00, 0.87, 0.475,clock>}
        #else
                #declare gold = texture {pigment {color rgbt <1.00, 0.87, 0.475,1>}
        #end
#end
          finish {  ambient 0.25
                    brilliance 3                 
                    diffuse 0.4
                    metallic
                    roughness 1/60
                    #if (numerofilm =5)
                        specular -0.2*clock+0.2
                        reflection -0.4*clock+0.4
                    #else
                        specular 0.20
                        reflection 0.4
                    #end}};

#if (2< numerofilm & numerofilm <=9)
        #declare bronze1 =  texture {pigment {color rgbt <0.58, 0.42, 0.20,0>} 
#else
        #if (numerofilm =10)
                #declare bronze1 =  texture {pigment {color rgbt <0.58, 0.42, 0.20,clock>}
        #else        
                #if (numerofilm=2)
                        #declare bronze1 =  texture {pigment {color rgbt <0.58, 0.42, 0.20,1-clock>}
                #else
                        #declare bronze1 =  texture {pigment {color rgbt <0.58, 0.42, 0.20,1>}
                #end
        #end
#end
        finish {
                ambient 0.25
                brilliance 3
                diffuse 0.4
                metallic
                roughness 1/60
                #if (numerofilm =10)
                        specular -0.2*clock+0.2
                        reflection 0.5-0.5*clock  
                #else
                        specular 0.20
                        reflection 0.5
                #end}};
        
#if (2< numerofilm & numerofilm <=7)
        #declare gold1 = texture {pigment {color rgbt <1.00, 0.87, 0.475,0>}  
#else
        #if (numerofilm=8 )
                #declare gold1 = texture {pigment {color rgbt <1.00, 0.87, 0.475,clock>}  
        #else
                #if (numerofilm =2)
                        #declare gold1 = texture {pigment {color rgbt <1.00, 0.87, 0.475,1-clock>} 
                #else
                        #declare gold1 = texture {pigment {color rgbt <1.00, 0.87, 0.475,1>}
                #end
        #end
#end
        finish {
            ambient 0.25
            brilliance 3
            diffuse 0.4
            metallic
            specular 0.20
            roughness 1/60    
            #if (numerofilm =2)
                reflection 0.4*clock
                specular 0.2*clock
            #else
                #if (numerofilm =9)
                        reflection 0.4-0.4*clock 
                        specular -0.2*clock+0.2
                #else
                        #if (numerofilm=1|numerofilm =10)
                                reflection 0
                                specular 0
                        #else
                                reflection 0.4 
                                specular 0.2
                        #end         
                #end
            #end}};  
            
#declare rayon = 0.04;
#declare rayon2 = 0.02; 
#declare rayon3 =0.04*rapport; 
#declare rayon4 = 0.02*rapport;  
#declare rayon5 =0.04*rapport2; 
#declare rayon6 = 0.02*rapport2;  

#if (numerofilm =1)
        #declare rayon = 0.04*clock; 
        #declare rayon2 = 0.02*clock; 
#else
        #if (numerofilm=2)
                #declare rayon3 =0.04*rapport*clock; 
                #declare rayon4 = 0.02*rapport*clock;  
        #else
                #if (numerofilm =7)
                        #declare rayon5 =0.04*rapport2*clock; 
                        #declare rayon6 = 0.02*rapport2*clock;  
                #end
        #end
#end

#if (numerofilm <=5)
        plane {y, -1 pigment {color rgbt <1, 0.87, 0.475> } 
               rotate <0, 0, 30>}
#else
        #if (numerofilm=6)
                plane {y, 2/3*clock-1 pigment {color rgbt <1, 0.87, 0.475> }
                       rotate <0, 0, 30>}
        #else
                #if (numerofilm =11)     
                        plane {y, (2/9)*clock-1/3 pigment {color rgbt <1, 0.87, 0.475> }
                               rotate <0, 0, 30>}
                #else
                        plane {y, 2/3-1 pigment {color rgbt <1, 0.87, 0.475> }
                               rotate <0, 0, 30>}
                #end
        #end
#end

#declare A = <-sqrt(2)/3, -sqrt(6)/3, -1/3>;
#declare B = <2*sqrt(2)/3, 0, -1/3>;
#declare C = <-sqrt(2)/3, sqrt(6)/3, -1/3>;
#declare D = <0,0,1>;

#declare TETRA= object
{union {polygon { 4, A, B, C, A}
        polygon { 4, A, B, D, A}
        polygon { 4, A, C, D, A}
        polygon { 4, B, C, D, B}
         texture {bronze }}} 

#declare STETRA = object
{union {
        sphere { A, rayon} 
        sphere { B, rayon} 
        sphere { C, rayon} 
        sphere { D, rayon}
         texture {gold}}}

#declare ATETRA = object
{union {
        cylinder { A, B, rayon2} 
        cylinder { A, C, rayon2}         
        cylinder { A, D, rayon2}        
        cylinder { B, C, rayon2}
        cylinder { B, D, rayon2}  
        cylinder { C, D, rayon2}  
         texture {gold}}}


#declare AA = <0,0,-1/3>;
#declare BB = <sqrt(2)/9, -sqrt(6)/9, 1/9>;
#declare CC = <-2*sqrt(2)/9, 0, 1/9>;
#declare DD = <sqrt(2)/9, sqrt(6)/9, 1/9>;

#declare TETRA2= object
{union {
        polygon { 4, AA, BB, CC, AA}
        polygon { 4, AA, BB, DD, AA}
        polygon { 4, AA, CC, DD, AA}
        polygon { 4, BB, CC, DD, BB}
        texture { gold1 }}}
                
#declare STETRA2 = object
{union {
        sphere { AA, rayon3} 
        sphere { BB, rayon3} 
        sphere { CC, rayon3} 
        sphere { DD, rayon3}
         texture {bronze1}}}

#declare ATETRA2 = object
{union {
        cylinder { AA, BB, rayon4} 
        cylinder { AA, CC, rayon4}         
        cylinder { AA, DD, rayon4}        
        cylinder { BB, CC, rayon4}
        cylinder { BB, DD, rayon4}  
        cylinder { CC, DD, rayon4}  
         texture {bronze1}}}                

#declare AAA = <-sqrt(2)/27, -sqrt(6)/27, -1/27>;
#declare BBB = <2*sqrt(2)/27, 0, -1/27>;
#declare CCC = <-sqrt(2)/27, sqrt(6)/27, -1/27>;
#declare DDD = <0,0,1/9>;

#declare TETRA3= object
{union {
        polygon { 4, AAA, BBB, CCC, AAA}
        polygon { 4, AAA, BBB, DDD, AAA}
        polygon { 4, AAA, CCC, DDD, AAA}
        polygon { 4, BBB, CCC, DDD, BBB}
         texture { bronze }}}

#declare STETRA3 = object
{union {
        sphere { AAA, rayon5} 
        sphere { BBB, rayon5} 
        sphere { CCC, rayon5} 
        sphere { DDD, rayon5}
         texture {gold}}}

#declare ATETRA3 = object
{union {
        cylinder { AAA, BBB, rayon6} 
        cylinder { AAA, CCC, rayon6}         
        cylinder { AAA, DDD, rayon6}        
        cylinder { BBB, CCC, rayon6}
        cylinder { BBB, DDD, rayon6}  
        cylinder { CCC, DDD, rayon6}  
         texture {gold}}}                 

#if (1<=numerofilm & numerofilm <=5 )
        TETRA 
        STETRA 
        ATETRA
#end

#if ( 2<=numerofilm & numerofilm <=10)
        TETRA2
        ATETRA2
        STETRA2
#end

#if (7<=numerofilm )
        TETRA3 
        ATETRA3 
        STETRA3 
#end


















 



 

  


