var canevas, glissAngle, glissNbBranches, glissFacteur, glissTronc, contenant, choixCouleur, niveau, taille, alpha, nbBranches, facteur;

/**
 * Fonction exécutée une fois, au départ
 */
function actions_initiales() {
  centrerPageExecution(900);
  createElement("h1",'... et arbres fractals');
  canevas=creerCanvas(800,600); canvas=canevas;
  createSpan("<br>");
  glissAngle=nouvelleGlissiereValeur('Angle d\'ouverture',0,180,90,1);
  createSpan("<br>");
  glissNbBranches=nouvelleGlissiereValeur('Nombres d\'embranchements',2,6,4,1);
  createSpan("<br>");
  glissFacteur=nouvelleGlissiereValeur('Facteur branche suivante',0.3,0.9,0.7,0.01);
  createSpan("<br>");
  glissTronc=nouvelleGlissiereValeur('Hauteur du tronc',50,400,200,1);
  sautePos((leGraphicsActif.width / 2),(leGraphicsActif.height));
  contenant=createElement('div','');
  choixCouleur = select('#'+'choixCouleur');
  assignerParentPrudent("choixCouleur",choixCouleur,"contenant",contenant);
  fixeContenuPrudent("choixCouleur",choixCouleur,' Choisir la couleur du fond ');
}

/**
 * Fonction exécutée périodiquement, de façon répétée
 */
function actions_en_boucle() {
  couleurFondC((eval('choixCouleur.elt.jscolor.toHEXString()')));
  alpha = valeurPrudent("glissAngle",glissAngle);
  nbBranches = valeurPrudent("glissNbBranches",glissNbBranches);
  facteur = valeurPrudent("glissFacteur",glissFacteur);
  arbre_fractal(6, valeurPrudent("glissTronc",glissTronc));
}

/**
 * Décrire cette fonction…
 */
function arbre_fractal(niveau, taille) {
  if (niveau == 0) {
    return ;
  }
  strokeWeight_(niveau);
  avance(taille);
  gauche((alpha / 2));
  for (var count = 0; count < nbBranches; count++) {
    arbre_fractal(niveau - 1, taille * facteur);
    droite((alpha / (nbBranches - 1)));
  }
  gauche((alpha / (nbBranches - 1)));
  gauche((alpha / 2));
  strokeWeight_(niveau);
  recule(taille);
}
