/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class IFStransfos
extends FenetreTortue {
    public static int baseFenetre = 800;
    public static int hauteurFenetre = 600;
    public static String titreFenetre = "Fractales IFS";
    public static boolean zoneTexte = true;
    public static String[] nomsBoutonsLigne1 = new String[]{"Nouvelle transformation", IFStransfos.unicode("D#eaigfinir textuellement"), "Effacer la transformation"};
    public static String[] nomsBoutonsLigne2 = new String[]{"Ajouter des points", "Effacer les points", "Effacer tout", "Quitter"};
    public static String[] nomsMenus1 = new String[]{"Fractales IFS", IFStransfos.unicode("#Agra propos"), "Sauver", "Ramener", "Quitter"};
    public static String[] nomsMenus2 = new String[0];
    public static String[] nomsMenus3 = new String[0];
    public static String[] nomsMenus4 = new String[0];
    public static String[] nomsMenus5 = new String[0];
    public static String[] nomsMenus6 = new String[0];
    public static String[] nomsMenus7 = new String[0];
    public static String[] nomsMenus8 = new String[0];
    int nbMaxTransfo = 8;
    int nbTransfos = 0;
    int noTransfoEditee = -1;
    int rayonDisque = 3;
    int noPointChoisi;
    Color[] couleursTransfos = new Color[]{this.bleu, this.rouge, this.vert, this.magenta, this.cyan, this.orange, this.rose, this.noir};
    double[][] transfos = new double[this.nbMaxTransfo][6];
    double seuil = 5.0;
    double facteur;
    double origine1x;
    double origine1y;
    double origine2x;
    double origine2y;
    double pointX;
    double pointY;
    double echelle;
    double translatX;
    double translatY;
    double tempX;
    double tempY;
    boolean actionDroite;
    public static String[][] Menus = new String[][]{nomsMenus1, nomsMenus2, nomsMenus3, nomsMenus4, nomsMenus5, nomsMenus6, nomsMenus7, nomsMenus8};

    public static void ajoutDeGlissieres() {
        IFStransfos.ajouterGlissiereLigne1(IFStransfos.unicode("Nombre d'it#eaigrations (x 100)"), 1.0, 1000.0, 10.0, 0);
        IFStransfos.ajouterGlissiereLigne1(IFStransfos.unicode("#Eaigchelle"), 0.0, 10.0, 1.0, 2);
    }

    public void initialisation() {
        this.fixerProportionZoneTexte(0.2);
        this.geleHauteurZoneTexte();
        this.tailleTexte(24);
    }

    public void miseAjour() {
        this.afficherTransfos();
        this.afficherPoints(10 * this.valEnt(this.valeurGlissiere(1)), true);
        this.afficherFocus();
    }

    public void deselectionner() {
        this.noTransfoEditee = -1;
        this.videTexte();
    }

    public void afficherTransfos() {
        double hauteur = this.hauteurZoneGraphique();
        double largeur = this.largeurZoneGraphique();
        this.fixeOrigineTortue(largeur / 2.0, hauteur / 2.0);
        this.origine1x = -largeur / 4.0;
        this.origine1y = 0.0;
        this.origine2x = largeur / 4.0;
        this.origine2y = 0.0;
        this.translatX = 0.0;
        this.translatY = 0.0;
        this.facteur = this.min(largeur / 8.0, hauteur / 4.0);
        this.videGraphique();
        this.cc(this.noir);
        this.segment(0.0, -hauteur / 2.0, 0.0, hauteur / 2.0);
        this.cc(this.grisClair);
        this.segment(this.origine1x, -hauteur / 2.0, this.origine1x, hauteur / 2.0);
        this.segment(-largeur / 2.0, this.origine1y, 0.0, this.origine1y);
        this.cercle(this.origine1x, this.origine1y, this.facteur);
        for (int i = 0; i < this.nbTransfos; ++i) {
            this.cc(this.noir);
            this.segmentGauche(this.transfos[i][2], this.transfos[i][5], this.transfos[i][2] + this.facteur * this.transfos[i][0], this.transfos[i][5] + this.facteur * this.transfos[i][3]);
            this.cc(this.couleursTransfos[i]);
            this.segmentGauche(this.transfos[i][2], this.transfos[i][5], this.transfos[i][2] + this.facteur * this.transfos[i][1], this.transfos[i][5] + this.facteur * this.transfos[i][4]);
        }
    }

    public void afficherPoints(int nbPoints, boolean depart) {
        if (this.echelle != this.valeurGlissiere(2)) {
            this.afficherTransfos();
            this.afficherFocus();
        }
        this.echelle = this.valeurGlissiere(2);
        if (depart) {
            this.pointX = 0.0;
            this.pointY = 0.0;
        }
        if (this.nbTransfos == 0) {
            return;
        }
        for (int i = 0; i < nbPoints; ++i) {
            int transfoCourante = this.hasard(0, this.nbTransfos - 1);
            double temp = this.appliquerTransfoX(transfoCourante, this.pointX, this.pointY);
            this.pointY = this.appliquerTransfoY(transfoCourante, this.pointX, this.pointY);
            this.pointX = temp;
            this.cc(this.couleursTransfos[transfoCourante]);
            this.tracerPoint(this.pointX, this.pointY);
        }
    }

    public void tracerPoint(double x, double y) {
        if ((x = this.origine2x + this.echelle * x + this.translatX) < 0.0) {
            return;
        }
        y = this.origine2y + this.echelle * y + this.translatY;
        this.segment(x, y, x + 1.0, y);
    }

    public void segmentGauche(double x1, double y1, double x2, double y2) {
        this.segment(this.origine1x + x1, this.origine1y + y1, this.origine1x + x2, this.origine1y + y2);
    }

    public double appliquerTransfoX(int no, double x, double y) {
        return this.transfos[no][0] * x + this.transfos[no][1] * y + this.transfos[no][2];
    }

    public double appliquerTransfoY(int no, double x, double y) {
        return this.transfos[no][3] * x + this.transfos[no][4] * y + this.transfos[no][5];
    }

    public void ajouterTransfo() {
        if (this.nbTransfos == 8) {
            return;
        }
        this.transfos[this.nbTransfos][0] = 1.0;
        this.transfos[this.nbTransfos][1] = 0.0;
        this.transfos[this.nbTransfos][2] = 0.0;
        this.transfos[this.nbTransfos][3] = 0.0;
        this.transfos[this.nbTransfos][4] = 1.0;
        this.transfos[this.nbTransfos][5] = 0.0;
        this.noTransfoEditee = this.nbTransfos++;
        this.afficherTransfos();
        this.afficherPoints(10 * this.valEnt(this.valeurGlissiere(1)), true);
        this.afficherFocus();
    }

    public void afficherFocus() {
        if (this.noTransfoEditee == -1) {
            return;
        }
        this.couleurRemplissage(this.couleursTransfos[this.noTransfoEditee]);
        double p1x = this.transfos[this.noTransfoEditee][2];
        double p1y = this.transfos[this.noTransfoEditee][5];
        double p2x = p1x + this.facteur * this.transfos[this.noTransfoEditee][0];
        double p2y = p1y + this.facteur * this.transfos[this.noTransfoEditee][3];
        double p3x = p1x + this.facteur * this.transfos[this.noTransfoEditee][1];
        double p3y = p1y + this.facteur * this.transfos[this.noTransfoEditee][4];
        this.disque(this.origine1x + p1x, this.origine1y + p1y, this.rayonDisque);
        this.disque(this.origine1x + p2x, this.origine1y + p2y, this.rayonDisque);
        this.disque(this.origine1x + p3x, this.origine1y + p3y, this.rayonDisque);
        this.ecrireTransfo(this.noTransfoEditee);
    }

    public void ecrireTransfo(int n) {
        this.videTexte();
        this.ecrisRC("x' = (" + this.transfos[n][0] + ")x + (" + this.transfos[n][1] + ")y + " + this.transfos[n][2]);
        this.ecris("y' = (" + this.transfos[n][3] + ")x + (" + this.transfos[n][4] + ")y + " + this.transfos[n][5]);
    }

    public void definirTransfoTextuelle(int n) {
        double[] t = new double[6];
        t[0] = this.demanderNombre("Transformation " + n, "x' = ax + by + c\ny' = dx + ey + f\nValeur de a:", this.transfos[n][0]);
        if (this.annulation()) {
            return;
        }
        t[1] = this.demanderNombre("Transformation " + n, "x' = ax + by + c\ny' = dx + ey + f\nValeur de b:", this.transfos[n][1]);
        if (this.annulation()) {
            return;
        }
        t[2] = this.demanderNombre("Transformation " + n, "x' = ax + by + c\ny' = dx + ey + f\nValeur de c:", this.transfos[n][2]);
        if (this.annulation()) {
            return;
        }
        t[3] = this.demanderNombre("Transformation " + n, "x' = ax + by + c\ny' = dx + ey + f\nValeur de d:", this.transfos[n][3]);
        if (this.annulation()) {
            return;
        }
        t[4] = this.demanderNombre("Transformation " + n, "x' = ax + by + c\ny' = dx + ey + f\nValeur de e:", this.transfos[n][4]);
        if (this.annulation()) {
            return;
        }
        t[5] = this.demanderNombre("Transformation " + n, "x' = ax + by + c\ny' = dx + ey + f\nValeur de f:", this.transfos[n][5]);
        if (this.annulation()) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            this.transfos[n][i] = t[i];
        }
    }

    public double distPS(double x, double y, double x1, double y1, double x2, double y2) {
        double norme;
        double proj;
        if ((proj = ((x -= x1) * (x2 -= x1) + (y -= y1) * (y2 -= y1)) / (norme = this.sqrt(x2 * x2 + y2 * y2))) < 0.0) {
            return 1000.0;
        }
        if (proj > norme) {
            return 1000.0;
        }
        return this.abs(x * y2 - y * x2) / norme;
    }

    public double distPT(double x, double y, int n) {
        double p1x = this.transfos[n][2];
        double p1y = this.transfos[n][5];
        double p2x = p1x + this.facteur * this.transfos[n][0];
        double p2y = p1y + this.facteur * this.transfos[n][3];
        double p3x = p1x + this.facteur * this.transfos[n][1];
        double p3y = p1y + this.facteur * this.transfos[n][4];
        return this.min(this.distPS(x, y, p1x, p1y, p2x, p2y), this.distPS(x, y, p1x, p1y, p3x, p3y));
    }

    public void transfoSelectionnee(double x, double y) {
        int t = -1;
        double dMin = 1000.0;
        x -= this.origine1x;
        y -= this.origine1y;
        for (int i = 0; i < this.nbTransfos; ++i) {
            double d = this.distPT(x, y, i);
            if (!(d < dMin) || !(d < this.seuil)) continue;
            dMin = d;
            t = i;
        }
        if (t != -1) {
            this.noTransfoEditee = t;
        } else {
            this.deselectionner();
        }
        this.miseAjour();
    }

    public void identifierPointTransfo(double x, double y) {
        if (this.noTransfoEditee == -1) {
            return;
        }
        double p1x = this.transfos[this.noTransfoEditee][2];
        double p1y = this.transfos[this.noTransfoEditee][5];
        double p2x = p1x + this.facteur * this.transfos[this.noTransfoEditee][0];
        double p2y = p1y + this.facteur * this.transfos[this.noTransfoEditee][3];
        double p3x = p1x + this.facteur * this.transfos[this.noTransfoEditee][1];
        double p3y = p1y + this.facteur * this.transfos[this.noTransfoEditee][4];
        this.noPointChoisi = 0;
        if (this.distPP(x, y, p1x, p1y) < this.seuil) {
            this.noPointChoisi = 1;
        }
        if (this.distPP(x, y, p2x, p2y) < this.seuil) {
            this.noPointChoisi = 2;
        }
        if (this.distPP(x, y, p3x, p3y) < this.seuil) {
            this.noPointChoisi = 3;
        }
        this.modifierPointTransfo(x, y);
    }

    public void modifierPointTransfo(double x, double y) {
        if (this.noTransfoEditee == -1 || this.noPointChoisi == 0) {
            return;
        }
        double p1x = this.transfos[this.noTransfoEditee][2];
        double p1y = this.transfos[this.noTransfoEditee][5];
        switch (this.noPointChoisi) {
            case 1: {
                this.transfos[this.noTransfoEditee][2] = x;
                this.transfos[this.noTransfoEditee][5] = y;
                break;
            }
            case 2: {
                this.transfos[this.noTransfoEditee][0] = (x - p1x) / this.facteur;
                this.transfos[this.noTransfoEditee][3] = (y - p1y) / this.facteur;
                break;
            }
            case 3: {
                this.transfos[this.noTransfoEditee][1] = (x - p1x) / this.facteur;
                this.transfos[this.noTransfoEditee][4] = (y - p1y) / this.facteur;
            }
        }
        this.miseAjour();
    }

    public double distPP(double x1, double y1, double x2, double y2) {
        return this.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public void effacerPoints() {
        this.couleurRemplissage(this.blanc);
        this.rectanglePlein(1.0, this.hauteurZoneGraphique(), this.largeurZoneGraphique(), -this.hauteurZoneGraphique());
    }

    @Override
    public void actionBouton1() {
        this.ajouterTransfo();
    }

    @Override
    public void actionBouton2() {
        if (this.noTransfoEditee == -1) {
            return;
        }
        this.definirTransfoTextuelle(this.noTransfoEditee);
        if (!this.annulation()) {
            this.miseAjour();
        }
    }

    @Override
    public void actionBouton3() {
        if (this.noTransfoEditee == -1) {
            return;
        }
        for (int i = this.noTransfoEditee; i < this.nbTransfos - 1; ++i) {
            this.transfos[i] = this.transfos[i + 1];
        }
        --this.nbTransfos;
        this.deselectionner();
        this.miseAjour();
    }

    @Override
    public void actionBouton4() {
        this.afficherPoints(this.valEnt(100.0 * this.valeurGlissiere(1)), false);
    }

    @Override
    public void actionBouton5() {
        this.effacerPoints();
    }

    @Override
    public void actionBouton6() {
        this.nbTransfos = 0;
        this.deselectionner();
        this.afficherTransfos();
        this.afficherPoints(0, true);
    }

    @Override
    public void actionBouton7() {
        this.quitter();
    }

    @Override
    public void actionMenu1Item1() {
        this.message("Fractales IFS\n" + IFStransfos.unicode("par Andr#eaig Boileau") + "\n" + IFStransfos.unicode("et Maurice Garan#?cedon"));
    }

    @Override
    public void actionMenu1Item2() {
        if (IFStransfos.appletP()) {
            this.message("On ne peut enregistrer dans un applet");
            return;
        }
        this.viderDonneesASauver();
        this.ajouterDonnee(this.nbTransfos);
        for (int i = 0; i < this.nbTransfos; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.ajouterDonnee(this.transfos[i][j]);
            }
        }
        this.sauverDonnees();
    }

    @Override
    public void actionMenu1Item3() {
        this.lireFichier();
        if (this.tailleFichier() == 0) {
            return;
        }
        this.nbTransfos = this.valEnt(this.lireDonnee(0));
        int k = 1;
        for (int i = 0; i < this.nbTransfos; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.transfos[i][j] = this.valDec(this.lireDonnee(k));
                ++k;
            }
        }
        this.deselectionner();
        this.miseAjour();
    }

    @Override
    public void actionMenu1Item4() {
        this.quitter();
    }

    @Override
    public void clicSouris(double x, double y) {
        if (x > 0.0) {
            this.pointX = (x - this.origine2x) / this.echelle;
            this.pointY = (y - this.origine2y) / this.echelle;
        } else {
            this.transfoSelectionnee(x, y);
        }
    }

    @Override
    public void debutGlisser(double x, double y) {
        if (x < 0.0) {
            this.actionDroite = false;
            this.identifierPointTransfo(x - this.origine1x, y - this.origine1y);
        } else {
            this.actionDroite = true;
            this.tempX = x;
            this.tempY = y;
        }
    }

    @Override
    public void finGlisser(double x, double y) {
        if (this.actionDroite) {
            this.translatX = this.translatX + x - this.tempX;
            this.translatY = this.translatY + y - this.tempY;
            this.effacerPoints();
            this.afficherPoints(10 * this.valEnt(this.valeurGlissiere(1)), true);
        } else {
            this.glisserEnCours(x, y);
        }
    }

    @Override
    public void glisserEnCours(double x, double y) {
        if (!this.actionDroite) {
            this.modifierPointTransfo(x - this.origine1x, y - this.origine1y);
        }
    }

    @Override
    public void actionTailleChange() {
        this.miseAjour();
    }

    public IFStransfos(int l, int h, String titre, String[] nomsBoutons1, String[] nomsBoutons2, String[][] Menus, boolean avecTexte) {
        super(l, h, titre, nomsBoutons1, nomsBoutons2, Menus, avecTexte);
    }

    public IFStransfos() {
        this(baseFenetre, hauteurFenetre, titreFenetre, nomsBoutonsLigne1, nomsBoutonsLigne2, Menus, zoneTexte);
    }

    public static void executer(boolean applet) {
        IFStransfos.initGlissieres();
        IFStransfos.ajoutDeGlissieres();
        IFStransfos maFenetre = new IFStransfos();
        IFStransfos.faireApplet(applet);
        maFenetre.toFront();
        maFenetre.initialisation();
    }

    public static void main(String[] args) {
        IFStransfos.executer(false);
    }
}

