/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.SwingUtilities;

public class Rebonds
extends FenetreTortue {
    public static int baseFenetre = 600;
    public static int hauteurFenetre = 700;
    public static String titreFenetre = "Rebonds";
    public static boolean zoneTexte = false;
    public static String[] nomsBoutonsLigne1 = new String[]{"Ajouter", "Simuler", "Situation", "Param\u00e8tres", "Quitter"};
    public static String[] nomsBoutonsLigne2 = new String[0];
    public static String[] nomsMenus1 = new String[0];
    public static String[] nomsMenus2 = new String[0];
    public static String[] nomsMenus3 = new String[0];
    public static String[] nomsMenus4 = new String[0];
    public static String[] nomsMenus5 = new String[0];
    public static String[] nomsMenus6 = new String[0];
    public static String[] nomsMenus7 = new String[0];
    public static String[] nomsMenus8 = new String[0];
    int nbBandes = 0;
    int nbMaxBandes = 20;
    int dimPoints = 2 + 2 * this.nbMaxBandes;
    int noPoint = -1;
    double[] Px = new double[this.dimPoints];
    double[] Py = new double[this.dimPoints];
    boolean modeSimulation = false;
    double longueur;
    double echelle = 10.0;
    double vitesse = 10.0;
    int noRebond;
    int debutTrace = 0;
    int finTrace = 0;
    int nbTraces = 3;
    int nbMaxTraces = 1000;
    boolean modeTrace = true;
    double[] traceX = new double[this.nbMaxTraces + 1];
    double[] traceY = new double[this.nbMaxTraces + 1];
    public static String[][] Menus = new String[][]{nomsMenus1, nomsMenus2, nomsMenus3, nomsMenus4, nomsMenus5, nomsMenus6, nomsMenus7, nomsMenus8};

    public static void ajoutDeGlissieres() {
    }

    void initialisation() {
        this.Px[1] = 0.0;
        this.Py[1] = 0.0;
        this.Px[0] = this.Px[1];
        this.Py[0] = this.Py[1];
        this.nbBandes = 0;
        this.initTrace();
        this.dessinerSituation();
    }

    void dessinerSituation() {
        this.centreTortue();
        this.effaceGraphique();
        this.couleurCrayon(this.bleu);
        if (!this.modeSimulation) {
            this.segment(this.Px[1], this.Py[1], this.Px[0], this.Py[0]);
        }
        this.cercle(this.Px[1], this.Py[1], 3.0);
        this.couleurCrayon(this.rouge);
        for (int k = 1; k <= this.nbBandes; ++k) {
            this.segment(this.Px[2 * k], this.Py[2 * k], this.Px[2 * k + 1], this.Py[2 * k + 1]);
        }
        if (this.modeTrace) {
            this.couleurCrayon(this.noir);
            for (int i = 0; i < this.nbTraces; ++i) {
                this.segment(this.traceX[(this.debutTrace + i) % (this.nbTraces + 1)], this.traceY[(this.debutTrace + i) % (this.nbTraces + 1)], this.traceX[(this.debutTrace + i + 1) % (this.nbTraces + 1)], this.traceY[(this.debutTrace + i + 1) % (this.nbTraces + 1)]);
            }
        }
        this.couleurCrayon(this.bleu);
        this.cercle(this.Px[1], this.Py[1], 3.0);
    }

    void faireSimulation() {
        double Px0 = this.Px[0];
        double Py0 = this.Py[0];
        double Px1 = this.Px[1];
        double Py1 = this.Py[1];
        double Px2 = this.Px[2];
        double Py2 = this.Py[2];
        double Px3 = this.Px[3];
        double Py3 = this.Py[3];
        this.modeSimulation = true;
        this.initTrace();
        this.Px[0] = this.echelle * (this.Px[0] - this.Px[1]);
        this.Py[0] = this.echelle * (this.Py[0] - this.Py[1]);
        this.longueur = this.norme(this.Px[0], this.Py[0]);
        while (0.0 < this.longueur && this.abs(this.Px[1]) <= (double)(this.largeurZoneGraphique() / 2) && this.abs(this.Py[1]) <= (double)(this.hauteurZoneGraphique() / 2)) {
            this.simulerSegment();
            if (!this.interruption()) continue;
        }
        this.Px[0] = this.Px[1];
        this.Py[0] = this.Py[1];
        this.modeSimulation = false;
    }

    void simulerSegment() {
        int noBande = 0;
        double coeffMin = 1.0;
        double epsilon = 1.0E-10;
        for (int k = 1; k <= this.nbBandes; ++k) {
            double coeff = this.calculIntersection(k);
            if (!(epsilon < coeff) || !(coeff < coeffMin)) continue;
            noBande = k;
            coeffMin = coeff;
        }
        this.trajet(this.Px[1], this.Py[1], coeffMin * this.Px[0], coeffMin * this.Py[0]);
        this.Px[0] = (1.0 - coeffMin) * this.Px[0];
        this.Py[0] = (1.0 - coeffMin) * this.Py[0];
        this.longueur = (1.0 - coeffMin) * this.longueur;
        if (0.0 < this.longueur) {
            this.calculerReflexion(noBande);
        }
    }

    double calculIntersection(int n) {
        double coeff2;
        double x = this.Px[1] + this.Px[0];
        double y = this.Py[1] + this.Py[0];
        double coeff1 = this.coeffIntersection(this.Px[1], this.Py[1], x, y, this.Px[2 * n], this.Py[2 * n], this.Px[2 * n + 1], this.Py[2 * n + 1]);
        if (!(0.0 < coeff1) || !(coeff1 < 1.0)) {
            coeff1 = Double.POSITIVE_INFINITY;
        }
        if (!(0.0 < (coeff2 = this.coeffIntersection(this.Px[2 * n], this.Py[2 * n], this.Px[2 * n + 1], this.Py[2 * n + 1], this.Px[1], this.Py[1], x, y))) || !(coeff2 < 1.0)) {
            coeff1 = Double.POSITIVE_INFINITY;
        }
        return coeff1;
    }

    double coeffIntersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double u1 = x2 - x1;
        double v3 = y4 - y3;
        double u3 = x4 - x3;
        double v1 = y2 - y1;
        if (u1 * v3 == u3 * v1) {
            return Double.POSITIVE_INFINITY;
        }
        return (v3 * (x3 - x1) - u3 * (y3 - y1)) / (u1 * v3 - u3 * v1);
    }

    void calculerReflexion(int noBande) {
        double wx = this.Px[2 * noBande + 1] - this.Px[2 * noBande];
        double wy = this.Py[2 * noBande + 1] - this.Py[2 * noBande];
        double gamma = 2.0 * (this.Px[0] * wx + this.Py[0] * wy) / (wx * wx + wy * wy);
        this.Px[0] = gamma * wx - this.Px[0];
        this.Py[0] = gamma * wy - this.Py[0];
    }

    double norme(double a, double b) {
        return this.racine(a * a + b * b);
    }

    void trajet(double a, double b, double da, double db) {
        int nbEtapes = this.max(1, this.arrondis(this.norme(da, db) / this.vitesse));
        if (this.modeTrace) {
            this.debutTrace = (this.debutTrace + 1) % (this.nbTraces + 1);
            this.finTrace = (this.finTrace + 1) % (this.nbTraces + 1);
            this.traceX[this.finTrace] = this.Px[1];
            this.traceY[this.finTrace] = this.Py[1];
        }
        for (int k = 0; k <= nbEtapes; ++k) {
            this.Px[1] = a + da * (double)k / (double)nbEtapes;
            this.Py[1] = b + db * (double)k / (double)nbEtapes;
            this.traceX[this.finTrace] = this.Px[1];
            this.traceY[this.finTrace] = this.Py[1];
            this.dessinerSituation();
            this.miseAJourGraphique();
            if (!(this.abs(this.Px[1]) > (double)(this.largeurZoneGraphique() / 2)) && !(this.abs(this.Py[1]) > (double)(this.hauteurZoneGraphique() / 2))) continue;
            return;
        }
    }

    void initTrace() {
        if (this.modeTrace) {
            this.debutTrace = 0;
            this.finTrace = this.nbTraces;
            for (int k = this.debutTrace; k <= this.finTrace; ++k) {
                this.traceX[k] = this.Px[1];
                this.traceY[k] = this.Py[1];
            }
        }
    }

    @Override
    public void actionBouton1() {
        ++this.nbBandes;
        this.Px[2 * this.nbBandes] = (double)this.largeurZoneGraphique() * (this.hasard() - 0.5);
        this.Py[2 * this.nbBandes + 1] = (double)this.hauteurZoneGraphique() * (this.hasard() - 0.5);
        this.dessinerSituation();
    }

    @Override
    public void actionBouton2() {
        this.faireSimulation();
    }

    @Override
    public void actionBouton3() {
        int boutonChoisi = this.choixMultiple("Situation", "Situation d\u00e9sir\u00e9e ?", "Statut quo", "Recommencer", "Polygone r\u00e9gulier");
        if (boutonChoisi == 2) {
            this.initialisation();
        }
        if (boutonChoisi == 3) {
            int n = this.demanderEntier("n-gone r\u00e9gulier", "Nombre de c\u00f4t\u00e9s ?", 3);
            n = this.max(3, this.min(30, n));
            double rayon = this.min(this.largeurZoneGraphique() / 2, this.hauteurZoneGraphique() / 2) - 10;
            this.nbBandes = n;
            this.Px[1] = 0.0;
            this.Py[1] = 0.0;
            this.Px[0] = this.Px[1];
            this.Py[0] = this.Py[1];
            for (int k = 1; k <= n; ++k) {
                this.Px[2 * k] = rayon * this.cos((double)(k * 2) * this.Pi / (double)n);
                this.Py[2 * k] = rayon * this.sin((double)(k * 2) * this.Pi / (double)n);
                this.Px[2 * k + 1] = rayon * this.cos((double)((k + 1) * 2) * this.Pi / (double)n);
                this.Py[2 * k + 1] = rayon * this.sin((double)((k + 1) * 2) * this.Pi / (double)n);
            }
        }
        this.initTrace();
        this.dessinerSituation();
    }

    @Override
    public void actionBouton4() {
        this.echelle = this.demanderNombre("Echelle", "Donner un facteur d'\u00e9chelle", this.echelle);
        this.vitesse = this.demanderNombre("Vitesse", "Vitesse en pixels", this.vitesse);
        this.nbTraces = this.demanderEntier("Trace", "Longueur de la trace", this.nbTraces);
        this.modeTrace = this.nbTraces > 0;
        this.initTrace();
        this.dessinerSituation();
    }

    @Override
    public void actionBouton5() {
        this.quitter();
    }

    @Override
    public void actionMenu1Item1() {
    }

    @Override
    public void actionMenu1Item2() {
    }

    @Override
    public void actionMenu1Item3() {
    }

    @Override
    public void actionMenu1Item4() {
    }

    @Override
    public void actionGlissiere1(double d) {
    }

    @Override
    public void clicSouris(double x, double y) {
    }

    @Override
    public void debutGlisser(double x, double y) {
        this.noPoint = this.trouverPoint(x, y);
    }

    @Override
    public void finGlisser(double x, double y) {
        this.noPoint = -1;
    }

    @Override
    public void glisserEnCours(double x, double y) {
        if (this.noPoint >= 0) {
            this.Px[this.noPoint] = x;
            this.Py[this.noPoint] = y;
            this.dessinerSituation();
        }
    }

    public int trouverPoint(double x, double y) {
        double seuil = 16.0;
        for (int k = 0; k < this.dimPoints; ++k) {
            if (!(this.distCarree(this.Px[k], this.Py[k], x, y) < seuil)) continue;
            return k;
        }
        return -1;
    }

    public double distCarree(double u, double v, double x, double y) {
        return (u - x) * (u - x) + (v - y) * (v - y);
    }

    @Override
    public void actionTailleChange() {
        this.dessinerSituation();
    }

    public Rebonds(int l, int h, String titre, String[] nomsBoutons1, String[] nomsBoutons2, String[][] Menus, boolean avecTexte) {
        super(l, h, titre, nomsBoutons1, nomsBoutons2, Menus, avecTexte);
    }

    public Rebonds() {
        this(baseFenetre, hauteurFenetre, titreFenetre, nomsBoutonsLigne1, nomsBoutonsLigne2, Menus, zoneTexte);
    }

    public static void executer(boolean applet) {
        Rebonds.initGlissieres();
        Rebonds.ajoutDeGlissieres();
        Rebonds maFenetre = new Rebonds();
        Rebonds.faireApplet(applet);
        maFenetre.toFront();
        maFenetre.initialisation();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rebonds.executer(false);
            }
        });
    }
}

