 /***************************************************************************
 * 
 *                  NE PAS MODIFIER CETTE SECTION 
 *                  
 **************************************************************************/
import java.awt.*;
import Listes.*;

public class Polyedres extends FenetreTortue
{ 
     
/***************************************************************************
 * 
 *                      SECTION MODIFIABLE 
 *                  
 **************************************************************************/
 
 
 
/********************** Parametres de l'interface ************************/

    public static int baseFenetre = 600; // Largeur de la fenetre
    public static int hauteurFenetre = 700; // Hauteur de la fenetre
    public static String titreFenetre = ""; // Titre de la fenetre
    // Le texte
    public static boolean zoneTexte = false; // Indique si on dsire ou non une zone de texte
    // Les boutons
    public static String[] nomsBoutonsLigne1 = {"Tour X", "Tour Y", "Tour Z"}; // Noms des boutons de la ligne 1
    public static String[] nomsBoutonsLigne2 = {}; // Noms des boutons de la ligne 2
    // Les menus
    public static String[] nomsMenus1 = {" propos","Position initiale","Quitter"};
    public static String[] nomsMenus2 = {"s_Polydre","Ttradre","Cube","Octadre","Icosadre","Dodcadre"}; // Exemple: private static String[] nomsMenus1 = {"nomMenu", "nomItem_1", ...};
    public static String[] nomsMenus3 = {"s_Reprsentation","Fil de fer", "Lignes caches plies", "Lignes caches invisibles", "Couleurs"}; // Laissez vide si vous ne dsirez pas de menu
    public static String[] nomsMenus4 = {}; // {"s_Souris","Position","Vitesse"};
    public static String[] nomsMenus5 = {};
    public static String[] nomsMenus6 = {};
    public static String[] nomsMenus7 = {};
    public static String[] nomsMenus8 = {};
    
    public static void ajoutDeGlissieres(){
        ajouterGlissiereLigne1("Rayon", 10, 500, 200, 0);
    }

/****************** Initialisation *********************************/

    public static int nbSommets, nbFaces, nbSommetsParFace, modeTrace=1;
    public static double rayon;
    
    public static double[][] sommetsDepart = new double[21][3];
    public static double[][] sommets = new double[21][3];
    public static int[][] faces = new int[21][6];
    public static double[][] vecteursNormaux = new double[21][3];
    public static boolean[] faceVisible = new boolean[21];
    public static double[][] points = new double[21][2];
    
    public static double[][] rotation = new double[3][3];
    public static double[][] delta = new double[3][3];
    public static double[] u = new double[3], v = new double[3], w = new double[3];
   
    public void initialisation(){
        selectionMenuItem(2,1,true);
        selectionMenuItem(3,1,true);
        selectionMenuItem(4,1,true);
        rayon = valeurGlissiere(1);
        tetraedre();
        rotationInitiale();
        tracerPolyedre();
    }
    
/****************** Placer vos procedures ici ****************************/
    
    public void tetraedre(){
        double[][] sommetsInit = {{0,0,0},{1,1,1},{1,-1,-1},{-1,-1,1},{-1,1,-1},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
                       {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}};
        int[][] facesInit = {{0,0,0,0,0,0},{2,3,4,2,0,0},{1,4,3,1,0,0},{1,2,4,1,0,0},{1,3,2,1,0,0},{0,0,0,0,0,0},
                             {0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},
                             {0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},
                             {0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0}};
        sommetsDepart=sommetsInit;
        //sommets=sommetsInit;
        faces=facesInit;
        nbSommets = 4;
        nbFaces = 4;
        nbSommetsParFace = 3;
        normaliserEtc();
    }
    
    public void cube(){
        double[][] sommetsInit = {{0,0,0},{1,1,1},{-1,1,1},{-1,-1,1},{1,-1,1},{1,1,-1},{-1,1,-1},{-1,-1,-1},{1,-1,-1},
                       {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}};
        int[][] facesInit = {{0,0,0,0,0,0},{5,8,7,6,5,0},{1,2,3,4,1,0},{4,3,7,8,4,0},{5,6,2,1,5,0},{1,4,8,5,1,0},
                             {6,7,3,2,6,0},{0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},
                             {0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},
                             {0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0}};
        sommetsDepart=sommetsInit;
        //sommets=sommetsInit;
        faces=facesInit;
        nbSommets = 8;
        nbFaces = 6;
        nbSommetsParFace = 4;
        normaliserEtc();
    }
    
    public void octaedre(){
        double[][] sommetsInit = {{0,0,0},{0,0,-1},{0,0,1},{0,-1,0},{0,1,0},{1,0,0},{-1,0,0},{0,0,0},{0,0,0},
                       {0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}};
        int[][] facesInit = {{0,0,0,0,0,0},{2,5,4,2,0,0},{2,4,6,2,0,0},{3,2,6,3,0,0},{2,3,5,2,0,0},{1,4,5,1,0,0},
                             {1,6,4,1,0,0},{1,3,6,1,0,0},{1,5,3,1,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},
                             {0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},
                             {0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0}};
        sommetsDepart=sommetsInit;
        //sommets=sommetsInit;
        faces=facesInit;
        nbSommets = 6;
        nbFaces = 8;
        nbSommetsParFace = 3;
        normaliserEtc();
    }
    
    public void icosaedre(){
        double t = (racine(5)-1)/2.0;
        double[][] sommetsInit = {{0,0,0},{0,1,t},{0,1,-t},{1,t,0},{1,-t,0},{0,-1,-t},{0,-1,t},{t,0,1},{-t,0,1},
                       {t,0,-1},{-t,0,-1},{-1,t,0},{-1,-t,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0}};
        int[][] facesInit = {{0,0,0,0,0,0},{1,7,3,1,0,0},{3,7,4,3,0,0},{4,7,6,4,0,0},{6,7,8,6,0,0},{1,8,7,1,0,0},
                             {3,4,9,3,0,0},{3,9,2,3,0,0},{1,3,2,1,0,0},{1,2,11,1,0,0},{11,2,10,11,0,0},{2,9,10,2,0,0},
                             {4,5,9,4,0,0},{5,4,6,5,0,0},{5,6,12,5,0,0},{8,11,12,8,0,0},{8,1,11,8,0,0},{5,12,10,5,0,0},
                             {9,5,10,9,0,0},{6,8,12,6,0,0},{12,11,10,12,0,0}};
        sommetsDepart=sommetsInit;
        //sommets=sommetsInit;
        faces=facesInit;
        nbSommets = 12;
        nbFaces = 20;
        nbSommetsParFace = 3;
        normaliserEtc();
    }
    
    public void dodecaedre(){
        double t = (racine(5)-1)/2.0 , s=t*t;
        double[][] sommetsInit = {{0,0,0},{t,t,t},{1,0,s},{t,-t,t},{0,-s,1},{0,s,1},{1,0,-s},{t,t,-t},{s,1,0},
                       {-s,1,0},{-t,t,-t},{0,s,-1},{t,-t,-t},{s,-1,0},{-s,-1,0},{-1,0,s},{-t,t,t},{-t,-t,-t},{0,-s,-1},{-t,-t,t},{-1,0,-s}};
        int[][] facesInit = {{0,0,0,0,0,0},{1,8,9,16,5,1},{7,11,10,9,8,7},{1,2,6,7,8,1},{2,3,13,12,6,2},{12,13,14,17,18,12},
                             {3,4,19,14,13,3},{1,5,4,3,2,1},{4,5,16,15,19,4},{7,6,12,18,11,7},{10,11,18,17,20,10},{9,10,20,15,16,9},
                             {19,15,20,17,14,19},{0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0},
                             {0,0,0,0,0,0},{0,0,0,0,0,0},{0,0,0,0,0,0}};
        sommetsDepart=sommetsInit;
        //sommets=sommetsInit;
        faces=facesInit;
        nbSommets = 20;
        nbFaces = 12;
        nbSommetsParFace = 5;
        normaliserEtc();
    }
    
    public void normaliserEtc(){
        double x,y,z,u,v,w;
        double norme = 0;
        for (int i=0; i<3;i++) {norme = norme + sommets[1][i]*sommets[1][i];};
        norme = racine(norme);
        for(int i=1;i<=nbSommets;i++) {
            for(int j=0;j<3;j++) {sommets[i][j]=sommets[i][j]/norme;};};
        for(int i=1;i<=nbFaces;i++) {
            x = sommets[faces[i][2]][0] - sommets[faces[i][1]][0];
            y = sommets[faces[i][2]][1] - sommets[faces[i][1]][1];
            z = sommets[faces[i][2]][2] - sommets[faces[i][1]][2];
            u = sommets[faces[i][3]][0] - sommets[faces[i][2]][0];
            v = sommets[faces[i][3]][1] - sommets[faces[i][2]][1];
            w = sommets[faces[i][3]][2] - sommets[faces[i][2]][2];
            vecteursNormaux[i][0] = v*z - w*y;
            vecteursNormaux[i][1] = w*x - u*z;
            vecteursNormaux[i][2] = u*y - v*x;
        };
    }
    
    public void calculPoints(){            // Perspective cavalire
        rayon = valeurGlissiere(1);
        for(int i=1;i<=nbSommets;i++) {
            points[i][0] = rayon*sommets[i][0];
            points[i][1] = rayon*sommets[i][1];
        };
    }
    
    public void tracerPolyedre(){
        calculerSommets();
        calculPoints();
        for(int i=1;i<=nbFaces;i++) {
            faceVisible[i] = 0 < vecteursNormaux[i][2];}
        videGraphique(); tailleCrayon(1);
        if (modeTrace == 1) {couleurCrayon(noir);};
        if (modeTrace == 2) {couleurCrayon(grisClair);};
        if (modeTrace == 3) {couleurCrayon(blanc);};
        if (modeTrace == 4) {couleurCrayon(blanc);};
        for(int i=1;i<=nbFaces;i++) {
            if (! faceVisible[i]) {
                for(int j=0;j<nbSommetsParFace;j++) {
                    segment(points[faces[i][j]][0],points[faces[i][j]][1],points[faces[i][j+1]][0],points[faces[i][j+1]][1]);}};}
        couleurCrayon(noir);
        if (modeTrace == 4) {
            couleurCrayon(vert); couleurRemplissage(vert); 
            for(int i=1;i<=nbFaces;i++) {
                if (faceVisible[i]) {
                    debutRemplir();
                    for(int j=0;j<nbSommetsParFace;j++) {
                        segment(points[faces[i][j]][0],points[faces[i][j]][1],points[faces[i][j+1]][0],points[faces[i][j+1]][1]);}
                    finRemplir(); };}
            couleurCrayon(noir); tailleCrayon(3);};
        for(int i=1;i<=nbFaces;i++) {
            if (faceVisible[i]) {
                for(int j=0;j<nbSommetsParFace;j++) {
                    segment(points[faces[i][j]][0],points[faces[i][j]][1],points[faces[i][j+1]][0],points[faces[i][j+1]][1]);}};}
    }

    public void rotationInitiale() {
        double[][] rotationInit = {{1,0,0},{0,1,0},{0,0,1}};
        rotation = rotationInit;
    }
    
    public void calculerSommets() {
        for(int k=1;k<=nbSommets;k++) {
            for (int ligne=0;ligne<3;ligne++) {
                sommets[k][ligne]=rotation[ligne][0]*sommetsDepart[k][0]+rotation[ligne][1]*sommetsDepart[k][1]+rotation[ligne][2]*sommetsDepart[k][2];
            }
        } 
        normaliserEtc();
    }
    
    public void nouvelleRotation() {
        for (int i=0;i<3;i++) {
            for (int j=0;j<3;j++) {
                rotation[i][j] = delta[i][0]*rotation[0][j]+delta[i][1]*rotation[1][j]+delta[i][2]*rotation[2][j];
            }
        }
        normaliserRotation();
        tracerPolyedre();
    }
    
    public void normaliserRotation() {
        double d = rotation[0][0]*rotation[0][0]+rotation[0][1]*rotation[0][1]+rotation[0][2]*rotation[0][2];
        d=sqrt(d); rotation[0][0]=rotation[0][0]/d; rotation[0][1]=rotation[0][1]/d; rotation[0][2]=rotation[0][2]/d;
        double s = rotation[0][0]*rotation[1][0]+rotation[0][1]*rotation[1][1]+rotation[0][2]*rotation[1][2];
        rotation[1][0]=rotation[1][0]-s*rotation[0][0];
        rotation[1][1]=rotation[1][1]-s*rotation[0][1];
        rotation[1][2]=rotation[1][2]-s*rotation[0][2];
        d = rotation[1][0]*rotation[1][0]+rotation[1][1]*rotation[1][1]+rotation[1][2]*rotation[1][2];
        d=sqrt(d); rotation[1][0]=rotation[1][0]/d; rotation[1][1]=rotation[1][1]/d; rotation[1][2]=rotation[1][2]/d;
        rotation[2][0]=rotation[0][1]*rotation[1][2]-rotation[0][2]*rotation[1][1];
        rotation[2][1]=-rotation[0][0]*rotation[1][2]+rotation[0][2]*rotation[1][0];
        rotation[2][2]=rotation[0][0]*rotation[1][1]-rotation[0][1]*rotation[1][0];
        // besoin de normaliser 3e ligne ???
        d = rotation[2][0]*rotation[2][0]+rotation[2][1]*rotation[2][1]+rotation[2][2]*rotation[2][2];
        d=sqrt(d); rotation[2][0]=rotation[2][0]/d; rotation[2][1]=rotation[2][1]/d; rotation[2][2]=rotation[2][2]/d;
    }

/**************  Les actions des boutons  ************************************/

public void actionBouton1(){   
    int n=360; double a=360/n;
    double [][] deltaInit = {{1,0,0},{0,cosD(a),-sinD(a)},{0,sinD(a),cosD(a)}};
    delta=deltaInit;
    for (int k=0;k<n;k++) {nouvelleRotation(); miseAJourGraphique();}
} 

public void actionBouton2(){   
    int n=360; double a=360/n;
    double [][] deltaInit = {{cosD(a),0,-sinD(a)},{0,1,0},{sinD(a),0,cosD(a)}};
    delta=deltaInit;
    for (int k=0;k<n;k++) {nouvelleRotation(); miseAJourGraphique();}
}

public void actionBouton3(){   
    int n=360; double a=360/n;
    double [][] deltaInit = {{cosD(a),-sinD(a),0},{sinD(a),cosD(a),0},{0,0,1}};
    delta=deltaInit;
    for (int k=0;k<n;k++) {nouvelleRotation(); miseAJourGraphique();}
}

// etc..
/**************  Les actions des menus  ****************************/
public void actionMenu1Item1(){ 
    rotationInitiale(); 
    tracerPolyedre();
} 

public void actionMenu1Item2(){
    quitter();    
}

public void actionMenu2Item1(){  
    tetraedre(); rotationInitiale();
    tracerPolyedre();
}

public void actionMenu2Item2(){ 
    cube();  rotationInitiale();
    tracerPolyedre();  
}

public void actionMenu2Item3(){ 
    octaedre();  rotationInitiale();
    tracerPolyedre();  
}

public void actionMenu2Item4(){    
    icosaedre(); rotationInitiale();
    tracerPolyedre();
}

public void actionMenu2Item5(){   
    dodecaedre();  rotationInitiale();
    tracerPolyedre();
}

public void actionMenu3Item1(){    
    modeTrace = 1;
    tracerPolyedre(); 
}

public void actionMenu3Item2(){  
    modeTrace = 2;
    tracerPolyedre();   
}

public void actionMenu3Item3(){   
    modeTrace = 3;
    tracerPolyedre();  
}

public void actionMenu3Item4(){   
    modeTrace = 4;
    tracerPolyedre();  
}

public void actionMenu4Item1(){    
}

public void actionMenu4Item2(){    
}

// etc..
/*************** Les actions des glissieres *********************************/  
public void actionGlissiere1(double d){
    tracerPolyedre();
}

// etc..
/**************** Les actions de la souris *******************************/
    
    public void clicSouris(double x, double y){
        
    }
    
    public void debutGlisser(double x, double y){
        double z = rayon*rayon - (x*x+y*y); if (z<=0) {z=0;} else {z=sqrt(z);};
        double d = sqrt(x*x+y*y+z*z); u[0]=x/d; u[1]=y/d; u[2]=z/d;
    }
    
    public void glisserEnCours(double x, double y){
        finGlisser(x,y);
    }
    
    public void finGlisser(double x, double y){
        double z = rayon*rayon - (x*x+y*y); if (z<=0) {z=0;} else {z=sqrt(z);};
        double d = sqrt(x*x+y*y+z*z); v[0]=x/d; v[1]=y/d; v[2]=z/d;
        w[0]=u[1]*v[2]-u[2]*v[1]; w[1]=-u[0]*v[2]+u[2]*v[0]; w[2]=u[0]*v[1]-u[1]*v[0];
        double sinus=sqrt(w[0]*w[0]+w[1]*w[1]+w[2]*w[2]); double cosinus=u[0]*v[0]+u[1]*v[1]+u[2]*v[2];
        if (sinus != 0) {
            w[0]=w[0]/sinus; w[1]=w[1]/sinus; w[2]=w[2]/sinus; sinus=-sinus;
            delta[0][0]=w[0]*w[0]+(1-w[0]*w[0])*cosinus; delta[0][1]=w[0]*w[1]*(1-cosinus)-w[2]*sinus; delta[0][2]=w[0]*w[2]*(1-cosinus)+w[1]*sinus;
            delta[1][0]=w[0]*w[1]*(1-cosinus)+w[2]*sinus; delta[1][1]=w[1]*w[1]+(1-w[1]*w[1])*cosinus; delta[1][2]=w[1]*w[2]*(1-cosinus)-w[0]*sinus;
            delta[2][0]=w[0]*w[2]*(1-cosinus)-w[1]*sinus; delta[2][1]=w[1]*w[2]*(1-cosinus)+w[0]*sinus; delta[2][2]=w[2]*w[2]+(1-w[2]*w[2])*cosinus;
            nouvelleRotation();
            u[0]=v[0]; u[1]=v[1]; u[2]=v[2];
        }
    }
/********************* Changement de taille de la fenetre *******************/ 
    public void actionTailleChange(){
        fixeOrigineTortue(largeurZoneGraphique()/2.0 , hauteurZoneGraphique()/2.0);
        tracerPolyedre();
    }
/***************************************************************************
 * 
 *                  NE PAS MODIFIER CETTE SECTION 
 *                  
 **************************************************************************/    
     
    public static String[][] Menus = {nomsMenus1, nomsMenus2, nomsMenus3, nomsMenus4, nomsMenus5, nomsMenus6, nomsMenus7, nomsMenus8};    
    
    public Polyedres(int l, int h, String titre, String[] nomsBoutons1, String[] nomsBoutons2, String[][] Menus, boolean avecTexte){
        super(l, h, titre, nomsBoutons1, nomsBoutons2, Menus, avecTexte);
    }
    
    public Polyedres() {
        this(baseFenetre, hauteurFenetre, titreFenetre, nomsBoutonsLigne1, nomsBoutonsLigne2, Menus, zoneTexte);
    }
    
    public static void executer(boolean applet){
        initGlissieres();
        ajoutDeGlissieres();
        Polyedres maFenetre = new Polyedres();
        faireApplet(applet);
        maFenetre.toFront();
        maFenetre.initialisation();
    }
    
    public static void main(String[] args){
        javax.swing.SwingUtilities.invokeLater(new Runnable(){
            public void run(){
                executer(false);
            }
        });
    }

     
}  
